/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.Band;
import org.marsik.ham.adif.enums.Propagation;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.contacts.Qsos;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.adif3.transform.ActivityProcessor;
import uk.m0nom.adifproc.adif3.transform.Adif3RecordTransformer;
import uk.m0nom.adifproc.adif3.transform.AdifQrzEnricher;
import uk.m0nom.adifproc.adif3.transform.SotaMicrowaveAward;
import uk.m0nom.adifproc.adif3.transform.TransformResults;
import uk.m0nom.adifproc.adif3.transform.comment.CommentTransformer;
import uk.m0nom.adifproc.adif3.transform.comment.FieldParserCommentTransformer;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.geocoding.GeocodingProvider;
import uk.m0nom.adifproc.geocoding.GeocodingResult;
import uk.m0nom.adifproc.geocoding.NominatimGeocodingProvider;
import uk.m0nom.adifproc.location.FromLocationDeterminer;
import uk.m0nom.adifproc.location.ToLocationDeterminer;
import uk.m0nom.adifproc.maidenheadlocator.MaidenheadLocatorConversion;
import uk.m0nom.adifproc.qrz.CachingQrzXmlService;
import uk.m0nom.adifproc.qrz.QrzCallsign;
import uk.m0nom.adifproc.satellite.ApSatellite;
import uk.m0nom.adifproc.satellite.ApSatelliteService;

@Service
public class CommentParsingAdifRecordTransformer
implements Adif3RecordTransformer {
    private static final Logger logger = Logger.getLogger(CommentParsingAdifRecordTransformer.class.getName());
    private final ActivityDatabaseService activities;
    private final CachingQrzXmlService qrzXmlService;
    private final AdifQrzEnricher enricher;
    private final FromLocationDeterminer fromLocationDeterminer;
    private final ToLocationDeterminer toLocationDeterminer;
    private final ActivityProcessor activityProcessor;
    private final GeocodingProvider geocodingProvider;
    private final CommentTransformer commentTransformer;
    private final ApSatelliteService apSatelliteService;

    public CommentParsingAdifRecordTransformer(ActivityDatabaseService activities, CachingQrzXmlService qrzXmlService, FieldParserCommentTransformer commentTransformer, FromLocationDeterminer fromLocationDeterminer, ToLocationDeterminer toLocationDeterminer, ActivityProcessor activityProcessor, NominatimGeocodingProvider geocodingProvider, ApSatelliteService apSatelliteService) {
        this.activities = activities;
        this.qrzXmlService = qrzXmlService;
        this.enricher = new AdifQrzEnricher(qrzXmlService);
        this.apSatelliteService = apSatelliteService;
        this.fromLocationDeterminer = fromLocationDeterminer;
        this.toLocationDeterminer = toLocationDeterminer;
        this.activityProcessor = activityProcessor;
        this.geocodingProvider = geocodingProvider;
        this.commentTransformer = commentTransformer;
    }

    private void processSotaRef(Qso qso, TransformResults results) {
        Adif3Record rec = qso.getRecord();
        if (rec.getSotaRef() != null && StringUtils.isNotBlank((CharSequence)rec.getSotaRef().getValue())) {
            String sotaId = rec.getSotaRef().getValue();
            Activity activity = this.activities.getDatabase(ActivityType.SOTA).get(sotaId);
            if (activity != null) {
                qso.getTo().addActivity(activity);
                String result = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.SOTA, sotaId);
                if (result != null) {
                    results.addContactWithDubiousLocation(result);
                }
            } else {
                results.addContactWithDubiousLocation(String.format("%s (SOTA %s invalid)", qso.getTo().getCallsign(), sotaId));
            }
        }
    }

    private void processRailwaysOnTheAirCallsign(Qso qso, TransformResults results) {
        Adif3Record rec = qso.getRecord();
        Activity rotaInfo = this.activities.getDatabase(ActivityType.ROTA).get(rec.getCall().toUpperCase());
        if (rotaInfo != null) {
            String result = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.ROTA, rotaInfo.getRef());
            if (result != null) {
                results.addContactWithDubiousLocation(result);
            }
            qso.getTo().addActivity(rotaInfo);
        }
    }

    private void setMyInfoFromQrz(TransformControl control, Qso qso) {
        QrzCallsign myQrzData = this.qrzXmlService.getCallsignData(qso.getRecord().getStationCallsign());
        this.fromLocationDeterminer.setMyLocation(control, qso, myQrzData);
        qso.getFrom().setQrzInfo(myQrzData);
        this.enricher.enrichAdifForMe(qso.getRecord(), myQrzData);
    }

    private QrzCallsign setTheirInfoFromQrz(Qso qso) {
        QrzCallsign theirQrzData = this.qrzXmlService.getCallsignData(qso.getTo().getCallsign());
        qso.getTo().setQrzInfo(theirQrzData);
        this.enricher.enrichAdifForThem(qso.getRecord(), theirQrzData);
        return theirQrzData;
    }

    private void processSatelliteInfo(TransformControl control, Qso qso) {
        Adif3Record rec = qso.getRecord();
        if (StringUtils.isBlank((CharSequence)control.getSatelliteBand()) || rec.getBand() == Band.findByCode(control.getSatelliteBand().toLowerCase())) {
            if (StringUtils.isNotBlank((CharSequence)control.getSatelliteMode())) {
                rec.setSatMode(control.getSatelliteMode().toUpperCase());
            }
            if (StringUtils.isNotBlank((CharSequence)control.getSatelliteName())) {
                rec.setSatName(control.getSatelliteName().toUpperCase());
                rec.setPropMode(Propagation.SATELLITE);
            }
        }
    }

    private boolean hasValidGridsquareNoCoords(Adif3Record rec) {
        return rec.getCoordinates() == null && MaidenheadLocatorConversion.isAValidGridSquare(rec.getGridsquare()) && !MaidenheadLocatorConversion.isADubiousGridSquare(rec.getGridsquare());
    }

    private boolean setCoordinatesFromGridsquare(Qso qso) {
        Adif3Record rec = qso.getRecord();
        try {
            GlobalCoords3D coords = MaidenheadLocatorConversion.locatorToCoords(LocationSource.OVERRIDE, rec.getGridsquare());
            rec.setCoordinates(coords);
            qso.getTo().setCoordinates(coords);
            qso.getTo().setGrid(rec.getGridsquare());
        }
        catch (UnsupportedOperationException e) {
            logger.warning(String.format("For QSO with %s: %s", qso.getTo().getCallsign(), e.getMessage()));
            return false;
        }
        return true;
    }

    private boolean hasNoValidGridsquareOrCoords(Adif3Record rec) {
        return rec.getCoordinates() == null && (!MaidenheadLocatorConversion.isAValidGridSquare(rec.getGridsquare()) || MaidenheadLocatorConversion.isADubiousGridSquare(rec.getGridsquare()));
    }

    private void setTheirLocationFromGeocodedAddress(Qso qso, QrzCallsign theirQrzData) {
        Adif3Record rec = qso.getRecord();
        try {
            GeocodingResult result = this.geocodingProvider.getLocationFromAddress(theirQrzData);
            rec.setCoordinates(result.getCoordinates());
            qso.getTo().setCoordinates(result.getCoordinates());
            if (rec.getCoordinates() != null) {
                logger.info(String.format("Location for %s set based on geolocation data to: %s", rec.getCall(), rec.getCoordinates()));
                if (MaidenheadLocatorConversion.isEmptyOrInvalid(rec.getGridsquare())) {
                    rec.setGridsquare(MaidenheadLocatorConversion.coordsToLocator(rec.getCoordinates()));
                }
            }
        }
        catch (Exception e) {
            logger.severe(String.format("Caught Exception from Geolocation Provider looking up %s: %s", rec.getCall(), e.getMessage()));
        }
    }

    private boolean coordsAreZero(GlobalCoordinates coords) {
        return coords.getLatitude() == 0.0 && coords.getLongitude() == 0.0;
    }

    private void nullCoordsIfZero(Adif3Record rec) {
        if (rec.getCoordinates() != null && this.coordsAreZero(rec.getCoordinates())) {
            rec.setCoordinates(null);
        }
        if (rec.getMyCoordinates() != null && this.coordsAreZero(rec.getMyCoordinates())) {
            rec.setMyCoordinates(null);
        }
    }

    @Override
    public void transform(TransformControl control, TransformResults results, Qsos qsos, Adif3Record rec, int index) {
        HashMap<String, String> unmapped = new HashMap<String, String>();
        results.getSatelliteActivity().setSatellites(this.apSatelliteService);
        this.nullCoordsIfZero(rec);
        Qso qso = new Qso(rec, index);
        qsos.addQso(qso);
        this.activityProcessor.processActivities(control, qso.getFrom(), rec);
        this.setMyInfoFromQrz(control, qso);
        QrzCallsign theirQrzData = this.setTheirInfoFromQrz(qso);
        this.processSotaRef(qso, results);
        this.processRailwaysOnTheAirCallsign(qso, results);
        this.processSatelliteInfo(control, qso);
        this.commentTransformer.transformComment(qso, rec.getComment(), unmapped, results);
        if (rec.getCoordinates() == null && rec.getGridsquare() == null) {
            this.enricher.lookupLocationFromQrz(qso);
        }
        if (this.hasValidGridsquareNoCoords(rec) && !this.setCoordinatesFromGridsquare(qso)) {
            results.addContactWithDubiousLocation(String.format("%s (Locator %s invalid)", qso.getTo().getCallsign(), rec.getGridsquare()));
        }
        if (this.hasNoValidGridsquareOrCoords(rec) && theirQrzData != null) {
            this.setTheirLocationFromGeocodedAddress(qso, theirQrzData);
        }
        if (StringUtils.isNotBlank((CharSequence)rec.getSig())) {
            this.processSig(qso, unmapped);
        }
        if (control.isStripComment()) {
            if (!unmapped.isEmpty()) {
                this.addUnmappedToRecord(rec, unmapped);
            } else {
                rec.setComment("");
            }
        }
        if (control.isSotaMicrowaveAwardComment()) {
            SotaMicrowaveAward.addSotaMicrowaveAwardToComment(rec);
        }
        if (rec.getSatName() != null) {
            if (this.apSatelliteService.isAKnownSatellite(rec.getSatName())) {
                ApSatellite satellite = this.apSatelliteService.getSatellite(rec.getSatName());
                if (satellite.isGeostationary() || this.apSatelliteService.getEarliestDataAvailable().isBefore(rec.getQsoDate())) {
                    results.getSatelliteActivity().recordSatelliteActivity(qso);
                } else {
                    results.addUnknownSatellitePass(String.format("%s: %s", rec.getSatName(), rec.getQsoDate()));
                }
            } else {
                results.addUnknownSatellite(rec.getSatName());
            }
        }
    }

    private void processSig(Qso qso, Map<String, String> unmapped) {
        Activity activity;
        ActivityDatabase database;
        Adif3Record rec = qso.getRecord();
        String activityType = rec.getSig().toUpperCase();
        String activityLocation = rec.getSigInfo().toUpperCase();
        if (StringUtils.isNotBlank((CharSequence)activityType) && (database = this.activities.getDatabase(activityType)) != null && (activity = database.get(activityLocation)) != null) {
            qso.getTo().addActivity(activity);
            if (rec.getSotaRef() == null || StringUtils.isBlank((CharSequence)rec.getSotaRef().getValue())) {
                this.toLocationDeterminer.setTheirLocationFromActivity(qso, activity);
            }
            unmapped.put(activityType, activityLocation);
        }
    }

    private void addUnmappedToRecord(Adif3Record rec, Map<String, String> unmapped) {
        StringBuilder sb = new StringBuilder();
        Set<String> keySet = unmapped.keySet();
        int keySetLen = keySet.size();
        int i = 1;
        for (String key : unmapped.keySet()) {
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                sb.append(String.format("%s: %s", key, unmapped.get(key)));
                if (i++ >= keySetLen) continue;
                sb.append(", ");
                continue;
            }
            sb.append(String.format("%s ", key));
        }
        rec.setComment(sb.toString());
    }
}

