/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform.comment.parsers;

import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.ActivityFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.AntPathFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.BandRxFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.CommentFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.CoordinatesFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.FistsFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.GridSquareFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.IotaFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.LatitudeParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.LongitudeParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.NameFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.NotesFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.OperatorFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.PropagationFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.QslFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.QthFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.RigFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.RxPwrFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.SatelliteModeFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.SatelliteNameFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.SerialRxFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.SerialTxFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.SkccFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.SotaRefFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.WebFieldParser;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.WotaFieldParser;
import uk.m0nom.adifproc.coords.LocationParsingService;
import uk.m0nom.adifproc.location.ToLocationDeterminer;
import uk.m0nom.adifproc.satellite.ApSatelliteService;

@Service
public class CommentFieldParserFactory {
    private final Map<String, CommentFieldParser> parserMap = new HashMap<String, CommentFieldParser>();

    public CommentFieldParserFactory(ActivityDatabaseService activities, ToLocationDeterminer toLocationDeterminer, LocationParsingService locationParsingService, ApSatelliteService apSatelliteService) {
        this.parserMap.put("Name", new NameFieldParser());
        this.parserMap.put("Operator", new OperatorFieldParser());
        this.parserMap.put("Qth", new QthFieldParser());
        this.parserMap.put("Rig", new RigFieldParser());
        this.parserMap.put("Iota", new IotaFieldParser());
        this.parserMap.put("GridSquare", new GridSquareFieldParser());
        this.parserMap.put("RxPwr", new RxPwrFieldParser());
        this.parserMap.put("BandRx", new BandRxFieldParser());
        this.parserMap.put("SotaRef", new SotaRefFieldParser(toLocationDeterminer, activities));
        this.parserMap.put("WotaRef", new WotaFieldParser(toLocationDeterminer, activities));
        this.parserMap.put("GmaRef", new ActivityFieldParser(toLocationDeterminer, activities, ActivityType.GMA));
        this.parserMap.put("HemaRef", new ActivityFieldParser(toLocationDeterminer, activities, ActivityType.HEMA));
        this.parserMap.put("PotaRef", new ActivityFieldParser(toLocationDeterminer, activities, ActivityType.POTA));
        this.parserMap.put("CotaRef", new ActivityFieldParser(toLocationDeterminer, activities, ActivityType.COTA));
        this.parserMap.put("WwffRef", new ActivityFieldParser(toLocationDeterminer, activities, ActivityType.WWFF));
        this.parserMap.put("SerialTx", new SerialTxFieldParser());
        this.parserMap.put("SerialRx", new SerialRxFieldParser());
        this.parserMap.put("Fists", new FistsFieldParser());
        this.parserMap.put("Skcc", new SkccFieldParser());
        this.parserMap.put("Qsl", new QslFieldParser());
        this.parserMap.put("Coordinates", new CoordinatesFieldParser(locationParsingService));
        this.parserMap.put("Latitude", new LatitudeParser());
        this.parserMap.put("Longitude", new LongitudeParser());
        this.parserMap.put("AntPath", new AntPathFieldParser());
        this.parserMap.put("Propagation", new PropagationFieldParser());
        this.parserMap.put("SatelliteName", new SatelliteNameFieldParser(apSatelliteService));
        this.parserMap.put("SatelliteMode", new SatelliteModeFieldParser());
        this.parserMap.put("Notes", new NotesFieldParser());
        this.parserMap.put("Web", new WebFieldParser());
    }

    public CommentFieldParser get(String name) {
        return this.parserMap.get(name);
    }
}

