/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform.tokenizer;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.adif3.transform.tokenizer.CommentTokenizer;

@Service
public class ColonTokenizer
implements CommentTokenizer {
    @Override
    public Map<String, String> tokenize(String comment) {
        LinkedHashMap<String, String> tokens = new LinkedHashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(comment, ":");
        String previousToken = "";
        while (tokenizer.hasMoreTokens()) {
            String key;
            String token = tokenizer.nextToken().trim();
            if ("".equals(previousToken)) {
                key = token;
                if (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken().trim();
                }
            } else {
                key = this.getKeyFromPrevious(previousToken);
            }
            String value = token;
            if (tokenizer.hasMoreTokens()) {
                value = this.getValueFromCurrent(token);
            }
            previousToken = token;
            tokens.put(key.trim().toUpperCase(), value.trim());
        }
        return tokens;
    }

    private String getValueFromCurrent(String token) {
        Pattern pattern = Pattern.compile("(.*)[,\\s]+\\S+");
        Matcher matcher = pattern.matcher(token);
        String value = token;
        if (matcher.matches() && (value = matcher.group(1)).endsWith(",")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private String getKeyFromPrevious(String previous) {
        Pattern pattern = Pattern.compile(".*[,\\s](\\S+)");
        Matcher matcher = pattern.matcher(previous);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }
}

