/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.callsign;

import java.util.List;
import uk.m0nom.adifproc.callsign.CallsignSuffix;
import uk.m0nom.adifproc.callsign.CallsignUtils;
import uk.m0nom.adifproc.callsign.CallsignVariant;
import uk.m0nom.adifproc.callsign.OperatorLocation;

public class Callsign {
    private String callsign;
    private CallsignVariant variant;
    private List<Callsign> variants;
    private CallsignSuffix suffix;
    private OperatorLocation location;

    public Callsign(String callsign, CallsignVariant variant) {
        this(callsign, variant, false);
    }

    public Callsign(String callsign, CallsignVariant variant, boolean checkForVariants) {
        this.callsign = callsign.toUpperCase();
        this.variant = variant;
        if (checkForVariants) {
            this.variants = CallsignUtils.getCallsignVariants(this.getCallsign());
        }
    }

    public String toString() {
        return this.callsign;
    }

    public String getCallsign() {
        return this.callsign;
    }

    public CallsignVariant getVariant() {
        return this.variant;
    }

    public List<Callsign> getVariants() {
        return this.variants;
    }

    public CallsignSuffix getSuffix() {
        return this.suffix;
    }

    public OperatorLocation getLocation() {
        return this.location;
    }

    public void setCallsign(String callsign) {
        this.callsign = callsign;
    }

    public void setVariant(CallsignVariant variant) {
        this.variant = variant;
    }

    public void setVariants(List<Callsign> variants) {
        this.variants = variants;
    }

    public void setSuffix(CallsignSuffix suffix) {
        this.suffix = suffix;
    }

    public void setLocation(OperatorLocation location) {
        this.location = location;
    }
}

