/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.callsign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import uk.m0nom.adifproc.callsign.Callsign;
import uk.m0nom.adifproc.callsign.CallsignSuffix;
import uk.m0nom.adifproc.callsign.CallsignVariant;

public class CallsignUtils {
    public static final Collection<CallsignSuffix> SUFFIXES = new ArrayList<CallsignSuffix>(List.of(CallsignSuffix.PORTABLE, CallsignSuffix.MOBILE, CallsignSuffix.MARITIME_MOBILE, CallsignSuffix.PEDESTRIAN_MOBILE, CallsignSuffix.ALTERNATIVE_ADDRESS, CallsignSuffix.QRP));
    private static final List<CallsignRegexMap> UK_CALLSIGN_REGEXS = new ArrayList<CallsignRegexMap>(List.of(new CallsignRegexMap(CallsignVariant.G_ALT, Pattern.compile("^[GM][0-9]", 2)), new CallsignRegexMap(CallsignVariant.GM_ALT, Pattern.compile("^[GM]M[0-9]", 2)), new CallsignRegexMap(CallsignVariant.GG_ALT, Pattern.compile("^[GM]G[0-9]", 2)), new CallsignRegexMap(CallsignVariant.GI_ALT, Pattern.compile("^[GM]I[0-9]", 2)), new CallsignRegexMap(CallsignVariant.GW_ALT, Pattern.compile("^[GM]W[0-9]", 2))));

    private static Callsign gToGxVariant(Callsign ukVariant, CallsignVariant variant) {
        String callsign = ukVariant.getCallsign();
        String variantCallsign = ukVariant.getVariant() == CallsignVariant.G_ALT ? String.format("%s%s%s", Character.valueOf(callsign.charAt(0)), variant.getModifier(), callsign.substring(1)) : String.format("%s%s%s", Character.valueOf(callsign.charAt(0)), variant.getModifier(), callsign.substring(2));
        return new Callsign(variantCallsign, variant);
    }

    public static List<Callsign> getUkCallsignVariants(String callsign) {
        ArrayList<Callsign> ukVariants = new ArrayList<Callsign>();
        Callsign ukVariant = null;
        for (CallsignRegexMap callsignRegex : UK_CALLSIGN_REGEXS) {
            Matcher matcher = callsignRegex.pattern.matcher(callsign);
            if (!matcher.find()) continue;
            ukVariant = new Callsign(callsign, callsignRegex.variant);
        }
        if (ukVariant != null) {
            switch (ukVariant.getVariant()) {
                case G_ALT: {
                    ukVariants.add(new Callsign(callsign, CallsignVariant.G_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GD_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GG_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GI_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GM_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GW_ALT));
                    break;
                }
                case GM_ALT: {
                    ukVariants.add(new Callsign(callsign, CallsignVariant.GM_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.G_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GD_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GG_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GI_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GW_ALT));
                    break;
                }
                case GW_ALT: {
                    ukVariants.add(new Callsign(callsign, CallsignVariant.GW_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.G_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GD_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GG_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GI_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GM_ALT));
                    break;
                }
                case GG_ALT: {
                    ukVariants.add(new Callsign(callsign, CallsignVariant.GG_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.G_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GD_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GI_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GM_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GW_ALT));
                    break;
                }
                case GI_ALT: {
                    ukVariants.add(new Callsign(callsign, CallsignVariant.GI_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.G_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GD_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GG_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GM_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GW_ALT));
                    break;
                }
                case GD_ALT: {
                    ukVariants.add(new Callsign(callsign, CallsignVariant.GD_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.G_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GG_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GI_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GM_ALT));
                    ukVariants.add(CallsignUtils.gToGxVariant(ukVariant, CallsignVariant.GW_ALT));
                }
            }
        }
        return ukVariants;
    }

    public static List<Callsign> getCallsignVariants(String callsign) {
        List<Callsign> variants = new ArrayList<Callsign>();
        Callsign portableInCountry = new Callsign(callsign, CallsignVariant.IN_COUNTRY);
        variants.add(portableInCountry);
        Callsign fixedInCountry = CallsignUtils.getOperatorWithoutSuffix(callsign);
        Callsign portableInHomeCountry = CallsignUtils.getOperatorAsIsInHomeCountry(callsign);
        Callsign fixedInHomeCountry = null;
        if (portableInHomeCountry != null && !portableInCountry.getCallsign().equals(portableInHomeCountry.getCallsign())) {
            variants.add(portableInHomeCountry);
        }
        if (fixedInCountry != null) {
            variants.add(fixedInCountry);
        }
        if (fixedInCountry != null) {
            fixedInHomeCountry = CallsignUtils.getOperatorWithoutCountryPrefix(fixedInCountry.getCallsign());
            if (!fixedInCountry.getCallsign().equals(fixedInHomeCountry.getCallsign())) {
                variants.add(fixedInHomeCountry);
            }
        }
        variants.addAll(CallsignUtils.getUkCallsignVariants(callsign));
        if (portableInHomeCountry != null && !portableInCountry.getCallsign().equals(portableInHomeCountry.getCallsign())) {
            variants.addAll(CallsignUtils.getUkCallsignVariants(portableInHomeCountry.getCallsign()));
        }
        if (fixedInHomeCountry != null) {
            variants.addAll(CallsignUtils.getUkCallsignVariants(fixedInHomeCountry.getCallsign()));
        }
        variants = CallsignUtils.dedup(variants);
        return variants;
    }

    private static List<Callsign> dedup(List<Callsign> variants) {
        HashMap<String, Callsign> callsignMap = new HashMap<String, Callsign>();
        for (Callsign callsign : variants) {
            if (callsignMap.containsKey(callsign.getCallsign())) continue;
            callsignMap.put(callsign.getCallsign(), callsign);
        }
        ArrayList<Callsign> deduped = new ArrayList<Callsign>(callsignMap.size());
        for (Callsign callsign : variants) {
            if (!callsignMap.containsKey(callsign.getCallsign())) continue;
            deduped.add(callsign);
            callsignMap.remove(callsign.getCallsign());
        }
        return deduped;
    }

    private static Callsign getOperatorAsIsInHomeCountry(String callsign) {
        CallsignSuffix suffix = CallsignUtils.getSuffix(callsign);
        if (suffix != null) {
            String portableHomeCountry = CallsignUtils.stripCountryPrefix(callsign);
            return new Callsign(portableHomeCountry, CallsignVariant.HOME_COUNTRY);
        }
        return null;
    }

    private static Callsign getOperatorWithoutCountryPrefix(String fixedInCountry) {
        if (CallsignUtils.isAbroad(fixedInCountry)) {
            String homeCallsign = CallsignUtils.stripCountryPrefix(fixedInCountry);
            return new Callsign(homeCallsign, CallsignVariant.HOME_COUNTRY);
        }
        return new Callsign(fixedInCountry, CallsignVariant.HOME_COUNTRY);
    }

    private static Callsign getOperatorWithoutSuffix(String callsign) {
        String fixedCallsign = CallsignUtils.stripSuffix(callsign);
        if (!StringUtils.equalsIgnoreCase((CharSequence)fixedCallsign, (CharSequence)callsign)) {
            return new Callsign(fixedCallsign, CallsignVariant.IN_COUNTRY);
        }
        return null;
    }

    public static boolean containsCallsign(List<Callsign> variants, String callsign) {
        for (Callsign op : variants) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)op.getCallsign(), (CharSequence)callsign)) continue;
            return true;
        }
        return false;
    }

    public static String stripSuffix(String callsign) {
        CallsignSuffix suffix = CallsignUtils.getSuffix(callsign);
        if (suffix != null) {
            return callsign.substring(0, callsign.length() - suffix.getSuffix().length());
        }
        return callsign;
    }

    public static CallsignSuffix getSuffix(String callsign) {
        int loc = callsign.lastIndexOf(47);
        if (loc != -1) {
            String suffix = callsign.substring(loc);
            for (CallsignSuffix match : SUFFIXES) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)match.getSuffix(), (CharSequence)suffix)) continue;
                return match;
            }
        }
        return null;
    }

    public static boolean isAbroad(String callsign) {
        int loc = callsign.indexOf(47);
        if (loc != -1) {
            CallsignSuffix suffix = CallsignUtils.getSuffix(callsign);
            if (suffix != null) {
                return !StringUtils.equals((CharSequence)callsign.substring(loc), (CharSequence)suffix.getSuffix());
            }
            return true;
        }
        return false;
    }

    public static String stripCountryPrefix(String callsign) {
        if (CallsignUtils.isAbroad(callsign)) {
            int loc = callsign.indexOf(47);
            return callsign.substring(loc + 1);
        }
        return callsign;
    }

    private static class CallsignRegexMap {
        CallsignVariant variant;
        Pattern pattern;

        public CallsignRegexMap(CallsignVariant variant, Pattern pattern) {
            this.variant = variant;
            this.pattern = pattern;
        }
    }
}

