/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.comms.ionosphere;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.Adif3Record;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.comms.CommsLinkGenerator;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.comms.PropagationApex;
import uk.m0nom.adifproc.comms.ionosphere.IonosphereUtils;
import uk.m0nom.adifproc.comms.ionosphere.IonosphericApexCalculator;
import uk.m0nom.adifproc.coords.GlobalCoords3D;

public class LongPath
implements CommsLinkGenerator {
    private static final Logger logger = Logger.getLogger(LongPath.class.getName());

    @Override
    public CommsLinkResult getCommunicationsLink(TransformControl control, GlobalCoords3D start, GlobalCoords3D end, Adif3Record rec) {
        CommsLinkResult shortPathResult = IonosphereUtils.getShortestPath(control, start, end, rec);
        GeodeticCalculator calculator = new GeodeticCalculator();
        GeodeticCurve shortestPath = calculator.calculateGeodeticCurve(Ellipsoid.WGS84, (GlobalCoordinates)start, (GlobalCoordinates)end);
        double longPathBearing = IonosphereUtils.normalisedAngleAddition(shortestPath.getAzimuth(), 180.0);
        double[] endBearing = new double[1];
        int steps = 0;
        double distanceToTargetStation = Double.MAX_VALUE;
        double currentBearing = longPathBearing;
        GlobalCoords3D stepLocation = start;
        double stepDistance = 100000.0;
        while (distanceToTargetStation >= stepDistance) {
            stepLocation = calculator.calculateEndingGlobalCoordinates(Ellipsoid.WGS84, (GlobalCoordinates)stepLocation, currentBearing, stepDistance, endBearing);
            GeodeticCurve shortestPathFromStepToTargetStation = calculator.calculateGeodeticCurve(Ellipsoid.WGS84, (GlobalCoordinates)stepLocation, (GlobalCoordinates)end);
            distanceToTargetStation = shortestPathFromStepToTargetStation.getEllipsoidalDistance();
            currentBearing = IonosphereUtils.normaliseAngle(endBearing[0]);
            logger.info(String.format("%d: bearing: %.3f, distanceToTargetStation: %.0f", ++steps, currentBearing, distanceToTargetStation));
        }
        double totalDistance = stepDistance * (double)steps + distanceToTargetStation;
        double takeOffAngle = control.getAntenna().getTakeOffAngle();
        PropagationApex apex = IonosphericApexCalculator.calculateDistanceOfApex(shortPathResult.getAltitude() / 1000.0, takeOffAngle);
        double longPathBounceDistance = IonosphericApexCalculator.calculateDistanceAcrossEarth(apex) * 2.0;
        int bounces = (int)(totalDistance / (longPathBounceDistance * 1000.0));
        int stepCount = ++bounces * 2;
        double longPathStepDistance = totalDistance / (double)stepCount;
        CommsLinkResult result = new CommsLinkResult();
        double reflectionAltitude = shortPathResult.getAltitude();
        result.setAltitude(reflectionAltitude);
        result.setAzimuth(longPathBearing);
        result.setDistanceInKm(totalDistance / 1000.0);
        result.setBounces(stepCount);
        result.setPropagation(shortPathResult.getPropagation());
        result.setStart(start);
        result.setEnd(end);
        double takeoffAngle = IonosphericApexCalculator.calculateTakeoffAngleFromDistanceAcrossEarth(longPathStepDistance / 1000.0, reflectionAltitude / 1000.0);
        result.setFromAngle(takeoffAngle);
        double skyDistance = IonosphericApexCalculator.calculateDistanceToIonosphere(reflectionAltitude / 1000.0, takeoffAngle);
        result.setSkyDistance(skyDistance * (double)stepCount);
        ArrayList<GlobalCoords3D> path = new ArrayList<GlobalCoords3D>(result.getBounces());
        currentBearing = longPathBearing;
        path.add(new GlobalCoords3D(start.getLatitude(), start.getLongitude(), 0.0));
        stepLocation = start;
        int bounceCount = stepCount / 2;
        for (int i = 1; i <= bounceCount; ++i) {
            stepLocation = calculator.calculateEndingGlobalCoordinates(Ellipsoid.WGS84, (GlobalCoordinates)stepLocation, currentBearing, longPathStepDistance, endBearing);
            path.add(new GlobalCoords3D(stepLocation.getLatitude(), stepLocation.getLongitude(), reflectionAltitude));
            currentBearing = IonosphereUtils.normaliseAngle(endBearing[0]);
            if (i < bounceCount) {
                stepLocation = calculator.calculateEndingGlobalCoordinates(Ellipsoid.WGS84, (GlobalCoordinates)stepLocation, currentBearing, longPathStepDistance, endBearing);
                path.add(new GlobalCoords3D(stepLocation.getLatitude(), stepLocation.getLongitude(), 0.0));
            }
            if (!((currentBearing = endBearing[0]) < 0.0)) continue;
            currentBearing = 360.0 + currentBearing;
        }
        path.add(new GlobalCoords3D(end.getLatitude(), end.getLongitude(), 0.0));
        result.setPath(path);
        return result;
    }
}

