/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.contest;

import java.util.HashMap;
import java.util.Map;
import org.marsik.ham.adif.Adif3;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.Band;
import org.marsik.ham.adif.enums.Mode;
import org.marsik.ham.adif.enums.Propagation;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.contest.ContestResultCalculator;

public class JackOfAllTradesResultCalculator
implements ContestResultCalculator {
    private final Map<Band, Integer> bandPointsMap = new HashMap<Band, Integer>();
    private final Map<Mode, Integer> modePointsMap = new HashMap<Mode, Integer>();
    private final Map<Propagation, Integer> propPointsMap = new HashMap<Propagation, Integer>();

    public JackOfAllTradesResultCalculator() {
        this.bandPointsMap.put(Band.BAND_2190m, 7);
        this.bandPointsMap.put(Band.BAND_630m, 7);
        this.bandPointsMap.put(Band.BAND_560m, 7);
        this.bandPointsMap.put(Band.BAND_160m, 5);
        this.bandPointsMap.put(Band.BAND_80m, 2);
        this.bandPointsMap.put(Band.BAND_60m, 2);
        this.bandPointsMap.put(Band.BAND_40m, 1);
        this.bandPointsMap.put(Band.BAND_30m, 1);
        this.bandPointsMap.put(Band.BAND_20m, 1);
        this.bandPointsMap.put(Band.BAND_17m, 2);
        this.bandPointsMap.put(Band.BAND_15m, 2);
        this.bandPointsMap.put(Band.BAND_12m, 2);
        this.bandPointsMap.put(Band.BAND_10m, 3);
        this.bandPointsMap.put(Band.BAND_6m, 3);
        this.bandPointsMap.put(Band.BAND_4m, 4);
        this.bandPointsMap.put(Band.BAND_2m, 1);
        this.bandPointsMap.put(Band.BAND_1_25m, 1);
        this.bandPointsMap.put(Band.BAND_70cm, 2);
        this.bandPointsMap.put(Band.BAND_33cm, 4);
        this.bandPointsMap.put(Band.BAND_23cm, 4);
        this.bandPointsMap.put(Band.BAND_13cm, 6);
        this.bandPointsMap.put(Band.BAND_9cm, 11);
        this.bandPointsMap.put(Band.BAND_6cm, 11);
        this.bandPointsMap.put(Band.BAND_3cm, 11);
        this.bandPointsMap.put(Band.BAND_1_25cm, 11);
        this.bandPointsMap.put(Band.BAND_6mm, 11);
        this.bandPointsMap.put(Band.BAND_4mm, 11);
        this.bandPointsMap.put(Band.BAND_2_5mm, 11);
        this.bandPointsMap.put(Band.BAND_2mm, 11);
        this.bandPointsMap.put(Band.BAND_1mm, 11);
        this.modePointsMap.put(Mode.AM, 6);
        this.modePointsMap.put(Mode.ARDOP, 1);
        this.modePointsMap.put(Mode.ATV, 6);
        this.modePointsMap.put(Mode.C4FM, 6);
        this.modePointsMap.put(Mode.CHIP, 1);
        this.modePointsMap.put(Mode.CLO, 1);
        this.modePointsMap.put(Mode.CONTESTI, 1);
        this.modePointsMap.put(Mode.CW, 1);
        this.modePointsMap.put(Mode.DATA, 3);
        this.modePointsMap.put(Mode.DIGITALVOICE, 6);
        this.modePointsMap.put(Mode.DOMINO, 1);
        this.modePointsMap.put(Mode.DSTAR, 6);
        this.modePointsMap.put(Mode.FAX, 1);
        this.modePointsMap.put(Mode.FM, 1);
        this.modePointsMap.put(Mode.FSK441, 1);
        this.modePointsMap.put(Mode.FT8, 0);
        this.modePointsMap.put(Mode.HELL, 1);
        this.modePointsMap.put(Mode.ISCAT, 1);
        this.modePointsMap.put(Mode.JT4, 1);
        this.modePointsMap.put(Mode.JT6M, 1);
        this.modePointsMap.put(Mode.JT9, 1);
        this.modePointsMap.put(Mode.JT44, 1);
        this.modePointsMap.put(Mode.JT65, 1);
        this.modePointsMap.put(Mode.MFSK, 1);
        this.modePointsMap.put(Mode.MSK144, 1);
        this.modePointsMap.put(Mode.MT63, 1);
        this.modePointsMap.put(Mode.OLIVIA, 1);
        this.modePointsMap.put(Mode.OPERA, 1);
        this.modePointsMap.put(Mode.PAC, 1);
        this.modePointsMap.put(Mode.PAX, 1);
        this.modePointsMap.put(Mode.PKT, 1);
        this.modePointsMap.put(Mode.PSK, 1);
        this.modePointsMap.put(Mode.PSK2K, 1);
        this.modePointsMap.put(Mode.Q15, 1);
        this.modePointsMap.put(Mode.QRA64, 1);
        this.modePointsMap.put(Mode.ROS, 1);
        this.modePointsMap.put(Mode.RTTY, 3);
        this.modePointsMap.put(Mode.RTTYM, 3);
        this.modePointsMap.put(Mode.SSB, 1);
        this.modePointsMap.put(Mode.SSTV, 6);
        this.modePointsMap.put(Mode.T10, 1);
        this.modePointsMap.put(Mode.THOR, 1);
        this.modePointsMap.put(Mode.THRB, 1);
        this.modePointsMap.put(Mode.TOR, 1);
        this.modePointsMap.put(Mode.V4, 1);
        this.modePointsMap.put(Mode.VOI, 1);
        this.modePointsMap.put(Mode.WINMOR, 1);
        this.modePointsMap.put(Mode.WSPR, 0);
        this.propPointsMap.put(Propagation.AIRCRAFT_SCATTER, 6);
        this.propPointsMap.put(Propagation.AURORA_E, 6);
        this.propPointsMap.put(Propagation.AURORA, 6);
        this.propPointsMap.put(Propagation.BACK_SCATTER, 1);
        this.propPointsMap.put(Propagation.ECHOLINK, 0);
        this.propPointsMap.put(Propagation.EARTH_MOON_EARTH, 12);
        this.propPointsMap.put(Propagation.SPORADIC_E, 2);
        this.propPointsMap.put(Propagation.F2_REFLECTION, 1);
        this.propPointsMap.put(Propagation.FIELD_ALIGNED_IRREGULARITIES, 1);
        this.propPointsMap.put(Propagation.INTERNET, 0);
        this.propPointsMap.put(Propagation.IONOSCATTER, 1);
        this.propPointsMap.put(Propagation.IRLP, 0);
        this.propPointsMap.put(Propagation.METEOR_SCATTER, 6);
        this.propPointsMap.put(Propagation.REPEATER, 0);
        this.propPointsMap.put(Propagation.RAIN_SCATTER, 1);
        this.propPointsMap.put(Propagation.SATELLITE, 6);
        this.propPointsMap.put(Propagation.TRANSEQUATORIAL, 1);
        this.propPointsMap.put(Propagation.TROPOSPHERIC_DUCTING, 1);
    }

    @Override
    public int calculateResult(ActivityDatabaseService databases, Adif3 log) {
        int totalPoints = 0;
        for (Adif3Record record : log.getRecords()) {
            if (record.getMySotaRef() == null || !record.getMySotaRef().getValue().startsWith("G/LD")) continue;
            totalPoints += this.calculatePoints(record);
        }
        return totalPoints;
    }

    @Override
    public String formatResult(int points) {
        return String.format("JackOfAllTrades: %d", points);
    }

    private int calculatePoints(Adif3Record record) {
        int bandPoints = 1;
        if (record.getBand() != null) {
            bandPoints = this.bandPointsMap.get(record.getBand());
        }
        int modePoints = 1;
        if (record.getMode() != null) {
            modePoints = this.modePointsMap.get(record.getMode());
        }
        int propPoints = 1;
        if (record.getPropMode() != null) {
            propPoints = this.propPointsMap.get(record.getPropMode());
        }
        return bandPoints * modePoints * propPoints;
    }
}

