/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.coords;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LatLongUtils;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationFormatter;
import uk.m0nom.adifproc.coords.LocationParser;
import uk.m0nom.adifproc.coords.LocationSource;

public class DegreesDecimalMinutesLatLongParser
implements LocationParser,
LocationFormatter {
    private static final Pattern PATTERN = Pattern.compile("([-+]*)(\\d+)[^\\d]+(\\d+\\.\\d+)'*\\s+([-+]*)(\\d+)[^\\d]+(\\d+\\.\\d+)'*");

    @Override
    public Pattern getPattern() {
        return PATTERN;
    }

    @Override
    public GlobalCoords3D parse(LocationSource source, String location) {
        Matcher matcher = this.getPattern().matcher(location);
        if (matcher.find()) {
            String latNegative = matcher.group(1);
            String latDegrees = matcher.group(2);
            String latMinutes = matcher.group(3);
            String longNegative = matcher.group(4);
            String longDegrees = matcher.group(5);
            String longMinutes = matcher.group(6);
            Double latitude = LatLongUtils.parseDegreesMinutes(latDegrees, latMinutes, "-".equalsIgnoreCase(latNegative));
            Double longitude = LatLongUtils.parseDegreesMinutes(longDegrees, longMinutes, "-".equalsIgnoreCase(longNegative));
            return new GlobalCoords3D((double)latitude, (double)longitude, source, LocationAccuracy.LAT_LONG);
        }
        return null;
    }

    @Override
    public String format(GlobalCoordinates coords) {
        return String.format("%.0f\u00b0 %.3f', %.0f\u00b0 %.3f'", LatLongUtils.getDegreesLat(coords), Math.abs(LatLongUtils.getMinutesLat(coords)), LatLongUtils.getDegreesLong(coords), Math.abs(LatLongUtils.getMinutesLong(coords)));
    }

    @Override
    public String getName() {
        return "Degrees Decimal Minutes Lat/Long";
    }
}

