/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.file;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.file.AwsS3FileUtils;
import uk.m0nom.adifproc.file.InternalFileService;

@Profile(value={"!dev"})
@Service
public class AwsInternalFileService
implements InternalFileService {
    private static final Logger logger = Logger.getLogger(AwsInternalFileService.class.getName());
    private final AwsS3FileUtils awsS3FileUtils;

    public AwsInternalFileService(AwsS3FileUtils awsS3FileUtils) {
        this.awsS3FileUtils = awsS3FileUtils;
    }

    @Override
    public Set<String> getFiles(String filePath) {
        return this.awsS3FileUtils.getFiles(filePath);
    }

    @Override
    public String readFile(String folder, String filePath) {
        return this.awsS3FileUtils.readFile(folder, filePath);
    }

    public void archiveData(String folder, String filename, String content) {
        this.awsS3FileUtils.archiveFile(folder, filename, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveFile(String folder, String filename, String tmpPath, String encoding) {
        FileInputStream out = null;
        if (this.awsS3FileUtils.isConfigured()) {
            String filePath = String.format("%s%s", tmpPath, filename);
            try {
                out = new FileInputStream(filePath);
                String content = IOUtils.toString((InputStream)out, (String)encoding);
                logger.info(String.format("Archiving output file %s", filename));
                this.awsS3FileUtils.archiveFile(folder, filename, content);
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
            }
            finally {
                try {
                    assert (out != null);
                    out.close();
                }
                catch (IOException e) {
                    logger.severe(e.getMessage());
                }
            }
        }
    }
}

