/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.comms;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.LineString;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Style;
import java.time.LocalDate;
import java.time.LocalDateTime;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.icons.IconResource;
import uk.m0nom.adifproc.kml.KmlLineStyle;
import uk.m0nom.adifproc.kml.KmlStyling;
import uk.m0nom.adifproc.kml.KmlUtils;
import uk.m0nom.adifproc.satellite.ApSatellite;
import uk.m0nom.adifproc.satellite.SatelliteActivity;
import uk.m0nom.adifproc.satellite.SatellitePass;
import uk.m0nom.adifproc.satellite.SatellitePassId;

public class KmlSatelliteTrack {
    private static final String SATELLITE_TRACK_LINE_ID = "satellite_track_line";
    private static final String EMPTY_SHADOW_MARKER = "empty_shadow_marker";
    private static final int TRACK_LEAD_LAG_TIME_MINS = 5;

    public void addSatelliteTracks(TransformControl control, Document doc, SatelliteActivity activity, GlobalCoords3D groundStation) {
        String styleUrl = this.addSatelliteTrackStyle(control, doc);
        IconResource icon = IconResource.getSatelliteTrackResource(control);
        Icon kmlIcon = new Icon().withHref(icon.getUrl());
        Style style = doc.createAndAddStyle().withId(KmlUtils.getStyleId(icon.getName()));
        style.createAndSetIconStyle().withScale(1.0).withIcon(kmlIcon);
        style.createAndSetLabelStyle().withColor("ff43b3ff").withScale(1.0);
        Style shadowStyle = doc.createAndAddStyle().withId(KmlUtils.getStyleId(EMPTY_SHADOW_MARKER));
        shadowStyle.createAndSetIconStyle().withScale(0.0).withIcon(kmlIcon);
        shadowStyle.createAndSetLabelStyle().withColor("ff43b3ff").withScale(1.0);
        Folder folder = doc.createAndAddFolder();
        folder.withName("Satellite Tracks").withOpen(Boolean.valueOf(false));
        this.drawSatelliteTracks(control, folder, activity, groundStation, styleUrl, false);
        this.drawSatelliteTracks(control, folder, activity, groundStation, KmlUtils.getStyleId("shadow"), true);
    }

    private void drawSatelliteTracks(TransformControl control, Folder folder, SatelliteActivity activity, GlobalCoords3D groundStation, String styleUrl, boolean shadow) {
        for (SatellitePass pass : activity.getPasses()) {
            SatellitePassId id = pass.getId();
            LocalDate passDate = id.getDate();
            String satName = id.getSatelliteName();
            ApSatellite satellite = activity.getSatellites().getSatellite(satName, passDate);
            Object folderId = pass.getId().toString();
            if (shadow) {
                folderId = (String)folderId + "_shadow";
            }
            Folder passFolder = folder.createAndAddFolder().withName((String)folderId).withOpen(Boolean.valueOf(false));
            LocalDateTime currentContact = pass.getFirstContact().minusMinutes(4L);
            GlobalCoords3D lastPosition = null;
            while (currentContact.isBefore(pass.getLastContact().plusMinutes(5L))) {
                GlobalCoords3D currentPosition = satellite.getPosition(groundStation, currentContact.toLocalDate(), currentContact.toLocalTime());
                if (lastPosition == null) {
                    this.addSatelliteMarker(control, passFolder, satName, passDate, currentPosition, shadow);
                } else {
                    this.drawSatelliteTrack(passFolder, currentContact, lastPosition, currentPosition, styleUrl, shadow);
                }
                lastPosition = currentPosition;
                currentContact = currentContact.plusMinutes(1L);
            }
        }
    }

    private void addSatelliteMarker(TransformControl control, Folder folder, String satName, LocalDate passDate, GlobalCoords3D position, boolean shadow) {
        Placemark placemark = folder.createAndAddPlacemark();
        String date = passDate.toString();
        String id = String.format("%s %s%s", satName, date, shadow ? "_shadow" : "");
        IconResource icon = IconResource.getSatelliteTrackResource(control);
        if (shadow) {
            placemark.withId(id).withStyleUrl(KmlUtils.getStyleUrl(EMPTY_SHADOW_MARKER)).createAndSetPoint().addToCoordinates(position.getLongitude(), position.getLatitude(), 0.0).setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
        } else {
            placemark.withName(id).withId(id).withStyleUrl(KmlUtils.getStyleUrl(icon.getName())).createAndSetLookAt().withLongitude(position.getLongitude()).withLatitude(position.getLatitude()).withAltitude(position.getAltitude().doubleValue()).withRange(500.0);
            placemark.createAndSetPoint().addToCoordinates(position.getLongitude(), position.getLatitude(), position.getAltitude().doubleValue()).setAltitudeMode(AltitudeMode.ABSOLUTE);
        }
    }

    private void drawSatelliteTrack(Folder folder, LocalDateTime currentTime, GlobalCoords3D lastPosition, GlobalCoords3D currentPosition, String styleUrl, boolean shadow) {
        Placemark placemark = folder.createAndAddPlacemark();
        String time = currentTime.toString();
        placemark.withName(time).withId(time).withStyleUrl(styleUrl);
        AltitudeMode mode = AltitudeMode.ABSOLUTE;
        if (shadow) {
            mode = AltitudeMode.RELATIVE_TO_GROUND;
        }
        LineString trackLine = placemark.createAndSetLineString().withAltitudeMode(mode);
        trackLine.addToCoordinates(lastPosition.getLongitude(), lastPosition.getLatitude(), shadow ? 0.0 : lastPosition.getAltitude());
        trackLine.addToCoordinates(currentPosition.getLongitude(), currentPosition.getLatitude(), shadow ? 0.0 : currentPosition.getAltitude());
    }

    private String addSatelliteTrackStyle(TransformControl control, Document doc) {
        String styleId = KmlUtils.getStyleId(SATELLITE_TRACK_LINE_ID);
        KmlLineStyle styling = KmlStyling.getKmlLineStyle(control.getKmlSatelliteTrackLineStyle());
        Style style = doc.createAndAddStyle().withId(styleId);
        assert (styling != null);
        style.createAndSetLineStyle().withColor(styling.getStringSpecifier()).withWidth(5.0);
        return KmlUtils.getStyleUrl(SATELLITE_TRACK_LINE_ID);
    }
}

