/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.info;

import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.AntPath;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.comms.CommsLinkResult;

public class KmlContactInfoPanel {
    public String getPanelContentForCommsLink(Qso qso, CommsLinkResult result, TemplateEngine templateEngine) {
        Adif3Record rec = qso.getRecord();
        Context context = new Context();
        context.setVariable("qsoDate", (Object)rec.getQsoDate().toString());
        context.setVariable("qsoTime", (Object)rec.getTimeOn().toString());
        context.setVariable("call", (Object)rec.getCall());
        context.setVariable("stationCallsign", (Object)rec.getStationCallsign());
        if (rec.getBand() != null) {
            if (rec.getBandRx() != null) {
                context.setVariable("uplinkBand", (Object)StringUtils.replace((String)rec.getBand().name(), (String)"BAND_", (String)"").toLowerCase());
                context.setVariable("downlinkBand", (Object)StringUtils.replace((String)rec.getBandRx().name(), (String)"BAND_", (String)"").toLowerCase());
            } else {
                context.setVariable("band", (Object)StringUtils.replace((String)rec.getBand().name(), (String)"BAND_", (String)"").toLowerCase());
            }
        }
        if (rec.getMode() != null) {
            context.setVariable("mode", (Object)rec.getMode().toString());
        }
        if (rec.getFreq() != null) {
            if (rec.getFreqRx() != null) {
                context.setVariable("freq", (Object)String.format("%,.3f", rec.getFreq()));
                context.setVariable("downlinkFreq", (Object)String.format("%,.3f", rec.getFreqRx()));
            } else {
                context.setVariable("freq", (Object)String.format("%,.3f", rec.getFreq()));
            }
        }
        if (rec.getTxPwr() != null) {
            context.setVariable("txPwr", (Object)String.format("%,.1f", rec.getTxPwr()));
        }
        context.setVariable("gndDist", (Object)String.format("%,.0f", result.getDistanceInKm()));
        context.setVariable("azimuth", (Object)String.format("%03.03f", result.getAzimuth()));
        if (result.getPropagation() != null) {
            switch (result.getPropagation()) {
                case F2_REFLECTION: {
                    context.setVariable("skyDist", (Object)String.format("%,.0f", result.getSkyDistance()));
                    context.setVariable("bounces", (Object)String.format("%d", result.getBounces()));
                    context.setVariable("antPath", (Object)(rec.getAntPath() == null ? AntPath.SHORT : rec.getAntPath()));
                    break;
                }
                case SATELLITE: {
                    context.setVariable("satName", (Object)qso.getRecord().getSatName());
                    context.setVariable("satAlt", (Object)String.format("%,.0f km", result.getAltitude() / 1000.0));
                    break;
                }
                case TROPOSPHERIC_DUCTING: {
                    context.setVariable("bounces", (Object)String.format("%d", result.getBounces()));
                    context.setVariable("ductTop", (Object)String.format("%,.0f", result.getAltitude()));
                    context.setVariable("ductBase", (Object)String.format("%,.0f", result.getBase()));
                }
            }
        }
        if (result.getAltitude() > 9999.99) {
            context.setVariable("avgAlt", (Object)String.format("%,.0f km", result.getAltitude() / 1000.0));
        } else {
            context.setVariable("avgAlt", (Object)String.format("%,.0f metres", result.getAltitude()));
        }
        context.setVariable("angle", (Object)String.format("%,.0f\u00b0", result.getFromAngle()));
        String mode = result.getPropagation() != null ? result.getPropagation().adifCode() : "GND";
        context.setVariable("propagationMode", (Object)mode);
        String html = templateEngine.process(new TemplateSpec("KmlContactInfo", TemplateMode.XML), (IContext)context);
        return html.replace("\n", "");
    }
}

