/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.info;

import org.apache.commons.lang3.StringUtils;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Station;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationInfo;
import uk.m0nom.adifproc.dxcc.DxccEntity;
import uk.m0nom.adifproc.qrz.QrzCallsign;

public class KmlStationInfoPanel {
    public String getPanelContentForStation(TransformControl control, Station station) {
        String grid;
        String callSign = station.getCallsign();
        Context context = new Context();
        QrzCallsign qrzInfo = station.getQrzInfo();
        if (qrzInfo != null) {
            this.setVariable(context, "call", station.getQrzInfo().getCall());
            if (qrzInfo.getImage() != null) {
                context.setVariable("image", (Object)station.getQrzInfo().getImage());
            }
        } else {
            context.setVariable("call", (Object)callSign);
        }
        for (ActivityType activityType : ActivityType.values()) {
            if (!station.isDoing(activityType)) continue;
            context.setVariable(activityType.getActivityName().toLowerCase(), (Object)station.getActivity(activityType));
        }
        if (qrzInfo != null) {
            this.setVariable(context, "name", String.format("%s %s", StringUtils.defaultIfBlank((CharSequence)qrzInfo.getFname(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)qrzInfo.getName(), (CharSequence)"")));
            this.setVariable(context, "country", qrzInfo.getCountry());
            if (StringUtils.isNotEmpty((CharSequence)qrzInfo.getDxcc())) {
                this.setVariable(context, "dxcc", qrzInfo.getDxcc());
                int dxccCode = Integer.parseInt(qrzInfo.getDxcc());
                DxccEntity dxcc = control.getDxccEntities().getEntity(dxccCode);
                this.setVariable(context, "flag", dxcc.getFlag());
            }
            this.setVariable(context, "ituZone", qrzInfo.getItuzone());
            this.setVariable(context, "cqZone", qrzInfo.getCqzone());
        }
        if ((grid = station.getGrid()) == null && qrzInfo != null) {
            grid = qrzInfo.getGrid();
        }
        this.setVariable(context, "grid", grid);
        GlobalCoords3D coordinates = station.getCoordinates();
        if (coordinates == null && qrzInfo != null) {
            coordinates = new GlobalCoords3D(qrzInfo.getLat(), (double)qrzInfo.getLon());
        }
        if (coordinates != null) {
            context.setVariable("lat", (Object)String.format("%.3f", coordinates.getLatitude()));
            context.setVariable("long", (Object)String.format("%.3f", coordinates.getLongitude()));
            LocationInfo info = coordinates.getLocationInfo();
            context.setVariable("locationSource", (Object)info.getSource().getDescription());
            context.setVariable("locationAccuracy", (Object)info.getAccuracy().getDescription());
        }
        String html = control.getTemplateEngine().process(new TemplateSpec("KmlStationInfo", TemplateMode.XML), (IContext)context);
        return html.replace("\n", "");
    }

    private void setVariable(Context context, String key, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            context.setVariable(key, (Object)value);
        }
    }
}

