/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.station;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Style;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.Adif3Record;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.icons.IconResource;
import uk.m0nom.adifproc.kml.KmlUtils;
import uk.m0nom.adifproc.kml.info.KmlStationInfoPanel;

public class KmlStationUtils {
    public static final double DEFAULT_RANGE_METRES = 500.0;
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm");
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter timeWithSecondsFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final Set<String> iconStyles = new HashSet<String>();
    private final TransformControl control;

    public KmlStationUtils(TransformControl control) {
        this.control = control;
    }

    public String addMyStationToMap(Document doc, Folder folder, Qso qso) {
        return this.createMyStationMarker(doc, folder, qso);
    }

    public static String getQsoDateTimeAsString(Qso qso) {
        LocalDate date = qso.getRecord().getQsoDate();
        LocalTime time = qso.getRecord().getTimeOn();
        LocalDateTime contactDateTime = LocalDateTime.of(date, time);
        return dateTimeFormatter.format(contactDateTime);
    }

    public static String getQsoDateAsString(Qso qso) {
        LocalDate date = qso.getRecord().getQsoDate();
        return dateFormatter.format(date);
    }

    public static String getQsoTimeAsString(Qso qso) {
        LocalTime time = qso.getRecord().getTimeOn();
        return timeFormatter.format(time);
    }

    public String createMyStationMarker(Document document, Folder folder, Qso qso) {
        GlobalCoordinates coords = qso.getRecord().getMyCoordinates();
        if (qso.getFrom().getCoordinates() == null && coords == null) {
            return String.format("Cannot determine coordinates for station %s, please specify a location override", qso.getFrom().getCallsign());
        }
        double longitude = coords.getLongitude();
        double latitude = coords.getLatitude();
        String callsign = qso.getFrom().getCallsign();
        Folder myFolder = folder.createAndAddFolder().withName(callsign).withOpen(Boolean.valueOf(false));
        IconResource icon = IconResource.getIconFromStation(this.control, qso.getFrom());
        if (!this.iconStyles.contains(icon.getName())) {
            Icon kmlIcon = new Icon().withHref(icon.getUrl());
            Style style = document.createAndAddStyle().withId(KmlUtils.getStyleId(icon.getName()));
            style.createAndSetIconStyle().withScale(1.0).withIcon(kmlIcon);
            style.createAndSetLabelStyle().withColor("ff43b3ff").withScale(1.0);
            this.iconStyles.add(icon.getName());
        }
        Placemark placemark = myFolder.createAndAddPlacemark();
        String htmlPanelContent = new KmlStationInfoPanel().getPanelContentForStation(this.control, qso.getFrom());
        placemark.withName(callsign).withStyleUrl(KmlUtils.getStyleUrl(icon.getName())).withDescription(htmlPanelContent).createAndSetLookAt().withLongitude(longitude).withLatitude(latitude).withAltitude(0.0).withRange(500.0);
        placemark.createAndSetPoint().addToCoordinates(longitude, latitude);
        return null;
    }

    public void createSatelliteContactMarker(TransformControl control, Document document, Folder folder, Qso qso, GlobalCoords3D position) {
        String name = KmlStationUtils.getSatelliteMarkerName(qso);
        String folderName = KmlStationUtils.getSatelliteFolderName(qso);
        IconResource icon = IconResource.getSatelliteResource(control);
        if (!this.iconStyles.contains(icon.getName())) {
            Icon kmlIcon = new Icon().withHref(icon.getUrl());
            Style style = document.createAndAddStyle().withId(KmlUtils.getStyleId(icon.getName()));
            style.createAndSetIconStyle().withScale(1.0).withIcon(kmlIcon);
            style.createAndSetLabelStyle().withColor("ff43b3ff").withScale(1.0);
            this.iconStyles.add(icon.getName());
        }
        Folder satFolder = folder.createAndAddFolder().withName(folderName).withOpen(Boolean.valueOf(false));
        Placemark placemark = satFolder.createAndAddPlacemark();
        placemark.withName(name).withStyleUrl(KmlUtils.getStyleUrl(icon.getName())).createAndSetLookAt().withLongitude(position.getLongitude()).withLatitude(position.getLatitude()).withAltitude(position.getAltitude().doubleValue()).withRange(500.0);
        placemark.createAndSetPoint().addToCoordinates(position.getLongitude(), position.getLatitude(), position.getAltitude().doubleValue()).setAltitudeMode(AltitudeMode.ABSOLUTE);
    }

    public String createStationMarker(TransformControl control, Document document, Folder folder, Qso qso) {
        String id = KmlStationUtils.getStationMarkerId(qso);
        String name = KmlStationUtils.getStationMarkerName(qso);
        Adif3Record rec = qso.getRecord();
        if (qso.getTo().getCoordinates() == null && rec.getCoordinates() == null) {
            return String.format("Cannot determine coordinates for station %s, please specify a location override", qso.getFrom().getCallsign());
        }
        GlobalCoordinates myCoords = rec.getMyCoordinates();
        double myLatitude = myCoords.getLatitude();
        double myLongitude = myCoords.getLongitude();
        GlobalCoordinates coords = rec.getCoordinates();
        double longitude = coords.getLongitude();
        double latitude = coords.getLatitude();
        IconResource icon = IconResource.getIconFromStation(control, qso.getTo());
        if (!this.iconStyles.contains(icon.getName())) {
            Icon kmlIcon = new Icon().withHref(icon.getUrl());
            Style style = document.createAndAddStyle().withId(KmlUtils.getStyleId(icon.getName()));
            style.createAndSetIconStyle().withScale(1.0).withIcon(kmlIcon);
            style.createAndSetLabelStyle().withColor("ff43b3ff").withScale(1.0);
            style.createAndSetLineStyle().withColor("ffb343ff").withWidth(5.0);
            this.iconStyles.add(icon.getName());
        }
        Placemark placemark = folder.createAndAddPlacemark();
        String htmlPanelContent = new KmlStationInfoPanel().getPanelContentForStation(control, qso.getTo());
        placemark.withName(name).withId(id).withStyleUrl(KmlUtils.getStyleUrl(icon.getName())).withDescription(htmlPanelContent).createAndSetLookAt().withLongitude(longitude).withLatitude(latitude).withAltitude(0.0).withRange(500.0);
        placemark.createAndSetLineString().addToCoordinates(myLongitude, myLatitude).addToCoordinates(longitude, latitude).setExtrude(Boolean.valueOf(true));
        placemark.createAndSetPoint().addToCoordinates(longitude, latitude);
        if (control.isKmlShowStationSubLabel()) {
            icon = IconResource.getIconFromMode(control, qso.getRecord().getMode());
            String modeId = qso.getRecord().getMode().name();
            if (icon != null) {
                if (!this.iconStyles.contains(modeId)) {
                    Icon modeIcon = new Icon().withHref(icon.getUrl());
                    Style modeStyle = document.createAndAddStyle().withId(KmlUtils.getModeStyleId(modeId));
                    modeStyle.createAndSetIconStyle().withScale(1.0).withIcon(modeIcon);
                    modeStyle.createAndSetLabelStyle().withColor("ff43b3ff").withScale(0.75);
                    modeStyle.createAndSetLineStyle().withColor("ffb343ff").withWidth(3.0);
                    this.iconStyles.add(modeId);
                }
                Placemark modePlaceMark = folder.createAndAddPlacemark();
                modePlaceMark.withId(KmlUtils.getModeId(id)).withName(KmlStationUtils.getModeLabel(qso)).withStyleUrl(KmlUtils.getModeStyleUrl(modeId));
                modePlaceMark.createAndSetPoint().addToCoordinates(longitude, latitude);
            }
        }
        return null;
    }

    public static String getModeLabel(Qso qso) {
        if (qso.getRecord().getBand() != null && qso.getRecord().getMode() != null) {
            return String.format("%s %s", qso.getRecord().getBand().adifCode(), qso.getRecord().getMode().adifCode());
        }
        return "";
    }

    public static String getStationMarkerId(Qso qso) {
        String stationName = qso.getTo().getCallsign();
        String dateTime = KmlStationUtils.getQsoDateTimeAsString(qso);
        String id = String.format("%s %s", dateTime, stationName);
        return id.replaceAll(" ", "_");
    }

    public static String getStationMarkerName(Qso qso) {
        return qso.getTo().getCallsign();
    }

    public static String getSatelliteMarkerId(Qso qso) {
        String time = KmlStationUtils.getQsoTimeAsString(qso);
        String satelliteName = qso.getRecord().getSatName();
        String id = String.format("%s %s", time, satelliteName);
        return id.replaceAll(" ", "_");
    }

    public static String getSatelliteFolderName(Qso qso) {
        String date = KmlStationUtils.getQsoDateAsString(qso);
        String satelliteName = qso.getRecord().getSatName();
        return String.format("%s %s", date, satelliteName);
    }

    public static String getSatelliteMarkerName(Qso qso) {
        LocalTime time = qso.getRecord().getTimeOn();
        return timeWithSecondsFormatter.format(time);
    }
}

