/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.location;

import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.types.Sota;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.contacts.Station;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationParserResult;
import uk.m0nom.adifproc.coords.LocationParsingService;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.location.BaseLocationDeterminer;
import uk.m0nom.adifproc.maidenheadlocator.MaidenheadLocatorConversion;
import uk.m0nom.adifproc.qrz.CachingQrzXmlService;
import uk.m0nom.adifproc.qrz.QrzCallsign;

@Service
public class FromLocationDeterminer
extends BaseLocationDeterminer {
    protected static final Logger logger = Logger.getLogger(FromLocationDeterminer.class.getName());

    public FromLocationDeterminer(CachingQrzXmlService qrzXmlService, ActivityDatabaseService activities) {
        super(qrzXmlService, activities);
    }

    private void setMyLocationFromGrid(Qso qso, String myGrid) {
        Adif3Record rec = qso.getRecord();
        qso.getRecord().setMyGridSquare(myGrid.substring(0, 6));
        qso.getFrom().setGrid(myGrid);
        GlobalCoords3D coords = MaidenheadLocatorConversion.locatorToCoords(LocationSource.QRZ, myGrid);
        rec.setMyCoordinates(coords);
        qso.getFrom().setCoordinates(coords);
    }

    private void setMyLocationFromCoordinates(Qso qso, GlobalCoords3D coords) {
        qso.getRecord().setMyCoordinates(coords);
        qso.getFrom().setCoordinates(coords);
    }

    private boolean setMyLocationFromControl(Qso qso, TransformControl control) {
        boolean locationSet = false;
        if (control.getLocation() != null) {
            LocationParserResult result;
            LocationParsingService parsers = new LocationParsingService();
            if (StringUtils.isNotBlank((CharSequence)control.getLocation()) && (result = parsers.parseStringForCoordinates(LocationSource.OVERRIDE, control.getLocation())).getCoords() != null) {
                this.setMyLocationFromCoordinates(qso, result.getCoords());
                String gridsquare = MaidenheadLocatorConversion.coordsToLocator(result.getCoords());
                qso.getFrom().setGrid(gridsquare);
                qso.getRecord().setMyGridSquare(gridsquare);
                locationSet = true;
            }
        }
        return locationSet;
    }

    private boolean setMyLocationFromActivities(Qso qso) {
        boolean locationSetFromActivity = false;
        for (Activity activity : qso.getFrom().getActivities().values()) {
            this.setMyLocationFromActivity(qso.getFrom(), qso.getRecord(), activity);
            locationSetFromActivity = true;
        }
        return locationSetFromActivity;
    }

    private void setMyGridFromCoords(Station station, Adif3Record rec, GlobalCoordinates coords) {
        String grid = MaidenheadLocatorConversion.coordsToLocator(coords);
        rec.setMyGridSquare(grid);
        station.setGrid(grid);
    }

    private void setMyCoordsFromGrid(Station station, Adif3Record rec, String grid) {
        GlobalCoords3D coords = MaidenheadLocatorConversion.locatorToCoords(LocationSource.ACTIVITY, grid);
        rec.setMyCoordinates(coords);
        station.setCoordinates(coords);
    }

    private void setMyLocationFromActivity(Station station, Adif3Record rec, Activity info) {
        if (info.hasCoords()) {
            rec.setMyCoordinates(info.getCoords());
            station.setCoordinates(info.getCoords());
            this.setMyGridFromCoords(station, rec, info.getCoords());
        } else if (info.hasGrid()) {
            rec.setMyGridSquare(info.getGrid());
            this.setMyCoordsFromGrid(station, rec, info.getGrid());
        } else {
            logger.warning(String.format("Your activity %s at %s doesn't have a location defined", info.getType().getActivityName(), info.getRef()));
        }
    }

    private boolean setMyLocationFromRecGridsquare(Qso qso) {
        Adif3Record rec = qso.getRecord();
        if (rec.getMyGridSquare() != null && MaidenheadLocatorConversion.isAValidGridSquare(rec.getMyGridSquare())) {
            GlobalCoords3D myLoc = MaidenheadLocatorConversion.locatorToCoords(LocationSource.OVERRIDE, rec.getMyGridSquare());
            rec.setMyCoordinates(myLoc);
            qso.getFrom().setGrid(rec.getMyGridSquare());
            return true;
        }
        return false;
    }

    private boolean setMyLocationFromQrzLatLong(Qso qso, QrzCallsign callsignData) {
        Adif3Record rec = qso.getRecord();
        if (callsignData != null && callsignData.getLat() != null && callsignData.getLon() != null) {
            GlobalCoords3D coord = new GlobalCoords3D(callsignData.getLat(), (double)callsignData.getLon());
            rec.setMyCoordinates(coord);
            qso.getFrom().setCoordinates(coord);
            return true;
        }
        return false;
    }

    private boolean setMyLocationFromQrzGrid(Qso qso, QrzCallsign callsignData) {
        Adif3Record rec = qso.getRecord();
        if (callsignData != null && callsignData.getGrid() != null && MaidenheadLocatorConversion.isAValidGridSquare(callsignData.getGrid())) {
            rec.setMyGridSquare(callsignData.getGrid());
            this.setMyLocationFromGrid(qso, callsignData.getGrid());
            return true;
        }
        return false;
    }

    public boolean setMyLocation(TransformControl control, Qso qso, QrzCallsign callsignData) {
        Adif3Record rec = qso.getRecord();
        boolean locationSet = true;
        if (rec.getMySotaRef() != null) {
            String sotaRef = rec.getMySotaRef().getValue().toUpperCase();
            qso.getFrom().addActivity(this.activities.getDatabase(ActivityType.SOTA).get(sotaRef));
        }
        this.updateMySigInfoFromActivity(qso);
        if (!(this.setMyLocationFromControl(qso, control) || this.setMyLocationFromActivities(qso) || this.setMyLocationFromRecGridsquare(qso) || this.setMyLocationFromQrzLatLong(qso, callsignData) || this.setMyLocationFromQrzGrid(qso, callsignData))) {
            locationSet = false;
        }
        return locationSet;
    }

    private void updateMySigInfoFromActivity(Qso qso) {
        if (qso.getRecord().getMySig() == null && qso.getFrom().getActivities() != null) {
            for (Activity activity : qso.getFrom().getActivities().values()) {
                if (activity.getType() != ActivityType.SOTA) {
                    qso.getRecord().setMySig(activity.getType().getActivityName());
                    qso.getRecord().setMySigInfo(activity.getRef());
                    return;
                }
                if (qso.getRecord().getMySotaRef() != null) continue;
                Sota sota = Sota.valueOf(activity.getRef().toUpperCase());
                qso.getRecord().setMySotaRef(sota);
            }
        }
    }
}

