/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.satellite;

import java.time.LocalDate;
import java.util.Collection;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.satellite.ApSatellite;
import uk.m0nom.adifproc.satellite.ApSatellites;
import uk.m0nom.adifproc.satellite.norad.NoradSatellite;
import uk.m0nom.adifproc.satellite.norad.NoradSatelliteOrbitReader;
import uk.m0nom.adifproc.satellite.satellites.QO100;
import uk.m0nom.adifproc.satellite.satellites.SatelliteNameAliases;

@Service
public class ApSatelliteService {
    private final NoradSatelliteOrbitReader noradSatelliteOrbitReader;
    private final SatelliteNameAliases satelliteNameAliases;
    private final ApSatellites satellites;
    private final LocalDate earliestDataAvailable = LocalDate.of(2022, 2, 23);

    public ApSatelliteService(NoradSatelliteOrbitReader noradSatelliteOrbitReader, SatelliteNameAliases satelliteNameAliases) {
        this.satellites = new ApSatellites();
        this.satelliteNameAliases = satelliteNameAliases;
        this.noradSatelliteOrbitReader = noradSatelliteOrbitReader;
        this.satellites.addOrReplace(new QO100(), null);
    }

    private void loadCurrentNoradSatelliteTleDataIfRequired() {
        if (!this.satellites.hasDataFor(LocalDate.now())) {
            this.noradSatelliteOrbitReader.loadCurrentSatelliteTleDataFromCelestrak(this.satellites);
        }
    }

    public ApSatellite getSatellite(String id, LocalDate date) {
        ApSatellite satellite = this.getSatellite(id);
        if (satellite == null || satellite instanceof NoradSatellite) {
            if (LocalDate.now().isEqual(date)) {
                this.loadCurrentNoradSatelliteTleDataIfRequired();
            } else if (!this.satellites.hasDataFor(date)) {
                this.noradSatelliteOrbitReader.loadTleDataFromArchive(this.satellites, date);
            }
            satellite = this.getSatellite(id);
        }
        return satellite;
    }

    public ApSatellite getSatellite(String id) {
        return this.getSatelliteByNameIdOrAlias(id);
    }

    public ApSatellite getSatelliteByNameIdOrAlias(String id) {
        String satName = this.satelliteNameAliases.getSatelliteName(id.toUpperCase());
        if (satName == null) {
            satName = id.toUpperCase();
        }
        return this.satellites.get(satName);
    }

    public boolean isAKnownSatellite(String id) {
        return this.getSatellite(id) != null;
    }

    public Collection<String> getSatelliteNames() {
        this.loadCurrentNoradSatelliteTleDataIfRequired();
        return this.satellites.getSatelliteNames();
    }

    public int getSatelliteCount() {
        this.loadCurrentNoradSatelliteTleDataIfRequired();
        return this.satellites.getSatelliteCount();
    }

    public LocalDate getEarliestDataAvailable() {
        return this.earliestDataAvailable;
    }
}

