/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.satellite;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.marsik.ham.adif.Adif3Record;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.satellite.ApSatelliteService;
import uk.m0nom.adifproc.satellite.SatellitePass;
import uk.m0nom.adifproc.satellite.SatellitePassId;

public class SatelliteActivity {
    private ApSatelliteService satellites;
    private Map<SatellitePassId, SatellitePass> satellitePasses = new HashMap<SatellitePassId, SatellitePass>();

    public void recordSatelliteActivity(Qso qso) {
        this.addOrUpdateSatellitePass(qso);
    }

    private void addOrUpdateSatellitePass(Qso qso) {
        Adif3Record rec = qso.getRecord();
        SatellitePassId id = new SatellitePassId(rec.getSatName(), rec.getQsoDate());
        SatellitePass pass = this.satellitePasses.get(id);
        if (pass == null) {
            pass = new SatellitePass(id);
            this.satellitePasses.put(id, pass);
        }
        pass.addContact(qso);
    }

    public Collection<SatellitePass> getPasses() {
        return this.satellitePasses.values();
    }

    public void spaceOutContactsInPasses() {
        for (SatellitePass pass : this.getPasses()) {
            pass.spaceOutContacts();
        }
    }

    public boolean hasActivity() {
        return !this.satellitePasses.isEmpty();
    }

    public ApSatelliteService getSatellites() {
        return this.satellites;
    }

    public Map<SatellitePassId, SatellitePass> getSatellitePasses() {
        return this.satellitePasses;
    }

    public void setSatellites(ApSatelliteService satellites) {
        this.satellites = satellites;
    }

    public void setSatellitePasses(Map<SatellitePassId, SatellitePass> satellitePasses) {
        this.satellitePasses = satellitePasses;
    }
}

