/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.satellite.norad;

import com.github.amsacode.predict4java.GroundStationPosition;
import com.github.amsacode.predict4java.SatPos;
import com.github.amsacode.predict4java.Satellite;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.satellite.ApSatellite;

public class NoradSatellite
implements ApSatellite {
    private Map<LocalDate, Satellite> satelliteTleDataForDate = new HashMap<LocalDate, Satellite>();
    private String name;
    private String designator;

    public static String getIdentifier(String name) {
        String identifier = name.trim();
        if (identifier.contains("(")) {
            identifier = StringUtils.substringBefore((String)identifier, (String)"(").trim();
        }
        return identifier;
    }

    public NoradSatellite(LocalDate date, Satellite satelliteTleData) {
        String identifier = satelliteTleData.getTLE().getName();
        if (identifier.contains("(")) {
            this.name = StringUtils.substringBefore((String)identifier, (String)"(").trim();
            this.designator = StringUtils.substringAfter((String)identifier, (String)"(");
            this.designator = StringUtils.substringBefore((String)this.designator, (String)")");
        } else {
            this.name = identifier;
            this.designator = "";
        }
        this.satelliteTleDataForDate.put(date, satelliteTleData);
    }

    public void addTleData(LocalDate date, Satellite satellite) {
        this.satelliteTleDataForDate.put(date, satellite);
    }

    @Override
    public String getIdentifier() {
        if (StringUtils.isNotBlank((CharSequence)this.getDesignator())) {
            return String.format("%s: %s", this.getDesignator(), this.getName());
        }
        return this.getName();
    }

    public Satellite getSatelliteTleDataForDate(LocalDate date) {
        Satellite satellite = this.satelliteTleDataForDate.get(date);
        if (satellite == null) {
            satellite = this.satelliteTleDataForDate.get(LocalDate.now());
        }
        return satellite;
    }

    @Override
    public GlobalCoords3D getPosition(GlobalCoords3D coords, LocalDate date, LocalTime time) {
        Satellite satellite = this.getSatelliteTleDataForDate(date);
        GroundStationPosition groundStationPosition = new GroundStationPosition(coords.getLatitude(), coords.getLongitude(), coords.getAltitude().doubleValue());
        LocalDateTime dateTime = LocalDateTime.of(date, time);
        ZonedDateTime utcDateTime = dateTime.atZone(ZoneId.of("UTC"));
        Date utcDate = new Date(utcDateTime.toInstant().toEpochMilli());
        SatPos satPos = satellite.getPosition(groundStationPosition, (java.util.Date)utcDate);
        double latitude = satPos.getLatitude() / (Math.PI * 2) * 360.0;
        double longitude = satPos.getLongitude() / (Math.PI * 2) * 360.0;
        double altitudeInMetres = satPos.getAltitude() * 1000.0;
        return new GlobalCoords3D(latitude, longitude, altitudeInMetres, LocationSource.SATELLITE, LocationAccuracy.LAT_LONG);
    }

    @Override
    public void updateAdifRec(TransformControl control, Adif3Record rec) {
    }

    @Override
    public boolean isGeostationary() {
        return false;
    }

    public Map<LocalDate, Satellite> getSatelliteTleDataForDate() {
        return this.satelliteTleDataForDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDesignator() {
        return this.designator;
    }

    public void setSatelliteTleDataForDate(Map<LocalDate, Satellite> satelliteTleDataForDate) {
        this.satelliteTleDataForDate = satelliteTleDataForDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesignator(String designator) {
        this.designator = designator;
    }
}

