package uk.m0nom.adifproc.kml;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/**
 * HTML colors with added transparency for KML
 **/
public class KmlStyling {
    private static final Logger logger = Logger.getLogger(KmlStyling.class.getName());

    private final static String SEPARATOR_CHAR = ":";

    private static final Map<String, KmlColour> colors;

    public static KmlColour get(String name) {
        return colors.get(name);
    }

    public static KmlColour get(String name, int transparency) {
        KmlColour colour = colors.get(name);
        colour.setTransparency(transparency);
        return colour;
    }

    public static KmlLineStyle getKmlLineStyle(String specifier) {

        if (StringUtils.contains(specifier, ":")) {
            String[] components = StringUtils.split(specifier, SEPARATOR_CHAR);
            if (components.length != 3) {
                logger.warning(String.format("Bad colour specifier: %s, use format: html_colour%stransparency%swidth", specifier, SEPARATOR_CHAR, SEPARATOR_CHAR));
            } else {
                String colourName = components[0];
                String transparency = components[1];
                String width = components[2];
                KmlColour colour = get(colourName, convertTransparencySpecifier(transparency));
                return new KmlLineStyle(colour, convertWidthSpecifier(width));

            }
        }
        return null;
    }

    /**
     * Specifier in a string is digit 0 - 100% transparency, but internally 0-255 is used.
     * @param specifier percentage transparency
     * @return transparency specified as an int 0-255
     */
    private static int convertTransparencySpecifier(String specifier) {
        int rawValue = Integer.parseInt(specifier);
        return rawValue * 255 / 100;
    }

    /** No magic here, just convert string to int and return */
    private static int convertWidthSpecifier(String specifier) {
        return Integer.parseInt(specifier);
    }

    static {
        colors = new HashMap<>();
        colors.put("air_force_blue_usaf", new KmlColour("air_force_blue_usaf", "Air Force Blue (Usaf)", "#00308f", 0, 48, 143));
        colors.put("air_superiority_blue", new KmlColour("air_superiority_blue", "Air Superiority Blue", "#72a0c1", 114, 160, 193));
        colors.put("alabama_crimson", new KmlColour("alabama_crimson", "Alabama Crimson", "#a32638", 163, 38, 56));
        colors.put("alice_blue", new KmlColour("alice_blue", "Alice Blue", "#f0f8ff", 240, 248, 255));
        colors.put("alizarin_crimson", new KmlColour("alizarin_crimson", "Alizarin Crimson", "#e32636", 227, 38, 54));
        colors.put("alloy_orange", new KmlColour("alloy_orange", "Alloy Orange", "#c46210", 196, 98, 16));
        colors.put("almond", new KmlColour("almond", "Almond", "#efdecd", 239, 222, 205));
        colors.put("amaranth", new KmlColour("amaranth", "Amaranth", "#e52b50", 229, 43, 80));
        colors.put("amber", new KmlColour("amber", "Amber", "#ffbf00", 255, 191, 0));
        colors.put("amber_sae_ece", new KmlColour("amber_sae_ece", "Amber (Sae/Ece)", "#ff7e00", 255, 126, 0));
        colors.put("american_rose", new KmlColour("american_rose", "American Rose", "#ff033e", 255, 3, 62));
        colors.put("amethyst", new KmlColour("amethyst", "Amethyst", "#96c", 153, 102, 204));
        colors.put("android_green", new KmlColour("android_green", "Android Green", "#a4c639", 164, 198, 57));
        colors.put("anti_flash_white", new KmlColour("anti_flash_white", "Anti-Flash White", "#f2f3f4", 242, 243, 244));
        colors.put("antique_brass", new KmlColour("antique_brass", "Antique Brass", "#cd9575", 205, 149, 117));
        colors.put("antique_fuchsia", new KmlColour("antique_fuchsia", "Antique Fuchsia", "#915c83", 145, 92, 131));
        colors.put("antique_ruby", new KmlColour("antique_ruby", "Antique Ruby", "#841b2d", 132, 27, 45));
        colors.put("antique_white", new KmlColour("antique_white", "Antique White", "#faebd7", 250, 235, 215));
        colors.put("ao_english", new KmlColour("ao_english", "Ao (English)", "#008000", 0, 128, 0));
        colors.put("apple_green", new KmlColour("apple_green", "Apple Green", "#8db600", 141, 182, 0));
        colors.put("apricot", new KmlColour("apricot", "Apricot", "#fbceb1", 251, 206, 177));
        colors.put("aqua", new KmlColour("aqua", "Aqua", "#0ff", 0, 255, 255));
        colors.put("aquamarine", new KmlColour("aquamarine", "Aquamarine", "#7fffd4", 127, 255, 212));
        colors.put("army_green", new KmlColour("army_green", "Army Green", "#4b5320", 75, 83, 32));
        colors.put("arsenic", new KmlColour("arsenic", "Arsenic", "#3b444b", 59, 68, 75));
        colors.put("arylide_yellow", new KmlColour("arylide_yellow", "Arylide Yellow", "#e9d66b", 233, 214, 107));
        colors.put("ash_grey", new KmlColour("ash_grey", "Ash Grey", "#b2beb5", 178, 190, 181));
        colors.put("asparagus", new KmlColour("asparagus", "Asparagus", "#87a96b", 135, 169, 107));
        colors.put("atomic_tangerine", new KmlColour("atomic_tangerine", "Atomic Tangerine", "#f96", 255, 153, 102));
        colors.put("auburn", new KmlColour("auburn", "Auburn", "#a52a2a", 165, 42, 42));
        colors.put("aureolin", new KmlColour("aureolin", "Aureolin", "#fdee00", 253, 238, 0));
        colors.put("aurometalsaurus", new KmlColour("aurometalsaurus", "Aurometalsaurus", "#6e7f80", 110, 127, 128));
        colors.put("avocado", new KmlColour("avocado", "Avocado", "#568203", 86, 130, 3));
        colors.put("azure", new KmlColour("azure", "Azure", "#007fff", 0, 127, 255));
        colors.put("azure_mist_web", new KmlColour("azure_mist_web", "Azure Mist/Web", "#f0ffff", 240, 255, 255));
        colors.put("baby_blue", new KmlColour("baby_blue", "Baby Blue", "#89cff0", 137, 207, 240));
        colors.put("baby_blue_eyes", new KmlColour("baby_blue_eyes", "Baby Blue Eyes", "#a1caf1", 161, 202, 241));
        colors.put("baby_pink", new KmlColour("baby_pink", "Baby Pink", "#f4c2c2", 244, 194, 194));
        colors.put("ball_blue", new KmlColour("ball_blue", "Ball Blue", "#21abcd", 33, 171, 205));
        colors.put("banana_mania", new KmlColour("banana_mania", "Banana Mania", "#fae7b5", 250, 231, 181));
        colors.put("banana_yellow", new KmlColour("banana_yellow", "Banana Yellow", "#ffe135", 255, 225, 53));
        colors.put("barn_red", new KmlColour("barn_red", "Barn Red", "#7c0a02", 124, 10, 2));
        colors.put("battleship_grey", new KmlColour("battleship_grey", "Battleship Grey", "#848482", 132, 132, 130));
        colors.put("bazaar", new KmlColour("bazaar", "Bazaar", "#98777b", 152, 119, 123));
        colors.put("beau_blue", new KmlColour("beau_blue", "Beau Blue", "#bcd4e6", 188, 212, 230));
        colors.put("beaver", new KmlColour("beaver", "Beaver", "#9f8170", 159, 129, 112));
        colors.put("beige", new KmlColour("beige", "Beige", "#f5f5dc", 245, 245, 220));
        colors.put("big_dip_o_ruby", new KmlColour("big_dip_o_ruby", "Big Dip O’Ruby", "#9c2542", 156, 37, 66));
        colors.put("bisque", new KmlColour("bisque", "Bisque", "#ffe4c4", 255, 228, 196));
        colors.put("bistre", new KmlColour("bistre", "Bistre", "#3d2b1f", 61, 43, 31));
        colors.put("bittersweet", new KmlColour("bittersweet", "Bittersweet", "#fe6f5e", 254, 111, 94));
        colors.put("bittersweet_shimmer", new KmlColour("bittersweet_shimmer", "Bittersweet Shimmer", "#bf4f51", 191, 79, 81));
        colors.put("black", new KmlColour("black", "Black", "#000", 0, 0, 0));
        colors.put("black_bean", new KmlColour("black_bean", "Black Bean", "#3d0c02", 61, 12, 2));
        colors.put("black_leather_jacket", new KmlColour("black_leather_jacket", "Black Leather Jacket", "#253529", 37, 53, 41));
        colors.put("black_olive", new KmlColour("black_olive", "Black Olive", "#3b3c36", 59, 60, 54));
        colors.put("blanched_almond", new KmlColour("blanched_almond", "Blanched Almond", "#ffebcd", 255, 235, 205));
        colors.put("blast_off_bronze", new KmlColour("blast_off_bronze", "Blast-Off Bronze", "#a57164", 165, 113, 100));
        colors.put("bleu_de_france", new KmlColour("bleu_de_france", "Bleu De France", "#318ce7", 49, 140, 231));
        colors.put("blizzard_blue", new KmlColour("blizzard_blue", "Blizzard Blue", "#ace5ee", 172, 229, 238));
        colors.put("blond", new KmlColour("blond", "Blond", "#faf0be", 250, 240, 190));
        colors.put("blue", new KmlColour("blue", "Blue", "#00f", 0, 0, 255));
        colors.put("blue_bell", new KmlColour("blue_bell", "Blue Bell", "#a2a2d0", 162, 162, 208));
        colors.put("blue_crayola", new KmlColour("blue_crayola", "Blue (Crayola)", "#1f75fe", 31, 117, 254));
        colors.put("blue_gray", new KmlColour("blue_gray", "Blue Gray", "#69c", 102, 153, 204));
        colors.put("blue_green", new KmlColour("blue_green", "Blue-Green", "#0d98ba", 13, 152, 186));
        colors.put("blue_munsell", new KmlColour("blue_munsell", "Blue (Munsell)", "#0093af", 0, 147, 175));
        colors.put("blue_ncs", new KmlColour("blue_ncs", "Blue (Ncs)", "#0087bd", 0, 135, 189));
        colors.put("blue_pigment", new KmlColour("blue_pigment", "Blue (Pigment)", "#339", 51, 51, 153));
        colors.put("blue_ryb", new KmlColour("blue_ryb", "Blue (Ryb)", "#0247fe", 2, 71, 254));
        colors.put("blue_sapphire", new KmlColour("blue_sapphire", "Blue Sapphire", "#126180", 18, 97, 128));
        colors.put("blue_violet", new KmlColour("blue_violet", "Blue-Violet", "#8a2be2", 138, 43, 226));
        colors.put("blush", new KmlColour("blush", "Blush", "#de5d83", 222, 93, 131));
        colors.put("bole", new KmlColour("bole", "Bole", "#79443b", 121, 68, 59));
        colors.put("bondi_blue", new KmlColour("bondi_blue", "Bondi Blue", "#0095b6", 0, 149, 182));
        colors.put("bone", new KmlColour("bone", "Bone", "#e3dac9", 227, 218, 201));
        colors.put("boston_university_red", new KmlColour("boston_university_red", "Boston University Red", "#c00", 204, 0, 0));
        colors.put("bottle_green", new KmlColour("bottle_green", "Bottle Green", "#006a4e", 0, 106, 78));
        colors.put("boysenberry", new KmlColour("boysenberry", "Boysenberry", "#873260", 135, 50, 96));
        colors.put("brandeis_blue", new KmlColour("brandeis_blue", "Brandeis Blue", "#0070ff", 0, 112, 255));
        colors.put("brass", new KmlColour("brass", "Brass", "#b5a642", 181, 166, 66));
        colors.put("brick_red", new KmlColour("brick_red", "Brick Red", "#cb4154", 203, 65, 84));
        colors.put("bright_cerulean", new KmlColour("bright_cerulean", "Bright Cerulean", "#1dacd6", 29, 172, 214));
        colors.put("bright_green", new KmlColour("bright_green", "Bright Green", "#6f0", 102, 255, 0));
        colors.put("bright_lavender", new KmlColour("bright_lavender", "Bright Lavender", "#bf94e4", 191, 148, 228));
        colors.put("bright_maroon", new KmlColour("bright_maroon", "Bright Maroon", "#c32148", 195, 33, 72));
        colors.put("bright_pink", new KmlColour("bright_pink", "Bright Pink", "#ff007f", 255, 0, 127));
        colors.put("bright_turquoise", new KmlColour("bright_turquoise", "Bright Turquoise", "#08e8de", 8, 232, 222));
        colors.put("bright_ube", new KmlColour("bright_ube", "Bright Ube", "#d19fe8", 209, 159, 232));
        colors.put("brilliant_lavender", new KmlColour("brilliant_lavender", "Brilliant Lavender", "#f4bbff", 244, 187, 255));
        colors.put("brilliant_rose", new KmlColour("brilliant_rose", "Brilliant Rose", "#ff55a3", 255, 85, 163));
        colors.put("brink_pink", new KmlColour("brink_pink", "Brink Pink", "#fb607f", 251, 96, 127));
        colors.put("british_racing_green", new KmlColour("british_racing_green", "British Racing Green", "#004225", 0, 66, 37));
        colors.put("bronze", new KmlColour("bronze", "Bronze", "#cd7f32", 205, 127, 50));
        colors.put("brown_traditional", new KmlColour("brown_traditional", "Brown (Traditional)", "#964b00", 150, 75, 0));
        colors.put("brown_web", new KmlColour("brown_web", "Brown (Web)", "#a52a2a", 165, 42, 42));
        colors.put("bubble_gum", new KmlColour("bubble_gum", "Bubble Gum", "#ffc1cc", 255, 193, 204));
        colors.put("bubbles", new KmlColour("bubbles", "Bubbles", "#e7feff", 231, 254, 255));
        colors.put("buff", new KmlColour("buff", "Buff", "#f0dc82", 240, 220, 130));
        colors.put("bulgarian_rose", new KmlColour("bulgarian_rose", "Bulgarian Rose", "#480607", 72, 6, 7));
        colors.put("burgundy", new KmlColour("burgundy", "Burgundy", "#800020", 128, 0, 32));
        colors.put("burlywood", new KmlColour("burlywood", "Burlywood", "#deb887", 222, 184, 135));
        colors.put("burnt_orange", new KmlColour("burnt_orange", "Burnt Orange", "#c50", 204, 85, 0));
        colors.put("burnt_sienna", new KmlColour("burnt_sienna", "Burnt Sienna", "#e97451", 233, 116, 81));
        colors.put("burnt_umber", new KmlColour("burnt_umber", "Burnt Umber", "#8a3324", 138, 51, 36));
        colors.put("byzantine", new KmlColour("byzantine", "Byzantine", "#bd33a4", 189, 51, 164));
        colors.put("byzantium", new KmlColour("byzantium", "Byzantium", "#702963", 112, 41, 99));
        colors.put("cadet", new KmlColour("cadet", "Cadet", "#536872", 83, 104, 114));
        colors.put("cadet_blue", new KmlColour("cadet_blue", "Cadet Blue", "#5f9ea0", 95, 158, 160));
        colors.put("cadet_grey", new KmlColour("cadet_grey", "Cadet Grey", "#91a3b0", 145, 163, 176));
        colors.put("cadmium_green", new KmlColour("cadmium_green", "Cadmium Green", "#006b3c", 0, 107, 60));
        colors.put("cadmium_orange", new KmlColour("cadmium_orange", "Cadmium Orange", "#ed872d", 237, 135, 45));
        colors.put("cadmium_red", new KmlColour("cadmium_red", "Cadmium Red", "#e30022", 227, 0, 34));
        colors.put("cadmium_yellow", new KmlColour("cadmium_yellow", "Cadmium Yellow", "#fff600", 255, 246, 0));
        colors.put("caf_au_lait", new KmlColour("caf_au_lait", "Café Au Lait", "#a67b5b", 166, 123, 91));
        colors.put("caf_noir", new KmlColour("caf_noir", "Café Noir", "#4b3621", 75, 54, 33));
        colors.put("cal_poly_green", new KmlColour("cal_poly_green", "Cal Poly Green", "#1e4d2b", 30, 77, 43));
        colors.put("cambridge_blue", new KmlColour("cambridge_blue", "Cambridge Blue", "#a3c1ad", 163, 193, 173));
        colors.put("camel", new KmlColour("camel", "Camel", "#c19a6b", 193, 154, 107));
        colors.put("cameo_pink", new KmlColour("cameo_pink", "Cameo Pink", "#efbbcc", 239, 187, 204));
        colors.put("camouflage_green", new KmlColour("camouflage_green", "Camouflage Green", "#78866b", 120, 134, 107));
        colors.put("canary_yellow", new KmlColour("canary_yellow", "Canary Yellow", "#ffef00", 255, 239, 0));
        colors.put("candy_apple_red", new KmlColour("candy_apple_red", "Candy Apple Red", "#ff0800", 255, 8, 0));
        colors.put("candy_pink", new KmlColour("candy_pink", "Candy Pink", "#e4717a", 228, 113, 122));
        colors.put("capri", new KmlColour("capri", "Capri", "#00bfff", 0, 191, 255));
        colors.put("caput_mortuum", new KmlColour("caput_mortuum", "Caput Mortuum", "#592720", 89, 39, 32));
        colors.put("cardinal", new KmlColour("cardinal", "Cardinal", "#c41e3a", 196, 30, 58));
        colors.put("caribbean_green", new KmlColour("caribbean_green", "Caribbean Green", "#0c9", 0, 204, 153));
        colors.put("carmine", new KmlColour("carmine", "Carmine", "#960018", 150, 0, 24));
        colors.put("carmine_m_p", new KmlColour("carmine_m_p", "Carmine (M&P)", "#d70040", 215, 0, 64));
        colors.put("carmine_pink", new KmlColour("carmine_pink", "Carmine Pink", "#eb4c42", 235, 76, 66));
        colors.put("carmine_red", new KmlColour("carmine_red", "Carmine Red", "#ff0038", 255, 0, 56));
        colors.put("carnation_pink", new KmlColour("carnation_pink", "Carnation Pink", "#ffa6c9", 255, 166, 201));
        colors.put("carnelian", new KmlColour("carnelian", "Carnelian", "#b31b1b", 179, 27, 27));
        colors.put("carolina_blue", new KmlColour("carolina_blue", "Carolina Blue", "#99badd", 153, 186, 221));
        colors.put("carrot_orange", new KmlColour("carrot_orange", "Carrot Orange", "#ed9121", 237, 145, 33));
        colors.put("catalina_blue", new KmlColour("catalina_blue", "Catalina Blue", "#062a78", 6, 42, 120));
        colors.put("ceil", new KmlColour("ceil", "Ceil", "#92a1cf", 146, 161, 207));
        colors.put("celadon", new KmlColour("celadon", "Celadon", "#ace1af", 172, 225, 175));
        colors.put("celadon_blue", new KmlColour("celadon_blue", "Celadon Blue", "#007ba7", 0, 123, 167));
        colors.put("celadon_green", new KmlColour("celadon_green", "Celadon Green", "#2f847c", 47, 132, 124));
        colors.put("celeste_colour", new KmlColour("celeste_colour", "Celeste (Colour)", "#b2ffff", 178, 255, 255));
        colors.put("celestial_blue", new KmlColour("celestial_blue", "Celestial Blue", "#4997d0", 73, 151, 208));
        colors.put("cerise", new KmlColour("cerise", "Cerise", "#de3163", 222, 49, 99));
        colors.put("cerise_pink", new KmlColour("cerise_pink", "Cerise Pink", "#ec3b83", 236, 59, 131));
        colors.put("cerulean", new KmlColour("cerulean", "Cerulean", "#007ba7", 0, 123, 167));
        colors.put("cerulean_blue", new KmlColour("cerulean_blue", "Cerulean Blue", "#2a52be", 42, 82, 190));
        colors.put("cerulean_frost", new KmlColour("cerulean_frost", "Cerulean Frost", "#6d9bc3", 109, 155, 195));
        colors.put("cg_blue", new KmlColour("cg_blue", "Cg Blue", "#007aa5", 0, 122, 165));
        colors.put("cg_red", new KmlColour("cg_red", "Cg Red", "#e03c31", 224, 60, 49));
        colors.put("chamoisee", new KmlColour("chamoisee", "Chamoisee", "#a0785a", 160, 120, 90));
        colors.put("champagne", new KmlColour("champagne", "Champagne", "#fad6a5", 250, 214, 165));
        colors.put("charcoal", new KmlColour("charcoal", "Charcoal", "#36454f", 54, 69, 79));
        colors.put("charm_pink", new KmlColour("charm_pink", "Charm Pink", "#e68fac", 230, 143, 172));
        colors.put("chartreuse_traditional", new KmlColour("chartreuse_traditional", "Chartreuse (Traditional)", "#dfff00", 223, 255, 0));
        colors.put("chartreuse_web", new KmlColour("chartreuse_web", "Chartreuse (Web)", "#7fff00", 127, 255, 0));
        colors.put("cherry", new KmlColour("cherry", "Cherry", "#de3163", 222, 49, 99));
        colors.put("cherry_blossom_pink", new KmlColour("cherry_blossom_pink", "Cherry Blossom Pink", "#ffb7c5", 255, 183, 197));
        colors.put("chestnut", new KmlColour("chestnut", "Chestnut", "#cd5c5c", 205, 92, 92));
        colors.put("china_pink", new KmlColour("china_pink", "China Pink", "#de6fa1", 222, 111, 161));
        colors.put("china_rose", new KmlColour("china_rose", "China Rose", "#a8516e", 168, 81, 110));
        colors.put("chinese_red", new KmlColour("chinese_red", "Chinese Red", "#aa381e", 170, 56, 30));
        colors.put("chocolate_traditional", new KmlColour("chocolate_traditional", "Chocolate (Traditional)", "#7b3f00", 123, 63, 0));
        colors.put("chocolate_web", new KmlColour("chocolate_web", "Chocolate (Web)", "#d2691e", 210, 105, 30));
        colors.put("chrome_yellow", new KmlColour("chrome_yellow", "Chrome Yellow", "#ffa700", 255, 167, 0));
        colors.put("cinereous", new KmlColour("cinereous", "Cinereous", "#98817b", 152, 129, 123));
        colors.put("cinnabar", new KmlColour("cinnabar", "Cinnabar", "#e34234", 227, 66, 52));
        colors.put("cinnamon", new KmlColour("cinnamon", "Cinnamon", "#d2691e", 210, 105, 30));
        colors.put("citrine", new KmlColour("citrine", "Citrine", "#e4d00a", 228, 208, 10));
        colors.put("classic_rose", new KmlColour("classic_rose", "Classic Rose", "#fbcce7", 251, 204, 231));
        colors.put("cobalt", new KmlColour("cobalt", "Cobalt", "#0047ab", 0, 71, 171));
        colors.put("cocoa_brown", new KmlColour("cocoa_brown", "Cocoa Brown", "#d2691e", 210, 105, 30));
        colors.put("coffee", new KmlColour("coffee", "Coffee", "#6f4e37", 111, 78, 55));
        colors.put("columbia_blue", new KmlColour("columbia_blue", "Columbia Blue", "#9bddff", 155, 221, 255));
        colors.put("congo_pink", new KmlColour("congo_pink", "Congo Pink", "#f88379", 248, 131, 121));
        colors.put("cool_black", new KmlColour("cool_black", "Cool Black", "#002e63", 0, 46, 99));
        colors.put("cool_grey", new KmlColour("cool_grey", "Cool Grey", "#8c92ac", 140, 146, 172));
        colors.put("copper", new KmlColour("copper", "Copper", "#b87333", 184, 115, 51));
        colors.put("copper_crayola", new KmlColour("copper_crayola", "Copper (Crayola)", "#da8a67", 218, 138, 103));
        colors.put("copper_penny", new KmlColour("copper_penny", "Copper Penny", "#ad6f69", 173, 111, 105));
        colors.put("copper_red", new KmlColour("copper_red", "Copper Red", "#cb6d51", 203, 109, 81));
        colors.put("copper_rose", new KmlColour("copper_rose", "Copper Rose", "#966", 153, 102, 102));
        colors.put("coquelicot", new KmlColour("coquelicot", "Coquelicot", "#ff3800", 255, 56, 0));
        colors.put("coral", new KmlColour("coral", "Coral", "#ff7f50", 255, 127, 80));
        colors.put("coral_pink", new KmlColour("coral_pink", "Coral Pink", "#f88379", 248, 131, 121));
        colors.put("coral_red", new KmlColour("coral_red", "Coral Red", "#ff4040", 255, 64, 64));
        colors.put("cordovan", new KmlColour("cordovan", "Cordovan", "#893f45", 137, 63, 69));
        colors.put("corn", new KmlColour("corn", "Corn", "#fbec5d", 251, 236, 93));
        colors.put("cornell_red", new KmlColour("cornell_red", "Cornell Red", "#b31b1b", 179, 27, 27));
        colors.put("cornflower_blue", new KmlColour("cornflower_blue", "Cornflower Blue", "#6495ed", 100, 149, 237));
        colors.put("cornsilk", new KmlColour("cornsilk", "Cornsilk", "#fff8dc", 255, 248, 220));
        colors.put("cosmic_latte", new KmlColour("cosmic_latte", "Cosmic Latte", "#fff8e7", 255, 248, 231));
        colors.put("cotton_candy", new KmlColour("cotton_candy", "Cotton Candy", "#ffbcd9", 255, 188, 217));
        colors.put("cream", new KmlColour("cream", "Cream", "#fffdd0", 255, 253, 208));
        colors.put("crimson", new KmlColour("crimson", "Crimson", "#dc143c", 220, 20, 60));
        colors.put("crimson_glory", new KmlColour("crimson_glory", "Crimson Glory", "#be0032", 190, 0, 50));
        colors.put("cyan", new KmlColour("cyan", "Cyan", "#0ff", 0, 255, 255));
        colors.put("cyan_process", new KmlColour("cyan_process", "Cyan (Process)", "#00b7eb", 0, 183, 235));
        colors.put("daffodil", new KmlColour("daffodil", "Daffodil", "#ffff31", 255, 255, 49));
        colors.put("dandelion", new KmlColour("dandelion", "Dandelion", "#f0e130", 240, 225, 48));
        colors.put("dark_blue", new KmlColour("dark_blue", "Dark Blue", "#00008b", 0, 0, 139));
        colors.put("dark_brown", new KmlColour("dark_brown", "Dark Brown", "#654321", 101, 67, 33));
        colors.put("dark_byzantium", new KmlColour("dark_byzantium", "Dark Byzantium", "#5d3954", 93, 57, 84));
        colors.put("dark_candy_apple_red", new KmlColour("dark_candy_apple_red", "Dark Candy Apple Red", "#a40000", 164, 0, 0));
        colors.put("dark_cerulean", new KmlColour("dark_cerulean", "Dark Cerulean", "#08457e", 8, 69, 126));
        colors.put("dark_chestnut", new KmlColour("dark_chestnut", "Dark Chestnut", "#986960", 152, 105, 96));
        colors.put("dark_coral", new KmlColour("dark_coral", "Dark Coral", "#cd5b45", 205, 91, 69));
        colors.put("dark_cyan", new KmlColour("dark_cyan", "Dark Cyan", "#008b8b", 0, 139, 139));
        colors.put("dark_electric_blue", new KmlColour("dark_electric_blue", "Dark Electric Blue", "#536878", 83, 104, 120));
        colors.put("dark_goldenrod", new KmlColour("dark_goldenrod", "Dark Goldenrod", "#b8860b", 184, 134, 11));
        colors.put("dark_gray", new KmlColour("dark_gray", "Dark Gray", "#a9a9a9", 169, 169, 169));
        colors.put("dark_green", new KmlColour("dark_green", "Dark Green", "#013220", 1, 50, 32));
        colors.put("dark_imperial_blue", new KmlColour("dark_imperial_blue", "Dark Imperial Blue", "#00416a", 0, 65, 106));
        colors.put("dark_jungle_green", new KmlColour("dark_jungle_green", "Dark Jungle Green", "#1a2421", 26, 36, 33));
        colors.put("dark_khaki", new KmlColour("dark_khaki", "Dark Khaki", "#bdb76b", 189, 183, 107));
        colors.put("dark_lava", new KmlColour("dark_lava", "Dark Lava", "#483c32", 72, 60, 50));
        colors.put("dark_lavender", new KmlColour("dark_lavender", "Dark Lavender", "#734f96", 115, 79, 150));
        colors.put("dark_magenta", new KmlColour("dark_magenta", "Dark Magenta", "#8b008b", 139, 0, 139));
        colors.put("dark_midnight_blue", new KmlColour("dark_midnight_blue", "Dark Midnight Blue", "#036", 0, 51, 102));
        colors.put("dark_olive_green", new KmlColour("dark_olive_green", "Dark Olive Green", "#556b2f", 85, 107, 47));
        colors.put("dark_orange", new KmlColour("dark_orange", "Dark Orange", "#ff8c00", 255, 140, 0));
        colors.put("dark_orchid", new KmlColour("dark_orchid", "Dark Orchid", "#9932cc", 153, 50, 204));
        colors.put("dark_pastel_blue", new KmlColour("dark_pastel_blue", "Dark Pastel Blue", "#779ecb", 119, 158, 203));
        colors.put("dark_pastel_green", new KmlColour("dark_pastel_green", "Dark Pastel Green", "#03c03c", 3, 192, 60));
        colors.put("dark_pastel_purple", new KmlColour("dark_pastel_purple", "Dark Pastel Purple", "#966fd6", 150, 111, 214));
        colors.put("dark_pastel_red", new KmlColour("dark_pastel_red", "Dark Pastel Red", "#c23b22", 194, 59, 34));
        colors.put("dark_pink", new KmlColour("dark_pink", "Dark Pink", "#e75480", 231, 84, 128));
        colors.put("dark_powder_blue", new KmlColour("dark_powder_blue", "Dark Powder Blue", "#039", 0, 51, 153));
        colors.put("dark_raspberry", new KmlColour("dark_raspberry", "Dark Raspberry", "#872657", 135, 38, 87));
        colors.put("dark_red", new KmlColour("dark_red", "Dark Red", "#8b0000", 139, 0, 0));
        colors.put("dark_salmon", new KmlColour("dark_salmon", "Dark Salmon", "#e9967a", 233, 150, 122));
        colors.put("dark_scarlet", new KmlColour("dark_scarlet", "Dark Scarlet", "#560319", 86, 3, 25));
        colors.put("dark_sea_green", new KmlColour("dark_sea_green", "Dark Sea Green", "#8fbc8f", 143, 188, 143));
        colors.put("dark_sienna", new KmlColour("dark_sienna", "Dark Sienna", "#3c1414", 60, 20, 20));
        colors.put("dark_slate_blue", new KmlColour("dark_slate_blue", "Dark Slate Blue", "#483d8b", 72, 61, 139));
        colors.put("dark_slate_gray", new KmlColour("dark_slate_gray", "Dark Slate Gray", "#2f4f4f", 47, 79, 79));
        colors.put("dark_spring_green", new KmlColour("dark_spring_green", "Dark Spring Green", "#177245", 23, 114, 69));
        colors.put("dark_tan", new KmlColour("dark_tan", "Dark Tan", "#918151", 145, 129, 81));
        colors.put("dark_tangerine", new KmlColour("dark_tangerine", "Dark Tangerine", "#ffa812", 255, 168, 18));
        colors.put("dark_taupe", new KmlColour("dark_taupe", "Dark Taupe", "#483c32", 72, 60, 50));
        colors.put("dark_terra_cotta", new KmlColour("dark_terra_cotta", "Dark Terra Cotta", "#cc4e5c", 204, 78, 92));
        colors.put("dark_turquoise", new KmlColour("dark_turquoise", "Dark Turquoise", "#00ced1", 0, 206, 209));
        colors.put("dark_violet", new KmlColour("dark_violet", "Dark Violet", "#9400d3", 148, 0, 211));
        colors.put("dark_yellow", new KmlColour("dark_yellow", "Dark Yellow", "#9b870c", 155, 135, 12));
        colors.put("dartmouth_green", new KmlColour("dartmouth_green", "Dartmouth Green", "#00703c", 0, 112, 60));
        colors.put("davy_s_grey", new KmlColour("davy_s_grey", "Davy'S Grey", "#555", 85, 85, 85));
        colors.put("debian_red", new KmlColour("debian_red", "Debian Red", "#d70a53", 215, 10, 83));
        colors.put("deep_carmine", new KmlColour("deep_carmine", "Deep Carmine", "#a9203e", 169, 32, 62));
        colors.put("deep_carmine_pink", new KmlColour("deep_carmine_pink", "Deep Carmine Pink", "#ef3038", 239, 48, 56));
        colors.put("deep_carrot_orange", new KmlColour("deep_carrot_orange", "Deep Carrot Orange", "#e9692c", 233, 105, 44));
        colors.put("deep_cerise", new KmlColour("deep_cerise", "Deep Cerise", "#da3287", 218, 50, 135));
        colors.put("deep_champagne", new KmlColour("deep_champagne", "Deep Champagne", "#fad6a5", 250, 214, 165));
        colors.put("deep_chestnut", new KmlColour("deep_chestnut", "Deep Chestnut", "#b94e48", 185, 78, 72));
        colors.put("deep_coffee", new KmlColour("deep_coffee", "Deep Coffee", "#704241", 112, 66, 65));
        colors.put("deep_fuchsia", new KmlColour("deep_fuchsia", "Deep Fuchsia", "#c154c1", 193, 84, 193));
        colors.put("deep_jungle_green", new KmlColour("deep_jungle_green", "Deep Jungle Green", "#004b49", 0, 75, 73));
        colors.put("deep_lilac", new KmlColour("deep_lilac", "Deep Lilac", "#95b", 153, 85, 187));
        colors.put("deep_magenta", new KmlColour("deep_magenta", "Deep Magenta", "#c0c", 204, 0, 204));
        colors.put("deep_peach", new KmlColour("deep_peach", "Deep Peach", "#ffcba4", 255, 203, 164));
        colors.put("deep_pink", new KmlColour("deep_pink", "Deep Pink", "#ff1493", 255, 20, 147));
        colors.put("deep_ruby", new KmlColour("deep_ruby", "Deep Ruby", "#843f5b", 132, 63, 91));
        colors.put("deep_saffron", new KmlColour("deep_saffron", "Deep Saffron", "#f93", 255, 153, 51));
        colors.put("deep_sky_blue", new KmlColour("deep_sky_blue", "Deep Sky Blue", "#00bfff", 0, 191, 255));
        colors.put("deep_tuscan_red", new KmlColour("deep_tuscan_red", "Deep Tuscan Red", "#66424d", 102, 66, 77));
        colors.put("denim", new KmlColour("denim", "Denim", "#1560bd", 21, 96, 189));
        colors.put("desert", new KmlColour("desert", "Desert", "#c19a6b", 193, 154, 107));
        colors.put("desert_sand", new KmlColour("desert_sand", "Desert Sand", "#edc9af", 237, 201, 175));
        colors.put("dim_gray", new KmlColour("dim_gray", "Dim Gray", "#696969", 105, 105, 105));
        colors.put("dodger_blue", new KmlColour("dodger_blue", "Dodger Blue", "#1e90ff", 30, 144, 255));
        colors.put("dogwood_rose", new KmlColour("dogwood_rose", "Dogwood Rose", "#d71868", 215, 24, 104));
        colors.put("dollar_bill", new KmlColour("dollar_bill", "Dollar Bill", "#85bb65", 133, 187, 101));
        colors.put("drab", new KmlColour("drab", "Drab", "#967117", 150, 113, 23));
        colors.put("duke_blue", new KmlColour("duke_blue", "Duke Blue", "#00009c", 0, 0, 156));
        colors.put("earth_yellow", new KmlColour("earth_yellow", "Earth Yellow", "#e1a95f", 225, 169, 95));
        colors.put("ebony", new KmlColour("ebony", "Ebony", "#555d50", 85, 93, 80));
        colors.put("ecru", new KmlColour("ecru", "Ecru", "#c2b280", 194, 178, 128));
        colors.put("eggplant", new KmlColour("eggplant", "Eggplant", "#614051", 97, 64, 81));
        colors.put("eggshell", new KmlColour("eggshell", "Eggshell", "#f0ead6", 240, 234, 214));
        colors.put("egyptian_blue", new KmlColour("egyptian_blue", "Egyptian Blue", "#1034a6", 16, 52, 166));
        colors.put("electric_blue", new KmlColour("electric_blue", "Electric Blue", "#7df9ff", 125, 249, 255));
        colors.put("electric_crimson", new KmlColour("electric_crimson", "Electric Crimson", "#ff003f", 255, 0, 63));
        colors.put("electric_cyan", new KmlColour("electric_cyan", "Electric Cyan", "#0ff", 0, 255, 255));
        colors.put("electric_green", new KmlColour("electric_green", "Electric Green", "#0f0", 0, 255, 0));
        colors.put("electric_indigo", new KmlColour("electric_indigo", "Electric Indigo", "#6f00ff", 111, 0, 255));
        colors.put("electric_lavender", new KmlColour("electric_lavender", "Electric Lavender", "#f4bbff", 244, 187, 255));
        colors.put("electric_lime", new KmlColour("electric_lime", "Electric Lime", "#cf0", 204, 255, 0));
        colors.put("electric_purple", new KmlColour("electric_purple", "Electric Purple", "#bf00ff", 191, 0, 255));
        colors.put("electric_ultramarine", new KmlColour("electric_ultramarine", "Electric Ultramarine", "#3f00ff", 63, 0, 255));
        colors.put("electric_violet", new KmlColour("electric_violet", "Electric Violet", "#8f00ff", 143, 0, 255));
        colors.put("electric_yellow", new KmlColour("electric_yellow", "Electric Yellow", "#ff0", 255, 255, 0));
        colors.put("emerald", new KmlColour("emerald", "Emerald", "#50c878", 80, 200, 120));
        colors.put("english_lavender", new KmlColour("english_lavender", "English Lavender", "#b48395", 180, 131, 149));
        colors.put("eton_blue", new KmlColour("eton_blue", "Eton Blue", "#96c8a2", 150, 200, 162));
        colors.put("fallow", new KmlColour("fallow", "Fallow", "#c19a6b", 193, 154, 107));
        colors.put("falu_red", new KmlColour("falu_red", "Falu Red", "#801818", 128, 24, 24));
        colors.put("fandango", new KmlColour("fandango", "Fandango", "#b53389", 181, 51, 137));
        colors.put("fashion_fuchsia", new KmlColour("fashion_fuchsia", "Fashion Fuchsia", "#f400a1", 244, 0, 161));
        colors.put("fawn", new KmlColour("fawn", "Fawn", "#e5aa70", 229, 170, 112));
        colors.put("feldgrau", new KmlColour("feldgrau", "Feldgrau", "#4d5d53", 77, 93, 83));
        colors.put("fern_green", new KmlColour("fern_green", "Fern Green", "#4f7942", 79, 121, 66));
        colors.put("ferrari_red", new KmlColour("ferrari_red", "Ferrari Red", "#ff2800", 255, 40, 0));
        colors.put("field_drab", new KmlColour("field_drab", "Field Drab", "#6c541e", 108, 84, 30));
        colors.put("fire_engine_red", new KmlColour("fire_engine_red", "Fire Engine Red", "#ce2029", 206, 32, 41));
        colors.put("firebrick", new KmlColour("firebrick", "Firebrick", "#b22222", 178, 34, 34));
        colors.put("flame", new KmlColour("flame", "Flame", "#e25822", 226, 88, 34));
        colors.put("flamingo_pink", new KmlColour("flamingo_pink", "Flamingo Pink", "#fc8eac", 252, 142, 172));
        colors.put("flavescent", new KmlColour("flavescent", "Flavescent", "#f7e98e", 247, 233, 142));
        colors.put("flax", new KmlColour("flax", "Flax", "#eedc82", 238, 220, 130));
        colors.put("floral_white", new KmlColour("floral_white", "Floral White", "#fffaf0", 255, 250, 240));
        colors.put("fluorescent_orange", new KmlColour("fluorescent_orange", "Fluorescent Orange", "#ffbf00", 255, 191, 0));
        colors.put("fluorescent_pink", new KmlColour("fluorescent_pink", "Fluorescent Pink", "#ff1493", 255, 20, 147));
        colors.put("fluorescent_yellow", new KmlColour("fluorescent_yellow", "Fluorescent Yellow", "#cf0", 204, 255, 0));
        colors.put("folly", new KmlColour("folly", "Folly", "#ff004f", 255, 0, 79));
        colors.put("forest_green_traditional", new KmlColour("forest_green_traditional", "Forest Green (Traditional)", "#014421", 1, 68, 33));
        colors.put("forest_green_web", new KmlColour("forest_green_web", "Forest Green (Web)", "#228b22", 34, 139, 34));
        colors.put("french_beige", new KmlColour("french_beige", "French Beige", "#a67b5b", 166, 123, 91));
        colors.put("french_blue", new KmlColour("french_blue", "French Blue", "#0072bb", 0, 114, 187));
        colors.put("french_lilac", new KmlColour("french_lilac", "French Lilac", "#86608e", 134, 96, 142));
        colors.put("french_lime", new KmlColour("french_lime", "French Lime", "#cf0", 204, 255, 0));
        colors.put("french_raspberry", new KmlColour("french_raspberry", "French Raspberry", "#c72c48", 199, 44, 72));
        colors.put("french_rose", new KmlColour("french_rose", "French Rose", "#f64a8a", 246, 74, 138));
        colors.put("fuchsia", new KmlColour("fuchsia", "Fuchsia", "#f0f", 255, 0, 255));
        colors.put("fuchsia_crayola", new KmlColour("fuchsia_crayola", "Fuchsia (Crayola)", "#c154c1", 193, 84, 193));
        colors.put("fuchsia_pink", new KmlColour("fuchsia_pink", "Fuchsia Pink", "#f7f", 255, 119, 255));
        colors.put("fuchsia_rose", new KmlColour("fuchsia_rose", "Fuchsia Rose", "#c74375", 199, 67, 117));
        colors.put("fulvous", new KmlColour("fulvous", "Fulvous", "#e48400", 228, 132, 0));
        colors.put("fuzzy_wuzzy", new KmlColour("fuzzy_wuzzy", "Fuzzy Wuzzy", "#c66", 204, 102, 102));
        colors.put("gainsboro", new KmlColour("gainsboro", "Gainsboro", "#dcdcdc", 220, 220, 220));
        colors.put("gamboge", new KmlColour("gamboge", "Gamboge", "#e49b0f", 228, 155, 15));
        colors.put("ghost_white", new KmlColour("ghost_white", "Ghost White", "#f8f8ff", 248, 248, 255));
        colors.put("ginger", new KmlColour("ginger", "Ginger", "#b06500", 176, 101, 0));
        colors.put("glaucous", new KmlColour("glaucous", "Glaucous", "#6082b6", 96, 130, 182));
        colors.put("glitter", new KmlColour("glitter", "Glitter", "#e6e8fa", 230, 232, 250));
        colors.put("gold_metallic", new KmlColour("gold_metallic", "Gold (Metallic)", "#d4af37", 212, 175, 55));
        colors.put("gold_web_golden", new KmlColour("gold_web_golden", "Gold (Web) (Golden)", "#ffd700", 255, 215, 0));
        colors.put("golden_brown", new KmlColour("golden_brown", "Golden Brown", "#996515", 153, 101, 21));
        colors.put("golden_poppy", new KmlColour("golden_poppy", "Golden Poppy", "#fcc200", 252, 194, 0));
        colors.put("golden_yellow", new KmlColour("golden_yellow", "Golden Yellow", "#ffdf00", 255, 223, 0));
        colors.put("goldenrod", new KmlColour("goldenrod", "Goldenrod", "#daa520", 218, 165, 32));
        colors.put("granny_smith_apple", new KmlColour("granny_smith_apple", "Granny Smith Apple", "#a8e4a0", 168, 228, 160));
        colors.put("gray", new KmlColour("gray", "Gray", "#808080", 128, 128, 128));
        colors.put("gray_asparagus", new KmlColour("gray_asparagus", "Gray-Asparagus", "#465945", 70, 89, 69));
        colors.put("gray_html_css_gray", new KmlColour("gray_html_css_gray", "Gray (Html/Css Gray)", "#808080", 128, 128, 128));
        colors.put("gray_x11_gray", new KmlColour("gray_x11_gray", "Gray (X11 Gray)", "#bebebe", 190, 190, 190));
        colors.put("green_color_wheel_x11_green", new KmlColour("green_color_wheel_x11_green", "Green (Color Wheel) (X11 Green)", "#0f0", 0, 255, 0));
        colors.put("green_crayola", new KmlColour("green_crayola", "Green (Crayola)", "#1cac78", 28, 172, 120));
        colors.put("green_html_css_green", new KmlColour("green_html_css_green", "Green (Html/Css Green)", "#008000", 0, 128, 0));
        colors.put("green_munsell", new KmlColour("green_munsell", "Green (Munsell)", "#00a877", 0, 168, 119));
        colors.put("green_ncs", new KmlColour("green_ncs", "Green (Ncs)", "#009f6b", 0, 159, 107));
        colors.put("green_pigment", new KmlColour("green_pigment", "Green (Pigment)", "#00a550", 0, 165, 80));
        colors.put("green_ryb", new KmlColour("green_ryb", "Green (Ryb)", "#66b032", 102, 176, 50));
        colors.put("green_yellow", new KmlColour("green_yellow", "Green-Yellow", "#adff2f", 173, 255, 47));
        colors.put("grullo", new KmlColour("grullo", "Grullo", "#a99a86", 169, 154, 134));
        colors.put("guppie_green", new KmlColour("guppie_green", "Guppie Green", "#00ff7f", 0, 255, 127));
        colors.put("halay_be", new KmlColour("halay_be", "Halayà úBe", "#663854", 102, 56, 84));
        colors.put("han_blue", new KmlColour("han_blue", "Han Blue", "#446ccf", 68, 108, 207));
        colors.put("han_purple", new KmlColour("han_purple", "Han Purple", "#5218fa", 82, 24, 250));
        colors.put("hansa_yellow", new KmlColour("hansa_yellow", "Hansa Yellow", "#e9d66b", 233, 214, 107));
        colors.put("harlequin", new KmlColour("harlequin", "Harlequin", "#3fff00", 63, 255, 0));
        colors.put("harvard_crimson", new KmlColour("harvard_crimson", "Harvard Crimson", "#c90016", 201, 0, 22));
        colors.put("harvest_gold", new KmlColour("harvest_gold", "Harvest Gold", "#da9100", 218, 145, 0));
        colors.put("heart_gold", new KmlColour("heart_gold", "Heart Gold", "#808000", 128, 128, 0));
        colors.put("heliotrope", new KmlColour("heliotrope", "Heliotrope", "#df73ff", 223, 115, 255));
        colors.put("hollywood_cerise", new KmlColour("hollywood_cerise", "Hollywood Cerise", "#f400a1", 244, 0, 161));
        colors.put("honeydew", new KmlColour("honeydew", "Honeydew", "#f0fff0", 240, 255, 240));
        colors.put("honolulu_blue", new KmlColour("honolulu_blue", "Honolulu Blue", "#007fbf", 0, 127, 191));
        colors.put("hooker_s_green", new KmlColour("hooker_s_green", "Hooker'S Green", "#49796b", 73, 121, 107));
        colors.put("hot_magenta", new KmlColour("hot_magenta", "Hot Magenta", "#ff1dce", 255, 29, 206));
        colors.put("hot_pink", new KmlColour("hot_pink", "Hot Pink", "#ff69b4", 255, 105, 180));
        colors.put("hunter_green", new KmlColour("hunter_green", "Hunter Green", "#355e3b", 53, 94, 59));
        colors.put("iceberg", new KmlColour("iceberg", "Iceberg", "#71a6d2", 113, 166, 210));
        colors.put("icterine", new KmlColour("icterine", "Icterine", "#fcf75e", 252, 247, 94));
        colors.put("imperial_blue", new KmlColour("imperial_blue", "Imperial Blue", "#002395", 0, 35, 149));
        colors.put("inchworm", new KmlColour("inchworm", "Inchworm", "#b2ec5d", 178, 236, 93));
        colors.put("india_green", new KmlColour("india_green", "India Green", "#138808", 19, 136, 8));
        colors.put("indian_red", new KmlColour("indian_red", "Indian Red", "#cd5c5c", 205, 92, 92));
        colors.put("indian_yellow", new KmlColour("indian_yellow", "Indian Yellow", "#e3a857", 227, 168, 87));
        colors.put("indigo", new KmlColour("indigo", "Indigo", "#6f00ff", 111, 0, 255));
        colors.put("indigo_dye", new KmlColour("indigo_dye", "Indigo (Dye)", "#00416a", 0, 65, 106));
        colors.put("indigo_web", new KmlColour("indigo_web", "Indigo (Web)", "#4b0082", 75, 0, 130));
        colors.put("international_klein_blue", new KmlColour("international_klein_blue", "International Klein Blue", "#002fa7", 0, 47, 167));
        colors.put("international_orange_aerospace", new KmlColour("international_orange_aerospace", "International Orange (Aerospace)", "#ff4f00", 255, 79, 0));
        colors.put("international_orange_engineering", new KmlColour("international_orange_engineering", "International Orange (Engineering)", "#ba160c", 186, 22, 12));
        colors.put("international_orange_golden_gate_bridge", new KmlColour("international_orange_golden_gate_bridge", "International Orange (Golden Gate Bridge)", "#c0362c", 192, 54, 44));
        colors.put("iris", new KmlColour("iris", "Iris", "#5a4fcf", 90, 79, 207));
        colors.put("isabelline", new KmlColour("isabelline", "Isabelline", "#f4f0ec", 244, 240, 236));
        colors.put("islamic_green", new KmlColour("islamic_green", "Islamic Green", "#009000", 0, 144, 0));
        colors.put("ivory", new KmlColour("ivory", "Ivory", "#fffff0", 255, 255, 240));
        colors.put("jade", new KmlColour("jade", "Jade", "#00a86b", 0, 168, 107));
        colors.put("jasmine", new KmlColour("jasmine", "Jasmine", "#f8de7e", 248, 222, 126));
        colors.put("jasper", new KmlColour("jasper", "Jasper", "#d73b3e", 215, 59, 62));
        colors.put("jazzberry_jam", new KmlColour("jazzberry_jam", "Jazzberry Jam", "#a50b5e", 165, 11, 94));
        colors.put("jet", new KmlColour("jet", "Jet", "#343434", 52, 52, 52));
        colors.put("jonquil", new KmlColour("jonquil", "Jonquil", "#fada5e", 250, 218, 94));
        colors.put("june_bud", new KmlColour("june_bud", "June Bud", "#bdda57", 189, 218, 87));
        colors.put("jungle_green", new KmlColour("jungle_green", "Jungle Green", "#29ab87", 41, 171, 135));
        colors.put("kelly_green", new KmlColour("kelly_green", "Kelly Green", "#4cbb17", 76, 187, 23));
        colors.put("kenyan_copper", new KmlColour("kenyan_copper", "Kenyan Copper", "#7c1c05", 124, 28, 5));
        colors.put("khaki_html_css_khaki", new KmlColour("khaki_html_css_khaki", "Khaki (Html/Css) (Khaki)", "#c3b091", 195, 176, 145));
        colors.put("khaki_x11_light_khaki", new KmlColour("khaki_x11_light_khaki", "Khaki (X11) (Light Khaki)", "#f0e68c", 240, 230, 140));
        colors.put("ku_crimson", new KmlColour("ku_crimson", "Ku Crimson", "#e8000d", 232, 0, 13));
        colors.put("la_salle_green", new KmlColour("la_salle_green", "La Salle Green", "#087830", 8, 120, 48));
        colors.put("languid_lavender", new KmlColour("languid_lavender", "Languid Lavender", "#d6cadd", 214, 202, 221));
        colors.put("lapis_lazuli", new KmlColour("lapis_lazuli", "Lapis Lazuli", "#26619c", 38, 97, 156));
        colors.put("laser_lemon", new KmlColour("laser_lemon", "Laser Lemon", "#fefe22", 254, 254, 34));
        colors.put("laurel_green", new KmlColour("laurel_green", "Laurel Green", "#a9ba9d", 169, 186, 157));
        colors.put("lava", new KmlColour("lava", "Lava", "#cf1020", 207, 16, 32));
        colors.put("lavender_blue", new KmlColour("lavender_blue", "Lavender Blue", "#ccf", 204, 204, 255));
        colors.put("lavender_blush", new KmlColour("lavender_blush", "Lavender Blush", "#fff0f5", 255, 240, 245));
        colors.put("lavender_floral", new KmlColour("lavender_floral", "Lavender (Floral)", "#b57edc", 181, 126, 220));
        colors.put("lavender_gray", new KmlColour("lavender_gray", "Lavender Gray", "#c4c3d0", 196, 195, 208));
        colors.put("lavender_indigo", new KmlColour("lavender_indigo", "Lavender Indigo", "#9457eb", 148, 87, 235));
        colors.put("lavender_magenta", new KmlColour("lavender_magenta", "Lavender Magenta", "#ee82ee", 238, 130, 238));
        colors.put("lavender_mist", new KmlColour("lavender_mist", "Lavender Mist", "#e6e6fa", 230, 230, 250));
        colors.put("lavender_pink", new KmlColour("lavender_pink", "Lavender Pink", "#fbaed2", 251, 174, 210));
        colors.put("lavender_purple", new KmlColour("lavender_purple", "Lavender Purple", "#967bb6", 150, 123, 182));
        colors.put("lavender_rose", new KmlColour("lavender_rose", "Lavender Rose", "#fba0e3", 251, 160, 227));
        colors.put("lavender_web", new KmlColour("lavender_web", "Lavender (Web)", "#e6e6fa", 230, 230, 250));
        colors.put("lawn_green", new KmlColour("lawn_green", "Lawn Green", "#7cfc00", 124, 252, 0));
        colors.put("lemon", new KmlColour("lemon", "Lemon", "#fff700", 255, 247, 0));
        colors.put("lemon_chiffon", new KmlColour("lemon_chiffon", "Lemon Chiffon", "#fffacd", 255, 250, 205));
        colors.put("lemon_lime", new KmlColour("lemon_lime", "Lemon Lime", "#e3ff00", 227, 255, 0));
        colors.put("licorice", new KmlColour("licorice", "Licorice", "#1a1110", 26, 17, 16));
        colors.put("light_apricot", new KmlColour("light_apricot", "Light Apricot", "#fdd5b1", 253, 213, 177));
        colors.put("light_blue", new KmlColour("light_blue", "Light Blue", "#add8e6", 173, 216, 230));
        colors.put("light_brown", new KmlColour("light_brown", "Light Brown", "#b5651d", 181, 101, 29));
        colors.put("light_carmine_pink", new KmlColour("light_carmine_pink", "Light Carmine Pink", "#e66771", 230, 103, 113));
        colors.put("light_coral", new KmlColour("light_coral", "Light Coral", "#f08080", 240, 128, 128));
        colors.put("light_cornflower_blue", new KmlColour("light_cornflower_blue", "Light Cornflower Blue", "#93ccea", 147, 204, 234));
        colors.put("light_crimson", new KmlColour("light_crimson", "Light Crimson", "#f56991", 245, 105, 145));
        colors.put("light_cyan", new KmlColour("light_cyan", "Light Cyan", "#e0ffff", 224, 255, 255));
        colors.put("light_fuchsia_pink", new KmlColour("light_fuchsia_pink", "Light Fuchsia Pink", "#f984ef", 249, 132, 239));
        colors.put("light_goldenrod_yellow", new KmlColour("light_goldenrod_yellow", "Light Goldenrod Yellow", "#fafad2", 250, 250, 210));
        colors.put("light_gray", new KmlColour("light_gray", "Light Gray", "#d3d3d3", 211, 211, 211));
        colors.put("light_green", new KmlColour("light_green", "Light Green", "#90ee90", 144, 238, 144));
        colors.put("light_khaki", new KmlColour("light_khaki", "Light Khaki", "#f0e68c", 240, 230, 140));
        colors.put("light_pastel_purple", new KmlColour("light_pastel_purple", "Light Pastel Purple", "#b19cd9", 177, 156, 217));
        colors.put("light_pink", new KmlColour("light_pink", "Light Pink", "#ffb6c1", 255, 182, 193));
        colors.put("light_red_ochre", new KmlColour("light_red_ochre", "Light Red Ochre", "#e97451", 233, 116, 81));
        colors.put("light_salmon", new KmlColour("light_salmon", "Light Salmon", "#ffa07a", 255, 160, 122));
        colors.put("light_salmon_pink", new KmlColour("light_salmon_pink", "Light Salmon Pink", "#f99", 255, 153, 153));
        colors.put("light_sea_green", new KmlColour("light_sea_green", "Light Sea Green", "#20b2aa", 32, 178, 170));
        colors.put("light_sky_blue", new KmlColour("light_sky_blue", "Light Sky Blue", "#87cefa", 135, 206, 250));
        colors.put("light_slate_gray", new KmlColour("light_slate_gray", "Light Slate Gray", "#789", 119, 136, 153));
        colors.put("light_taupe", new KmlColour("light_taupe", "Light Taupe", "#b38b6d", 179, 139, 109));
        colors.put("light_thulian_pink", new KmlColour("light_thulian_pink", "Light Thulian Pink", "#e68fac", 230, 143, 172));
        colors.put("light_yellow", new KmlColour("light_yellow", "Light Yellow", "#ffffe0", 255, 255, 224));
        colors.put("lilac", new KmlColour("lilac", "Lilac", "#c8a2c8", 200, 162, 200));
        colors.put("lime_color_wheel", new KmlColour("lime_color_wheel", "Lime (Color Wheel)", "#bfff00", 191, 255, 0));
        colors.put("lime_green", new KmlColour("lime_green", "Lime Green", "#32cd32", 50, 205, 50));
        colors.put("lime_web_x11_green", new KmlColour("lime_web_x11_green", "Lime (Web) (X11 Green)", "#0f0", 0, 255, 0));
        colors.put("limerick", new KmlColour("limerick", "Limerick", "#9dc209", 157, 194, 9));
        colors.put("lincoln_green", new KmlColour("lincoln_green", "Lincoln Green", "#195905", 25, 89, 5));
        colors.put("linen", new KmlColour("linen", "Linen", "#faf0e6", 250, 240, 230));
        colors.put("lion", new KmlColour("lion", "Lion", "#c19a6b", 193, 154, 107));
        colors.put("little_boy_blue", new KmlColour("little_boy_blue", "Little Boy Blue", "#6ca0dc", 108, 160, 220));
        colors.put("liver", new KmlColour("liver", "Liver", "#534b4f", 83, 75, 79));
        colors.put("lust", new KmlColour("lust", "Lust", "#e62020", 230, 32, 32));
        colors.put("magenta", new KmlColour("magenta", "Magenta", "#f0f", 255, 0, 255));
        colors.put("magenta_dye", new KmlColour("magenta_dye", "Magenta (Dye)", "#ca1f7b", 202, 31, 123));
        colors.put("magenta_process", new KmlColour("magenta_process", "Magenta (Process)", "#ff0090", 255, 0, 144));
        colors.put("magic_mint", new KmlColour("magic_mint", "Magic Mint", "#aaf0d1", 170, 240, 209));
        colors.put("magnolia", new KmlColour("magnolia", "Magnolia", "#f8f4ff", 248, 244, 255));
        colors.put("mahogany", new KmlColour("mahogany", "Mahogany", "#c04000", 192, 64, 0));
        colors.put("maize", new KmlColour("maize", "Maize", "#fbec5d", 251, 236, 93));
        colors.put("majorelle_blue", new KmlColour("majorelle_blue", "Majorelle Blue", "#6050dc", 96, 80, 220));
        colors.put("malachite", new KmlColour("malachite", "Malachite", "#0bda51", 11, 218, 81));
        colors.put("manatee", new KmlColour("manatee", "Manatee", "#979aaa", 151, 154, 170));
        colors.put("mango_tango", new KmlColour("mango_tango", "Mango Tango", "#ff8243", 255, 130, 67));
        colors.put("mantis", new KmlColour("mantis", "Mantis", "#74c365", 116, 195, 101));
        colors.put("mardi_gras", new KmlColour("mardi_gras", "Mardi Gras", "#880085", 136, 0, 133));
        colors.put("maroon_crayola", new KmlColour("maroon_crayola", "Maroon (Crayola)", "#c32148", 195, 33, 72));
        colors.put("maroon_html_css", new KmlColour("maroon_html_css", "Maroon (Html/Css)", "#800000", 128, 0, 0));
        colors.put("maroon_x11", new KmlColour("maroon_x11", "Maroon (X11)", "#b03060", 176, 48, 96));
        colors.put("mauve", new KmlColour("mauve", "Mauve", "#e0b0ff", 224, 176, 255));
        colors.put("mauve_taupe", new KmlColour("mauve_taupe", "Mauve Taupe", "#915f6d", 145, 95, 109));
        colors.put("mauvelous", new KmlColour("mauvelous", "Mauvelous", "#ef98aa", 239, 152, 170));
        colors.put("maya_blue", new KmlColour("maya_blue", "Maya Blue", "#73c2fb", 115, 194, 251));
        colors.put("meat_brown", new KmlColour("meat_brown", "Meat Brown", "#e5b73b", 229, 183, 59));
        colors.put("medium_aquamarine", new KmlColour("medium_aquamarine", "Medium Aquamarine", "#6da", 102, 221, 170));
        colors.put("medium_blue", new KmlColour("medium_blue", "Medium Blue", "#0000cd", 0, 0, 205));
        colors.put("medium_candy_apple_red", new KmlColour("medium_candy_apple_red", "Medium Candy Apple Red", "#e2062c", 226, 6, 44));
        colors.put("medium_carmine", new KmlColour("medium_carmine", "Medium Carmine", "#af4035", 175, 64, 53));
        colors.put("medium_champagne", new KmlColour("medium_champagne", "Medium Champagne", "#f3e5ab", 243, 229, 171));
        colors.put("medium_electric_blue", new KmlColour("medium_electric_blue", "Medium Electric Blue", "#035096", 3, 80, 150));
        colors.put("medium_jungle_green", new KmlColour("medium_jungle_green", "Medium Jungle Green", "#1c352d", 28, 53, 45));
        colors.put("medium_lavender_magenta", new KmlColour("medium_lavender_magenta", "Medium Lavender Magenta", "#dda0dd", 221, 160, 221));
        colors.put("medium_orchid", new KmlColour("medium_orchid", "Medium Orchid", "#ba55d3", 186, 85, 211));
        colors.put("medium_persian_blue", new KmlColour("medium_persian_blue", "Medium Persian Blue", "#0067a5", 0, 103, 165));
        colors.put("medium_purple", new KmlColour("medium_purple", "Medium Purple", "#9370db", 147, 112, 219));
        colors.put("medium_red_violet", new KmlColour("medium_red_violet", "Medium Red-Violet", "#bb3385", 187, 51, 133));
        colors.put("medium_ruby", new KmlColour("medium_ruby", "Medium Ruby", "#aa4069", 170, 64, 105));
        colors.put("medium_sea_green", new KmlColour("medium_sea_green", "Medium Sea Green", "#3cb371", 60, 179, 113));
        colors.put("medium_slate_blue", new KmlColour("medium_slate_blue", "Medium Slate Blue", "#7b68ee", 123, 104, 238));
        colors.put("medium_spring_bud", new KmlColour("medium_spring_bud", "Medium Spring Bud", "#c9dc87", 201, 220, 135));
        colors.put("medium_spring_green", new KmlColour("medium_spring_green", "Medium Spring Green", "#00fa9a", 0, 250, 154));
        colors.put("medium_taupe", new KmlColour("medium_taupe", "Medium Taupe", "#674c47", 103, 76, 71));
        colors.put("medium_turquoise", new KmlColour("medium_turquoise", "Medium Turquoise", "#48d1cc", 72, 209, 204));
        colors.put("medium_tuscan_red", new KmlColour("medium_tuscan_red", "Medium Tuscan Red", "#79443b", 121, 68, 59));
        colors.put("medium_vermilion", new KmlColour("medium_vermilion", "Medium Vermilion", "#d9603b", 217, 96, 59));
        colors.put("medium_violet_red", new KmlColour("medium_violet_red", "Medium Violet-Red", "#c71585", 199, 21, 133));
        colors.put("mellow_apricot", new KmlColour("mellow_apricot", "Mellow Apricot", "#f8b878", 248, 184, 120));
        colors.put("mellow_yellow", new KmlColour("mellow_yellow", "Mellow Yellow", "#f8de7e", 248, 222, 126));
        colors.put("melon", new KmlColour("melon", "Melon", "#fdbcb4", 253, 188, 180));
        colors.put("midnight_blue", new KmlColour("midnight_blue", "Midnight Blue", "#191970", 25, 25, 112));
        colors.put("midnight_green_eagle_green", new KmlColour("midnight_green_eagle_green", "Midnight Green (Eagle Green)", "#004953", 0, 73, 83));
        colors.put("mikado_yellow", new KmlColour("mikado_yellow", "Mikado Yellow", "#ffc40c", 255, 196, 12));
        colors.put("mint", new KmlColour("mint", "Mint", "#3eb489", 62, 180, 137));
        colors.put("mint_cream", new KmlColour("mint_cream", "Mint Cream", "#f5fffa", 245, 255, 250));
        colors.put("mint_green", new KmlColour("mint_green", "Mint Green", "#98ff98", 152, 255, 152));
        colors.put("misty_rose", new KmlColour("misty_rose", "Misty Rose", "#ffe4e1", 255, 228, 225));
        colors.put("moccasin", new KmlColour("moccasin", "Moccasin", "#faebd7", 250, 235, 215));
        colors.put("mode_beige", new KmlColour("mode_beige", "Mode Beige", "#967117", 150, 113, 23));
        colors.put("moonstone_blue", new KmlColour("moonstone_blue", "Moonstone Blue", "#73a9c2", 115, 169, 194));
        colors.put("mordant_red_19", new KmlColour("mordant_red_19", "Mordant Red 19", "#ae0c00", 174, 12, 0));
        colors.put("moss_green", new KmlColour("moss_green", "Moss Green", "#addfad", 173, 223, 173));
        colors.put("mountain_meadow", new KmlColour("mountain_meadow", "Mountain Meadow", "#30ba8f", 48, 186, 143));
        colors.put("mountbatten_pink", new KmlColour("mountbatten_pink", "Mountbatten Pink", "#997a8d", 153, 122, 141));
        colors.put("msu_green", new KmlColour("msu_green", "Msu Green", "#18453b", 24, 69, 59));
        colors.put("mulberry", new KmlColour("mulberry", "Mulberry", "#c54b8c", 197, 75, 140));
        colors.put("mustard", new KmlColour("mustard", "Mustard", "#ffdb58", 255, 219, 88));
        colors.put("myrtle", new KmlColour("myrtle", "Myrtle", "#21421e", 33, 66, 30));
        colors.put("nadeshiko_pink", new KmlColour("nadeshiko_pink", "Nadeshiko Pink", "#f6adc6", 246, 173, 198));
        colors.put("napier_green", new KmlColour("napier_green", "Napier Green", "#2a8000", 42, 128, 0));
        colors.put("naples_yellow", new KmlColour("naples_yellow", "Naples Yellow", "#fada5e", 250, 218, 94));
        colors.put("navajo_white", new KmlColour("navajo_white", "Navajo White", "#ffdead", 255, 222, 173));
        colors.put("navy_blue", new KmlColour("navy_blue", "Navy Blue", "#000080", 0, 0, 128));
        colors.put("neon_carrot", new KmlColour("neon_carrot", "Neon Carrot", "#ffa343", 255, 163, 67));
        colors.put("neon_fuchsia", new KmlColour("neon_fuchsia", "Neon Fuchsia", "#fe4164", 254, 65, 100));
        colors.put("neon_green", new KmlColour("neon_green", "Neon Green", "#39ff14", 57, 255, 20));
        colors.put("new_york_pink", new KmlColour("new_york_pink", "New York Pink", "#d7837f", 215, 131, 127));
        colors.put("non_photo_blue", new KmlColour("non_photo_blue", "Non-Photo Blue", "#a4dded", 164, 221, 237));
        colors.put("north_texas_green", new KmlColour("north_texas_green", "North Texas Green", "#059033", 5, 144, 51));
        colors.put("ocean_boat_blue", new KmlColour("ocean_boat_blue", "Ocean Boat Blue", "#0077be", 0, 119, 190));
        colors.put("ochre", new KmlColour("ochre", "Ochre", "#c72", 204, 119, 34));
        colors.put("office_green", new KmlColour("office_green", "Office Green", "#008000", 0, 128, 0));
        colors.put("old_gold", new KmlColour("old_gold", "Old Gold", "#cfb53b", 207, 181, 59));
        colors.put("old_lace", new KmlColour("old_lace", "Old Lace", "#fdf5e6", 253, 245, 230));
        colors.put("old_lavender", new KmlColour("old_lavender", "Old Lavender", "#796878", 121, 104, 120));
        colors.put("old_mauve", new KmlColour("old_mauve", "Old Mauve", "#673147", 103, 49, 71));
        colors.put("old_rose", new KmlColour("old_rose", "Old Rose", "#c08081", 192, 128, 129));
        colors.put("olive", new KmlColour("olive", "Olive", "#808000", 128, 128, 0));
        colors.put("olive_drab_7", new KmlColour("olive_drab_7", "Olive Drab #7", "#3c341f", 60, 52, 31));
        colors.put("olive_drab_web_olive_drab_3", new KmlColour("olive_drab_web_olive_drab_3", "Olive Drab (Web) (Olive Drab #3)", "#6b8e23", 107, 142, 35));
        colors.put("olivine", new KmlColour("olivine", "Olivine", "#9ab973", 154, 185, 115));
        colors.put("onyx", new KmlColour("onyx", "Onyx", "#353839", 53, 56, 57));
        colors.put("opera_mauve", new KmlColour("opera_mauve", "Opera Mauve", "#b784a7", 183, 132, 167));
        colors.put("orange_color_wheel", new KmlColour("orange_color_wheel", "Orange (Color Wheel)", "#ff7f00", 255, 127, 0));
        colors.put("orange_peel", new KmlColour("orange_peel", "Orange Peel", "#ff9f00", 255, 159, 0));
        colors.put("orange_red", new KmlColour("orange_red", "Orange-Red", "#ff4500", 255, 69, 0));
        colors.put("orange_ryb", new KmlColour("orange_ryb", "Orange (Ryb)", "#fb9902", 251, 153, 2));
        colors.put("orange_web_color", new KmlColour("orange_web_color", "Orange (Web Color)", "#ffa500", 255, 165, 0));
        colors.put("orchid", new KmlColour("orchid", "Orchid", "#da70d6", 218, 112, 214));
        colors.put("otter_brown", new KmlColour("otter_brown", "Otter Brown", "#654321", 101, 67, 33));
        colors.put("ou_crimson_red", new KmlColour("ou_crimson_red", "Ou Crimson Red", "#900", 153, 0, 0));
        colors.put("outer_space", new KmlColour("outer_space", "Outer Space", "#414a4c", 65, 74, 76));
        colors.put("outrageous_orange", new KmlColour("outrageous_orange", "Outrageous Orange", "#ff6e4a", 255, 110, 74));
        colors.put("oxford_blue", new KmlColour("oxford_blue", "Oxford Blue", "#002147", 0, 33, 71));
        colors.put("pakistan_green", new KmlColour("pakistan_green", "Pakistan Green", "#060", 0, 102, 0));
        colors.put("palatinate_blue", new KmlColour("palatinate_blue", "Palatinate Blue", "#273be2", 39, 59, 226));
        colors.put("palatinate_purple", new KmlColour("palatinate_purple", "Palatinate Purple", "#682860", 104, 40, 96));
        colors.put("pale_aqua", new KmlColour("pale_aqua", "Pale Aqua", "#bcd4e6", 188, 212, 230));
        colors.put("pale_blue", new KmlColour("pale_blue", "Pale Blue", "#afeeee", 175, 238, 238));
        colors.put("pale_brown", new KmlColour("pale_brown", "Pale Brown", "#987654", 152, 118, 84));
        colors.put("pale_carmine", new KmlColour("pale_carmine", "Pale Carmine", "#af4035", 175, 64, 53));
        colors.put("pale_cerulean", new KmlColour("pale_cerulean", "Pale Cerulean", "#9bc4e2", 155, 196, 226));
        colors.put("pale_chestnut", new KmlColour("pale_chestnut", "Pale Chestnut", "#ddadaf", 221, 173, 175));
        colors.put("pale_copper", new KmlColour("pale_copper", "Pale Copper", "#da8a67", 218, 138, 103));
        colors.put("pale_cornflower_blue", new KmlColour("pale_cornflower_blue", "Pale Cornflower Blue", "#abcdef", 171, 205, 239));
        colors.put("pale_gold", new KmlColour("pale_gold", "Pale Gold", "#e6be8a", 230, 190, 138));
        colors.put("pale_goldenrod", new KmlColour("pale_goldenrod", "Pale Goldenrod", "#eee8aa", 238, 232, 170));
        colors.put("pale_green", new KmlColour("pale_green", "Pale Green", "#98fb98", 152, 251, 152));
        colors.put("pale_lavender", new KmlColour("pale_lavender", "Pale Lavender", "#dcd0ff", 220, 208, 255));
        colors.put("pale_magenta", new KmlColour("pale_magenta", "Pale Magenta", "#f984e5", 249, 132, 229));
        colors.put("pale_pink", new KmlColour("pale_pink", "Pale Pink", "#fadadd", 250, 218, 221));
        colors.put("pale_plum", new KmlColour("pale_plum", "Pale Plum", "#dda0dd", 221, 160, 221));
        colors.put("pale_red_violet", new KmlColour("pale_red_violet", "Pale Red-Violet", "#db7093", 219, 112, 147));
        colors.put("pale_robin_egg_blue", new KmlColour("pale_robin_egg_blue", "Pale Robin Egg Blue", "#96ded1", 150, 222, 209));
        colors.put("pale_silver", new KmlColour("pale_silver", "Pale Silver", "#c9c0bb", 201, 192, 187));
        colors.put("pale_spring_bud", new KmlColour("pale_spring_bud", "Pale Spring Bud", "#ecebbd", 236, 235, 189));
        colors.put("pale_taupe", new KmlColour("pale_taupe", "Pale Taupe", "#bc987e", 188, 152, 126));
        colors.put("pale_violet_red", new KmlColour("pale_violet_red", "Pale Violet-Red", "#db7093", 219, 112, 147));
        colors.put("pansy_purple", new KmlColour("pansy_purple", "Pansy Purple", "#78184a", 120, 24, 74));
        colors.put("papaya_whip", new KmlColour("papaya_whip", "Papaya Whip", "#ffefd5", 255, 239, 213));
        colors.put("paris_green", new KmlColour("paris_green", "Paris Green", "#50c878", 80, 200, 120));
        colors.put("pastel_blue", new KmlColour("pastel_blue", "Pastel Blue", "#aec6cf", 174, 198, 207));
        colors.put("pastel_brown", new KmlColour("pastel_brown", "Pastel Brown", "#836953", 131, 105, 83));
        colors.put("pastel_gray", new KmlColour("pastel_gray", "Pastel Gray", "#cfcfc4", 207, 207, 196));
        colors.put("pastel_green", new KmlColour("pastel_green", "Pastel Green", "#7d7", 119, 221, 119));
        colors.put("pastel_magenta", new KmlColour("pastel_magenta", "Pastel Magenta", "#f49ac2", 244, 154, 194));
        colors.put("pastel_orange", new KmlColour("pastel_orange", "Pastel Orange", "#ffb347", 255, 179, 71));
        colors.put("pastel_pink", new KmlColour("pastel_pink", "Pastel Pink", "#dea5a4", 222, 165, 164));
        colors.put("pastel_purple", new KmlColour("pastel_purple", "Pastel Purple", "#b39eb5", 179, 158, 181));
        colors.put("pastel_red", new KmlColour("pastel_red", "Pastel Red", "#ff6961", 255, 105, 97));
        colors.put("pastel_violet", new KmlColour("pastel_violet", "Pastel Violet", "#cb99c9", 203, 153, 201));
        colors.put("pastel_yellow", new KmlColour("pastel_yellow", "Pastel Yellow", "#fdfd96", 253, 253, 150));
        colors.put("patriarch", new KmlColour("patriarch", "Patriarch", "#800080", 128, 0, 128));
        colors.put("payne_s_grey", new KmlColour("payne_s_grey", "Payne'S Grey", "#536878", 83, 104, 120));
        colors.put("peach", new KmlColour("peach", "Peach", "#ffe5b4", 255, 229, 180));
        colors.put("peach_crayola", new KmlColour("peach_crayola", "Peach (Crayola)", "#ffcba4", 255, 203, 164));
        colors.put("peach_orange", new KmlColour("peach_orange", "Peach-Orange", "#fc9", 255, 204, 153));
        colors.put("peach_puff", new KmlColour("peach_puff", "Peach Puff", "#ffdab9", 255, 218, 185));
        colors.put("peach_yellow", new KmlColour("peach_yellow", "Peach-Yellow", "#fadfad", 250, 223, 173));
        colors.put("pear", new KmlColour("pear", "Pear", "#d1e231", 209, 226, 49));
        colors.put("pearl", new KmlColour("pearl", "Pearl", "#eae0c8", 234, 224, 200));
        colors.put("pearl_aqua", new KmlColour("pearl_aqua", "Pearl Aqua", "#88d8c0", 136, 216, 192));
        colors.put("pearly_purple", new KmlColour("pearly_purple", "Pearly Purple", "#b768a2", 183, 104, 162));
        colors.put("peridot", new KmlColour("peridot", "Peridot", "#e6e200", 230, 226, 0));
        colors.put("periwinkle", new KmlColour("periwinkle", "Periwinkle", "#ccf", 204, 204, 255));
        colors.put("persian_blue", new KmlColour("persian_blue", "Persian Blue", "#1c39bb", 28, 57, 187));
        colors.put("persian_green", new KmlColour("persian_green", "Persian Green", "#00a693", 0, 166, 147));
        colors.put("persian_indigo", new KmlColour("persian_indigo", "Persian Indigo", "#32127a", 50, 18, 122));
        colors.put("persian_orange", new KmlColour("persian_orange", "Persian Orange", "#d99058", 217, 144, 88));
        colors.put("persian_pink", new KmlColour("persian_pink", "Persian Pink", "#f77fbe", 247, 127, 190));
        colors.put("persian_plum", new KmlColour("persian_plum", "Persian Plum", "#701c1c", 112, 28, 28));
        colors.put("persian_red", new KmlColour("persian_red", "Persian Red", "#c33", 204, 51, 51));
        colors.put("persian_rose", new KmlColour("persian_rose", "Persian Rose", "#fe28a2", 254, 40, 162));
        colors.put("persimmon", new KmlColour("persimmon", "Persimmon", "#ec5800", 236, 88, 0));
        colors.put("peru", new KmlColour("peru", "Peru", "#cd853f", 205, 133, 63));
        colors.put("phlox", new KmlColour("phlox", "Phlox", "#df00ff", 223, 0, 255));
        colors.put("phthalo_blue", new KmlColour("phthalo_blue", "Phthalo Blue", "#000f89", 0, 15, 137));
        colors.put("phthalo_green", new KmlColour("phthalo_green", "Phthalo Green", "#123524", 18, 53, 36));
        colors.put("piggy_pink", new KmlColour("piggy_pink", "Piggy Pink", "#fddde6", 253, 221, 230));
        colors.put("pine_green", new KmlColour("pine_green", "Pine Green", "#01796f", 1, 121, 111));
        colors.put("pink", new KmlColour("pink", "Pink", "#ffc0cb", 255, 192, 203));
        colors.put("pink_lace", new KmlColour("pink_lace", "Pink Lace", "#ffddf4", 255, 221, 244));
        colors.put("pink_orange", new KmlColour("pink_orange", "Pink-Orange", "#f96", 255, 153, 102));
        colors.put("pink_pearl", new KmlColour("pink_pearl", "Pink Pearl", "#e7accf", 231, 172, 207));
        colors.put("pink_sherbet", new KmlColour("pink_sherbet", "Pink Sherbet", "#f78fa7", 247, 143, 167));
        colors.put("pistachio", new KmlColour("pistachio", "Pistachio", "#93c572", 147, 197, 114));
        colors.put("platinum", new KmlColour("platinum", "Platinum", "#e5e4e2", 229, 228, 226));
        colors.put("plum_traditional", new KmlColour("plum_traditional", "Plum (Traditional)", "#8e4585", 142, 69, 133));
        colors.put("plum_web", new KmlColour("plum_web", "Plum (Web)", "#dda0dd", 221, 160, 221));
        colors.put("portland_orange", new KmlColour("portland_orange", "Portland Orange", "#ff5a36", 255, 90, 54));
        colors.put("powder_blue_web", new KmlColour("powder_blue_web", "Powder Blue (Web)", "#b0e0e6", 176, 224, 230));
        colors.put("princeton_orange", new KmlColour("princeton_orange", "Princeton Orange", "#ff8f00", 255, 143, 0));
        colors.put("prune", new KmlColour("prune", "Prune", "#701c1c", 112, 28, 28));
        colors.put("prussian_blue", new KmlColour("prussian_blue", "Prussian Blue", "#003153", 0, 49, 83));
        colors.put("psychedelic_purple", new KmlColour("psychedelic_purple", "Psychedelic Purple", "#df00ff", 223, 0, 255));
        colors.put("puce", new KmlColour("puce", "Puce", "#c89", 204, 136, 153));
        colors.put("pumpkin", new KmlColour("pumpkin", "Pumpkin", "#ff7518", 255, 117, 24));
        colors.put("purple_heart", new KmlColour("purple_heart", "Purple Heart", "#69359c", 105, 53, 156));
        colors.put("purple_html_css", new KmlColour("purple_html_css", "Purple (Html/Css)", "#800080", 128, 0, 128));
        colors.put("purple_mountain_majesty", new KmlColour("purple_mountain_majesty", "Purple Mountain Majesty", "#9678b6", 150, 120, 182));
        colors.put("purple_munsell", new KmlColour("purple_munsell", "Purple (Munsell)", "#9f00c5", 159, 0, 197));
        colors.put("purple_pizzazz", new KmlColour("purple_pizzazz", "Purple Pizzazz", "#fe4eda", 254, 78, 218));
        colors.put("purple_taupe", new KmlColour("purple_taupe", "Purple Taupe", "#50404d", 80, 64, 77));
        colors.put("purple_x11", new KmlColour("purple_x11", "Purple (X11)", "#a020f0", 160, 32, 240));
        colors.put("quartz", new KmlColour("quartz", "Quartz", "#51484f", 81, 72, 79));
        colors.put("rackley", new KmlColour("rackley", "Rackley", "#5d8aa8", 93, 138, 168));
        colors.put("radical_red", new KmlColour("radical_red", "Radical Red", "#ff355e", 255, 53, 94));
        colors.put("rajah", new KmlColour("rajah", "Rajah", "#fbab60", 251, 171, 96));
        colors.put("raspberry", new KmlColour("raspberry", "Raspberry", "#e30b5d", 227, 11, 93));
        colors.put("raspberry_glace", new KmlColour("raspberry_glace", "Raspberry Glace", "#915f6d", 145, 95, 109));
        colors.put("raspberry_pink", new KmlColour("raspberry_pink", "Raspberry Pink", "#e25098", 226, 80, 152));
        colors.put("raspberry_rose", new KmlColour("raspberry_rose", "Raspberry Rose", "#b3446c", 179, 68, 108));
        colors.put("raw_umber", new KmlColour("raw_umber", "Raw Umber", "#826644", 130, 102, 68));
        colors.put("razzle_dazzle_rose", new KmlColour("razzle_dazzle_rose", "Razzle Dazzle Rose", "#f3c", 255, 51, 204));
        colors.put("razzmatazz", new KmlColour("razzmatazz", "Razzmatazz", "#e3256b", 227, 37, 107));
        colors.put("red", new KmlColour("red", "Red", "#f00", 255, 0, 0));
        colors.put("red_brown", new KmlColour("red_brown", "Red-Brown", "#a52a2a", 165, 42, 42));
        colors.put("red_devil", new KmlColour("red_devil", "Red Devil", "#860111", 134, 1, 17));
        colors.put("red_munsell", new KmlColour("red_munsell", "Red (Munsell)", "#f2003c", 242, 0, 60));
        colors.put("red_ncs", new KmlColour("red_ncs", "Red (Ncs)", "#c40233", 196, 2, 51));
        colors.put("red_orange", new KmlColour("red_orange", "Red-Orange", "#ff5349", 255, 83, 73));
        colors.put("red_pigment", new KmlColour("red_pigment", "Red (Pigment)", "#ed1c24", 237, 28, 36));
        colors.put("red_ryb", new KmlColour("red_ryb", "Red (Ryb)", "#fe2712", 254, 39, 18));
        colors.put("red_violet", new KmlColour("red_violet", "Red-Violet", "#c71585", 199, 21, 133));
        colors.put("redwood", new KmlColour("redwood", "Redwood", "#ab4e52", 171, 78, 82));
        colors.put("regalia", new KmlColour("regalia", "Regalia", "#522d80", 82, 45, 128));
        colors.put("resolution_blue", new KmlColour("resolution_blue", "Resolution Blue", "#002387", 0, 35, 135));
        colors.put("rich_black", new KmlColour("rich_black", "Rich Black", "#004040", 0, 64, 64));
        colors.put("rich_brilliant_lavender", new KmlColour("rich_brilliant_lavender", "Rich Brilliant Lavender", "#f1a7fe", 241, 167, 254));
        colors.put("rich_carmine", new KmlColour("rich_carmine", "Rich Carmine", "#d70040", 215, 0, 64));
        colors.put("rich_electric_blue", new KmlColour("rich_electric_blue", "Rich Electric Blue", "#0892d0", 8, 146, 208));
        colors.put("rich_lavender", new KmlColour("rich_lavender", "Rich Lavender", "#a76bcf", 167, 107, 207));
        colors.put("rich_lilac", new KmlColour("rich_lilac", "Rich Lilac", "#b666d2", 182, 102, 210));
        colors.put("rich_maroon", new KmlColour("rich_maroon", "Rich Maroon", "#b03060", 176, 48, 96));
        colors.put("rifle_green", new KmlColour("rifle_green", "Rifle Green", "#414833", 65, 72, 51));
        colors.put("robin_egg_blue", new KmlColour("robin_egg_blue", "Robin Egg Blue", "#0cc", 0, 204, 204));
        colors.put("rose", new KmlColour("rose", "Rose", "#ff007f", 255, 0, 127));
        colors.put("rose_bonbon", new KmlColour("rose_bonbon", "Rose Bonbon", "#f9429e", 249, 66, 158));
        colors.put("rose_ebony", new KmlColour("rose_ebony", "Rose Ebony", "#674846", 103, 72, 70));
        colors.put("rose_gold", new KmlColour("rose_gold", "Rose Gold", "#b76e79", 183, 110, 121));
        colors.put("rose_madder", new KmlColour("rose_madder", "Rose Madder", "#e32636", 227, 38, 54));
        colors.put("rose_pink", new KmlColour("rose_pink", "Rose Pink", "#f6c", 255, 102, 204));
        colors.put("rose_quartz", new KmlColour("rose_quartz", "Rose Quartz", "#aa98a9", 170, 152, 169));
        colors.put("rose_taupe", new KmlColour("rose_taupe", "Rose Taupe", "#905d5d", 144, 93, 93));
        colors.put("rose_vale", new KmlColour("rose_vale", "Rose Vale", "#ab4e52", 171, 78, 82));
        colors.put("rosewood", new KmlColour("rosewood", "Rosewood", "#65000b", 101, 0, 11));
        colors.put("rosso_corsa", new KmlColour("rosso_corsa", "Rosso Corsa", "#d40000", 212, 0, 0));
        colors.put("rosy_brown", new KmlColour("rosy_brown", "Rosy Brown", "#bc8f8f", 188, 143, 143));
        colors.put("royal_azure", new KmlColour("royal_azure", "Royal Azure", "#0038a8", 0, 56, 168));
        colors.put("royal_blue_traditional", new KmlColour("royal_blue_traditional", "Royal Blue (Traditional)", "#002366", 0, 35, 102));
        colors.put("royal_blue_web", new KmlColour("royal_blue_web", "Royal Blue (Web)", "#4169e1", 65, 105, 225));
        colors.put("royal_fuchsia", new KmlColour("royal_fuchsia", "Royal Fuchsia", "#ca2c92", 202, 44, 146));
        colors.put("royal_purple", new KmlColour("royal_purple", "Royal Purple", "#7851a9", 120, 81, 169));
        colors.put("royal_yellow", new KmlColour("royal_yellow", "Royal Yellow", "#fada5e", 250, 218, 94));
        colors.put("rubine_red", new KmlColour("rubine_red", "Rubine Red", "#d10056", 209, 0, 86));
        colors.put("ruby", new KmlColour("ruby", "Ruby", "#e0115f", 224, 17, 95));
        colors.put("ruby_red", new KmlColour("ruby_red", "Ruby Red", "#9b111e", 155, 17, 30));
        colors.put("ruddy", new KmlColour("ruddy", "Ruddy", "#ff0028", 255, 0, 40));
        colors.put("ruddy_brown", new KmlColour("ruddy_brown", "Ruddy Brown", "#bb6528", 187, 101, 40));
        colors.put("ruddy_pink", new KmlColour("ruddy_pink", "Ruddy Pink", "#e18e96", 225, 142, 150));
        colors.put("rufous", new KmlColour("rufous", "Rufous", "#a81c07", 168, 28, 7));
        colors.put("russet", new KmlColour("russet", "Russet", "#80461b", 128, 70, 27));
        colors.put("rust", new KmlColour("rust", "Rust", "#b7410e", 183, 65, 14));
        colors.put("rusty_red", new KmlColour("rusty_red", "Rusty Red", "#da2c43", 218, 44, 67));
        colors.put("sacramento_state_green", new KmlColour("sacramento_state_green", "Sacramento State Green", "#00563f", 0, 86, 63));
        colors.put("saddle_brown", new KmlColour("saddle_brown", "Saddle Brown", "#8b4513", 139, 69, 19));
        colors.put("safety_orange_blaze_orange", new KmlColour("safety_orange_blaze_orange", "Safety Orange (Blaze Orange)", "#ff6700", 255, 103, 0));
        colors.put("saffron", new KmlColour("saffron", "Saffron", "#f4c430", 244, 196, 48));
        colors.put("salmon", new KmlColour("salmon", "Salmon", "#ff8c69", 255, 140, 105));
        colors.put("salmon_pink", new KmlColour("salmon_pink", "Salmon Pink", "#ff91a4", 255, 145, 164));
        colors.put("sand", new KmlColour("sand", "Sand", "#c2b280", 194, 178, 128));
        colors.put("sand_dune", new KmlColour("sand_dune", "Sand Dune", "#967117", 150, 113, 23));
        colors.put("sandstorm", new KmlColour("sandstorm", "Sandstorm", "#ecd540", 236, 213, 64));
        colors.put("sandy_brown", new KmlColour("sandy_brown", "Sandy Brown", "#f4a460", 244, 164, 96));
        colors.put("sandy_taupe", new KmlColour("sandy_taupe", "Sandy Taupe", "#967117", 150, 113, 23));
        colors.put("sangria", new KmlColour("sangria", "Sangria", "#92000a", 146, 0, 10));
        colors.put("sap_green", new KmlColour("sap_green", "Sap Green", "#507d2a", 80, 125, 42));
        colors.put("sapphire", new KmlColour("sapphire", "Sapphire", "#0f52ba", 15, 82, 186));
        colors.put("sapphire_blue", new KmlColour("sapphire_blue", "Sapphire Blue", "#0067a5", 0, 103, 165));
        colors.put("satin_sheen_gold", new KmlColour("satin_sheen_gold", "Satin Sheen Gold", "#cba135", 203, 161, 53));
        colors.put("scarlet", new KmlColour("scarlet", "Scarlet", "#ff2400", 255, 36, 0));
        colors.put("scarlet_crayola", new KmlColour("scarlet_crayola", "Scarlet (Crayola)", "#fd0e35", 253, 14, 53));
        colors.put("school_bus_yellow", new KmlColour("school_bus_yellow", "School Bus Yellow", "#ffd800", 255, 216, 0));
        colors.put("screamin_green", new KmlColour("screamin_green", "Screamin' Green", "#76ff7a", 118, 255, 122));
        colors.put("sea_blue", new KmlColour("sea_blue", "Sea Blue", "#006994", 0, 105, 148));
        colors.put("sea_green", new KmlColour("sea_green", "Sea Green", "#2e8b57", 46, 139, 87));
        colors.put("seal_brown", new KmlColour("seal_brown", "Seal Brown", "#321414", 50, 20, 20));
        colors.put("seashell", new KmlColour("seashell", "Seashell", "#fff5ee", 255, 245, 238));
        colors.put("selective_yellow", new KmlColour("selective_yellow", "Selective Yellow", "#ffba00", 255, 186, 0));
        colors.put("sepia", new KmlColour("sepia", "Sepia", "#704214", 112, 66, 20));
        colors.put("shadow", new KmlColour("shadow", "Shadow", "#8a795d", 138, 121, 93));
        colors.put("shamrock_green", new KmlColour("shamrock_green", "Shamrock Green", "#009e60", 0, 158, 96));
        colors.put("shocking_pink", new KmlColour("shocking_pink", "Shocking Pink", "#fc0fc0", 252, 15, 192));
        colors.put("shocking_pink_crayola", new KmlColour("shocking_pink_crayola", "Shocking Pink (Crayola)", "#ff6fff", 255, 111, 255));
        colors.put("sienna", new KmlColour("sienna", "Sienna", "#882d17", 136, 45, 23));
        colors.put("silver", new KmlColour("silver", "Silver", "#c0c0c0", 192, 192, 192));
        colors.put("sinopia", new KmlColour("sinopia", "Sinopia", "#cb410b", 203, 65, 11));
        colors.put("skobeloff", new KmlColour("skobeloff", "Skobeloff", "#007474", 0, 116, 116));
        colors.put("sky_blue", new KmlColour("sky_blue", "Sky Blue", "#87ceeb", 135, 206, 235));
        colors.put("sky_magenta", new KmlColour("sky_magenta", "Sky Magenta", "#cf71af", 207, 113, 175));
        colors.put("slate_blue", new KmlColour("slate_blue", "Slate Blue", "#6a5acd", 106, 90, 205));
        colors.put("slate_gray", new KmlColour("slate_gray", "Slate Gray", "#708090", 112, 128, 144));
        colors.put("smalt_dark_powder_blue", new KmlColour("smalt_dark_powder_blue", "Smalt (Dark Powder Blue)", "#039", 0, 51, 153));
        colors.put("smokey_topaz", new KmlColour("smokey_topaz", "Smokey Topaz", "#933d41", 147, 61, 65));
        colors.put("smoky_black", new KmlColour("smoky_black", "Smoky Black", "#100c08", 16, 12, 8));
        colors.put("snow", new KmlColour("snow", "Snow", "#fffafa", 255, 250, 250));
        colors.put("spiro_disco_ball", new KmlColour("spiro_disco_ball", "Spiro Disco Ball", "#0fc0fc", 15, 192, 252));
        colors.put("spring_bud", new KmlColour("spring_bud", "Spring Bud", "#a7fc00", 167, 252, 0));
        colors.put("spring_green", new KmlColour("spring_green", "Spring Green", "#00ff7f", 0, 255, 127));
        colors.put("st_patrick_s_blue", new KmlColour("st_patrick_s_blue", "St. Patrick'S Blue", "#23297a", 35, 41, 122));
        colors.put("steel_blue", new KmlColour("steel_blue", "Steel Blue", "#4682b4", 70, 130, 180));
        colors.put("stil_de_grain_yellow", new KmlColour("stil_de_grain_yellow", "Stil De Grain Yellow", "#fada5e", 250, 218, 94));
        colors.put("stizza", new KmlColour("stizza", "Stizza", "#900", 153, 0, 0));
        colors.put("stormcloud", new KmlColour("stormcloud", "Stormcloud", "#4f666a", 79, 102, 106));
        colors.put("straw", new KmlColour("straw", "Straw", "#e4d96f", 228, 217, 111));
        colors.put("sunglow", new KmlColour("sunglow", "Sunglow", "#fc3", 255, 204, 51));
        colors.put("sunset", new KmlColour("sunset", "Sunset", "#fad6a5", 250, 214, 165));
        colors.put("tan", new KmlColour("tan", "Tan", "#d2b48c", 210, 180, 140));
        colors.put("tangelo", new KmlColour("tangelo", "Tangelo", "#f94d00", 249, 77, 0));
        colors.put("tangerine", new KmlColour("tangerine", "Tangerine", "#f28500", 242, 133, 0));
        colors.put("tangerine_yellow", new KmlColour("tangerine_yellow", "Tangerine Yellow", "#fc0", 255, 204, 0));
        colors.put("tango_pink", new KmlColour("tango_pink", "Tango Pink", "#e4717a", 228, 113, 122));
        colors.put("taupe", new KmlColour("taupe", "Taupe", "#483c32", 72, 60, 50));
        colors.put("taupe_gray", new KmlColour("taupe_gray", "Taupe Gray", "#8b8589", 139, 133, 137));
        colors.put("tea_green", new KmlColour("tea_green", "Tea Green", "#d0f0c0", 208, 240, 192));
        colors.put("tea_rose_orange", new KmlColour("tea_rose_orange", "Tea Rose (Orange)", "#f88379", 248, 131, 121));
        colors.put("tea_rose_rose", new KmlColour("tea_rose_rose", "Tea Rose (Rose)", "#f4c2c2", 244, 194, 194));
        colors.put("teal", new KmlColour("teal", "Teal", "#008080", 0, 128, 128));
        colors.put("teal_blue", new KmlColour("teal_blue", "Teal Blue", "#367588", 54, 117, 136));
        colors.put("teal_green", new KmlColour("teal_green", "Teal Green", "#00827f", 0, 130, 127));
        colors.put("telemagenta", new KmlColour("telemagenta", "Telemagenta", "#cf3476", 207, 52, 118));
        colors.put("tenn_tawny", new KmlColour("tenn_tawny", "Tenné (Tawny)", "#cd5700", 205, 87, 0));
        colors.put("terra_cotta", new KmlColour("terra_cotta", "Terra Cotta", "#e2725b", 226, 114, 91));
        colors.put("thistle", new KmlColour("thistle", "Thistle", "#d8bfd8", 216, 191, 216));
        colors.put("thulian_pink", new KmlColour("thulian_pink", "Thulian Pink", "#de6fa1", 222, 111, 161));
        colors.put("tickle_me_pink", new KmlColour("tickle_me_pink", "Tickle Me Pink", "#fc89ac", 252, 137, 172));
        colors.put("tiffany_blue", new KmlColour("tiffany_blue", "Tiffany Blue", "#0abab5", 10, 186, 181));
        colors.put("tiger_s_eye", new KmlColour("tiger_s_eye", "Tiger'S Eye", "#e08d3c", 224, 141, 60));
        colors.put("timberwolf", new KmlColour("timberwolf", "Timberwolf", "#dbd7d2", 219, 215, 210));
        colors.put("titanium_yellow", new KmlColour("titanium_yellow", "Titanium Yellow", "#eee600", 238, 230, 0));
        colors.put("tomato", new KmlColour("tomato", "Tomato", "#ff6347", 255, 99, 71));
        colors.put("toolbox", new KmlColour("toolbox", "Toolbox", "#746cc0", 116, 108, 192));
        colors.put("topaz", new KmlColour("topaz", "Topaz", "#ffc87c", 255, 200, 124));
        colors.put("tractor_red", new KmlColour("tractor_red", "Tractor Red", "#fd0e35", 253, 14, 53));
        colors.put("trolley_grey", new KmlColour("trolley_grey", "Trolley Grey", "#808080", 128, 128, 128));
        colors.put("tropical_rain_forest", new KmlColour("tropical_rain_forest", "Tropical Rain Forest", "#00755e", 0, 117, 94));
        colors.put("true_blue", new KmlColour("true_blue", "True Blue", "#0073cf", 0, 115, 207));
        colors.put("tufts_blue", new KmlColour("tufts_blue", "Tufts Blue", "#417dc1", 65, 125, 193));
        colors.put("tumbleweed", new KmlColour("tumbleweed", "Tumbleweed", "#deaa88", 222, 170, 136));
        colors.put("turkish_rose", new KmlColour("turkish_rose", "Turkish Rose", "#b57281", 181, 114, 129));
        colors.put("turquoise", new KmlColour("turquoise", "Turquoise", "#30d5c8", 48, 213, 200));
        colors.put("turquoise_blue", new KmlColour("turquoise_blue", "Turquoise Blue", "#00ffef", 0, 255, 239));
        colors.put("turquoise_green", new KmlColour("turquoise_green", "Turquoise Green", "#a0d6b4", 160, 214, 180));
        colors.put("tuscan_red", new KmlColour("tuscan_red", "Tuscan Red", "#7c4848", 124, 72, 72));
        colors.put("twilight_lavender", new KmlColour("twilight_lavender", "Twilight Lavender", "#8a496b", 138, 73, 107));
        colors.put("tyrian_purple", new KmlColour("tyrian_purple", "Tyrian Purple", "#66023c", 102, 2, 60));
        colors.put("ua_blue", new KmlColour("ua_blue", "Ua Blue", "#03a", 0, 51, 170));
        colors.put("ua_red", new KmlColour("ua_red", "Ua Red", "#d9004c", 217, 0, 76));
        colors.put("ube", new KmlColour("ube", "Ube", "#8878c3", 136, 120, 195));
        colors.put("ucla_blue", new KmlColour("ucla_blue", "Ucla Blue", "#536895", 83, 104, 149));
        colors.put("ucla_gold", new KmlColour("ucla_gold", "Ucla Gold", "#ffb300", 255, 179, 0));
        colors.put("ufo_green", new KmlColour("ufo_green", "Ufo Green", "#3cd070", 60, 208, 112));
        colors.put("ultra_pink", new KmlColour("ultra_pink", "Ultra Pink", "#ff6fff", 255, 111, 255));
        colors.put("ultramarine", new KmlColour("ultramarine", "Ultramarine", "#120a8f", 18, 10, 143));
        colors.put("ultramarine_blue", new KmlColour("ultramarine_blue", "Ultramarine Blue", "#4166f5", 65, 102, 245));
        colors.put("umber", new KmlColour("umber", "Umber", "#635147", 99, 81, 71));
        colors.put("unbleached_silk", new KmlColour("unbleached_silk", "Unbleached Silk", "#ffddca", 255, 221, 202));
        colors.put("united_nations_blue", new KmlColour("united_nations_blue", "United Nations Blue", "#5b92e5", 91, 146, 229));
        colors.put("university_of_california_gold", new KmlColour("university_of_california_gold", "University Of California Gold", "#b78727", 183, 135, 39));
        colors.put("unmellow_yellow", new KmlColour("unmellow_yellow", "Unmellow Yellow", "#ff6", 255, 255, 102));
        colors.put("up_forest_green", new KmlColour("up_forest_green", "Up Forest Green", "#014421", 1, 68, 33));
        colors.put("up_maroon", new KmlColour("up_maroon", "Up Maroon", "#7b1113", 123, 17, 19));
        colors.put("upsdell_red", new KmlColour("upsdell_red", "Upsdell Red", "#ae2029", 174, 32, 41));
        colors.put("urobilin", new KmlColour("urobilin", "Urobilin", "#e1ad21", 225, 173, 33));
        colors.put("usafa_blue", new KmlColour("usafa_blue", "Usafa Blue", "#004f98", 0, 79, 152));
        colors.put("usc_cardinal", new KmlColour("usc_cardinal", "Usc Cardinal", "#900", 153, 0, 0));
        colors.put("usc_gold", new KmlColour("usc_gold", "Usc Gold", "#fc0", 255, 204, 0));
        colors.put("utah_crimson", new KmlColour("utah_crimson", "Utah Crimson", "#d3003f", 211, 0, 63));
        colors.put("vanilla", new KmlColour("vanilla", "Vanilla", "#f3e5ab", 243, 229, 171));
        colors.put("vegas_gold", new KmlColour("vegas_gold", "Vegas Gold", "#c5b358", 197, 179, 88));
        colors.put("venetian_red", new KmlColour("venetian_red", "Venetian Red", "#c80815", 200, 8, 21));
        colors.put("verdigris", new KmlColour("verdigris", "Verdigris", "#43b3ae", 67, 179, 174));
        colors.put("vermilion_cinnabar", new KmlColour("vermilion_cinnabar", "Vermilion (Cinnabar)", "#e34234", 227, 66, 52));
        colors.put("vermilion_plochere", new KmlColour("vermilion_plochere", "Vermilion (Plochere)", "#d9603b", 217, 96, 59));
        colors.put("veronica", new KmlColour("veronica", "Veronica", "#a020f0", 160, 32, 240));
        colors.put("violet", new KmlColour("violet", "Violet", "#8f00ff", 143, 0, 255));
        colors.put("violet_blue", new KmlColour("violet_blue", "Violet-Blue", "#324ab2", 50, 74, 178));
        colors.put("violet_color_wheel", new KmlColour("violet_color_wheel", "Violet (Color Wheel)", "#7f00ff", 127, 0, 255));
        colors.put("violet_ryb", new KmlColour("violet_ryb", "Violet (Ryb)", "#8601af", 134, 1, 175));
        colors.put("violet_web", new KmlColour("violet_web", "Violet (Web)", "#ee82ee", 238, 130, 238));
        colors.put("viridian", new KmlColour("viridian", "Viridian", "#40826d", 64, 130, 109));
        colors.put("vivid_auburn", new KmlColour("vivid_auburn", "Vivid Auburn", "#922724", 146, 39, 36));
        colors.put("vivid_burgundy", new KmlColour("vivid_burgundy", "Vivid Burgundy", "#9f1d35", 159, 29, 53));
        colors.put("vivid_cerise", new KmlColour("vivid_cerise", "Vivid Cerise", "#da1d81", 218, 29, 129));
        colors.put("vivid_tangerine", new KmlColour("vivid_tangerine", "Vivid Tangerine", "#ffa089", 255, 160, 137));
        colors.put("vivid_violet", new KmlColour("vivid_violet", "Vivid Violet", "#9f00ff", 159, 0, 255));
        colors.put("warm_black", new KmlColour("warm_black", "Warm Black", "#004242", 0, 66, 66));
        colors.put("waterspout", new KmlColour("waterspout", "Waterspout", "#a4f4f9", 164, 244, 249));
        colors.put("wenge", new KmlColour("wenge", "Wenge", "#645452", 100, 84, 82));
        colors.put("wheat", new KmlColour("wheat", "Wheat", "#f5deb3", 245, 222, 179));
        colors.put("white", new KmlColour("white", "White", "#fff", 255, 255, 255));
        colors.put("white_smoke", new KmlColour("white_smoke", "White Smoke", "#f5f5f5", 245, 245, 245));
        colors.put("wild_blue_yonder", new KmlColour("wild_blue_yonder", "Wild Blue Yonder", "#a2add0", 162, 173, 208));
        colors.put("wild_strawberry", new KmlColour("wild_strawberry", "Wild Strawberry", "#ff43a4", 255, 67, 164));
        colors.put("wild_watermelon", new KmlColour("wild_watermelon", "Wild Watermelon", "#fc6c85", 252, 108, 133));
        colors.put("wine", new KmlColour("wine", "Wine", "#722f37", 114, 47, 55));
        colors.put("wine_dregs", new KmlColour("wine_dregs", "Wine Dregs", "#673147", 103, 49, 71));
        colors.put("wisteria", new KmlColour("wisteria", "Wisteria", "#c9a0dc", 201, 160, 220));
        colors.put("wood_brown", new KmlColour("wood_brown", "Wood Brown", "#c19a6b", 193, 154, 107));
        colors.put("xanadu", new KmlColour("xanadu", "Xanadu", "#738678", 115, 134, 120));
        colors.put("yale_blue", new KmlColour("yale_blue", "Yale Blue", "#0f4d92", 15, 77, 146));
        colors.put("yellow", new KmlColour("yellow", "Yellow", "#ff0", 255, 255, 0));
        colors.put("yellow_green", new KmlColour("yellow_green", "Yellow-Green", "#9acd32", 154, 205, 50));
        colors.put("yellow_munsell", new KmlColour("yellow_munsell", "Yellow (Munsell)", "#efcc00", 239, 204, 0));
        colors.put("yellow_ncs", new KmlColour("yellow_ncs", "Yellow (Ncs)", "#ffd300", 255, 211, 0));
        colors.put("yellow_orange", new KmlColour("yellow_orange", "Yellow Orange", "#ffae42", 255, 174, 66));
        colors.put("yellow_process", new KmlColour("yellow_process", "Yellow (Process)", "#ffef00", 255, 239, 0));
        colors.put("yellow_ryb", new KmlColour("yellow_ryb", "Yellow (Ryb)", "#fefe33", 254, 254, 51));
        colors.put("zaffre", new KmlColour("zaffre", "Zaffre", "#0014a8", 0, 20, 168));
        colors.put("zinnwaldite_brown", new KmlColour("zinnwaldite_brown", "Zinnwaldite Brown", "#2c1608", 44, 22, 8));
    }
}
