/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.marsik.ham.adif.enums.AdifEnumCode;

public enum AntPath implements AdifEnumCode
{
    GRAYLINE("G"),
    OTHER("O"),
    SHORT("S"),
    LONG("L");

    private final String code;
    private static final Map<String, AntPath> reverse;

    private AntPath(String code) {
        this.code = code;
    }

    @Override
    public String adifCode() {
        return this.code;
    }

    public static AntPath findByCode(String code) {
        return reverse.get(code.toUpperCase());
    }

    static {
        reverse = new HashMap<String, AntPath>();
        Stream.of(AntPath.values()).forEach(v -> reverse.put(v.adifCode(), (AntPath)v));
    }
}

