/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.marsik.ham.adif.enums.AdifEnumCode;

public enum Band implements AdifEnumCode
{
    BAND_2190m("2190m", 0.1357, 0.1378),
    BAND_630m("630m", 0.472, 0.479),
    BAND_560m("560m", 0.501, 0.504),
    BAND_160m("160m", 1.8, 2.0),
    BAND_80m("80m", 3.5, 4.0),
    BAND_60m("60m", 5.06, 5.45),
    BAND_40m("40m", 7.0, 7.3),
    BAND_30m("30m", 10.1, 10.15),
    BAND_20m("20m", 14.0, 14.35),
    BAND_17m("17m", 18.068, 18.168),
    BAND_15m("15m", 21.0, 21.45),
    BAND_12m("12m", 24.89, 24.99),
    BAND_10m("10m", 28.0, 29.7),
    BAND_6m("6m", 50.0, 54.0),
    BAND_4m("4m", 70.0, 71.0),
    BAND_2m("2m", 144.0, 148.0),
    BAND_1_25m("1.25m", 222.0, 225.0),
    BAND_70cm("70cm", 420.0, 450.0),
    BAND_33cm("33cm", 902.0, 928.0),
    BAND_23cm("23cm", 1240.0, 1300.0),
    BAND_13cm("13cm", 2300.0, 2450.0),
    BAND_9cm("9cm", 3300.0, 3500.0),
    BAND_6cm("6cm", 5650.0, 5925.0),
    BAND_3cm("3cm", 10000.0, 10500.0),
    BAND_1_25cm("1.25cm", 24000.0, 24250.0),
    BAND_6mm("6mm", 47000.0, 47200.0),
    BAND_4mm("4mm", 75500.0, 81000.0),
    BAND_2_5mm("2.5mm", 119980.0, 120020.0),
    BAND_2mm("2mm", 142000.0, 149000.0),
    BAND_1mm("1mm", 241000.0, 250000.0);

    private final String code;
    private final double lowerFrequency;
    private final double upperFrequency;
    private static final Map<String, Band> reverse;

    private Band(String code, double lowerFrequency, double upperFrequency) {
        this.code = code;
        this.lowerFrequency = lowerFrequency;
        this.upperFrequency = upperFrequency;
    }

    @Override
    public String adifCode() {
        return this.code;
    }

    public double getLowerFrequency() {
        return this.lowerFrequency;
    }

    public double getUpperFrequency() {
        return this.upperFrequency;
    }

    public static Band findByCode(String code) {
        return reverse.get(code.toLowerCase());
    }

    static {
        reverse = new HashMap<String, Band>();
        Stream.of(Band.values()).forEach(v -> reverse.put(v.adifCode(), (Band)v));
    }
}

