/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.marsik.ham.adif.enums.AdifEnumCode;

public enum Propagation implements AdifEnumCode
{
    AIRCRAFT_SCATTER("AS"),
    AURORA("AUR"),
    AURORA_E("AUE"),
    BACK_SCATTER("BS"),
    ECHOLINK("ECH"),
    EARTH_MOON_EARTH("EME"),
    SPORADIC_E("ES"),
    FIELD_ALIGNED_IRREGULARITIES("FAI"),
    F2_REFLECTION("F2"),
    INTERNET("INTERNET"),
    IONOSCATTER("ION"),
    IRLP("IRL"),
    METEOR_SCATTER("MS"),
    REPEATER("RPT"),
    RAIN_SCATTER("RS"),
    SATELLITE("SAT"),
    TRANSEQUATORIAL("TEP"),
    TROPOSPHERIC_DUCTING("TR");

    private final String code;
    private static final Map<String, Propagation> reverse;

    private Propagation(String code) {
        this.code = code;
    }

    @Override
    public String adifCode() {
        return this.code;
    }

    public static Propagation findByCode(String code) {
        return reverse.get(code.toUpperCase());
    }

    static {
        reverse = new HashMap<String, Propagation>();
        Stream.of(Propagation.values()).forEach(v -> reverse.put(v.adifCode(), (Propagation)v));
    }
}

