/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.marsik.ham.adif.enums.AdifEnumCode;

public enum QslSent implements AdifEnumCode
{
    SENT("Y"),
    DO_NOT_SEND("N"),
    REQUESTED("R"),
    QUEUED("Q"),
    IGNORE("I");

    private final String code;
    private static final Map<String, QslSent> reverse;

    private QslSent(String code) {
        this.code = code;
    }

    @Override
    public String adifCode() {
        return this.code;
    }

    public static QslSent findByCode(String code) {
        return reverse.get(code.toUpperCase());
    }

    static {
        reverse = new HashMap<String, QslSent>();
        Stream.of(QslSent.values()).forEach(v -> reverse.put(v.adifCode(), (QslSent)v));
    }
}

