/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.marsik.ham.adif.enums.AdifEnumCode;

public enum QsoComplete implements AdifEnumCode
{
    YES("Y"),
    NO("N"),
    NOT_HEARD("NIL"),
    UNCERTAIN("?");

    private final String code;
    private static final Map<String, QsoComplete> reverse;

    private QsoComplete(String code) {
        this.code = code;
    }

    @Override
    public String adifCode() {
        return this.code;
    }

    public static QsoComplete findByCode(String code) {
        return reverse.get(code.toUpperCase());
    }

    static {
        reverse = new HashMap<String, QsoComplete>();
        Stream.of(QsoComplete.values()).forEach(v -> reverse.put(v.adifCode(), (QsoComplete)v));
    }
}

