/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.types;

import org.marsik.ham.adif.enums.Continent;
import org.marsik.ham.adif.types.AdifType;

public final class Iota
implements AdifType {
    private final Continent continent;
    private final Integer island;

    @Override
    public String getValue() {
        Object value = "";
        if (this.continent != null && this.island != null) {
            value = String.valueOf(this.continent) + "-" + String.format("%03d", this.island);
        }
        return value;
    }

    public static Iota findByCode(String code) {
        String[] pieces = code.split("-");
        if (pieces.length == 2) {
            return new Iota(Continent.findByCode(pieces[0]), Integer.parseInt(pieces[1]));
        }
        throw new RuntimeException(String.format("Invalid IOTA reference: %s", code));
    }

    public Continent getContinent() {
        return this.continent;
    }

    public Integer getIsland() {
        return this.island;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Iota)) {
            return false;
        }
        Iota other = (Iota)o;
        Integer this$island = this.getIsland();
        Integer other$island = other.getIsland();
        if (this$island == null ? other$island != null : !((Object)this$island).equals(other$island)) {
            return false;
        }
        Continent this$continent = this.getContinent();
        Continent other$continent = other.getContinent();
        return !(this$continent == null ? other$continent != null : !this$continent.equals(other$continent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $island = this.getIsland();
        result = result * 59 + ($island == null ? 43 : ((Object)$island).hashCode());
        Continent $continent = this.getContinent();
        result = result * 59 + ($continent == null ? 43 : $continent.hashCode());
        return result;
    }

    public String toString() {
        return "Iota(continent=" + String.valueOf(this.getContinent()) + ", island=" + this.getIsland() + ")";
    }

    public Iota(Continent continent, Integer island) {
        this.continent = continent;
        this.island = island;
    }
}

