/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.types.AdifType;

public final class Pota
implements AdifType {
    private final String nation;
    private final Integer reference;
    private final String iso31662code;
    public static Pattern POTA_RE = Pattern.compile("([\\dA-Za-z]{1,4})-(\\d{4,5})", 2);
    public static Pattern POTA_ISO_RE = Pattern.compile("([\\dA-Za-z]{1,4})-(\\d{4,5})@([A-Z]{2})", 2);
    public static Pattern POTA_ISO_SUB_RE = Pattern.compile("([\\dA-Z]{1,4})-(\\d{4,5})@([A-Z]{2})-([\\dA-Z]{2,3})", 2);

    @Override
    public String getValue() {
        Object value = "";
        if (this.nation != null && this.reference != null) {
            String refStr = this.reference < 9999 ? String.format("%04d", this.reference) : String.format("%d", this.reference);
            value = this.nation + "-" + refStr;
            if (this.iso31662code != null) {
                value = (String)value + "@" + this.iso31662code;
            }
        }
        return value;
    }

    public static Pota valueOf(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        Matcher potaMatcher = POTA_RE.matcher(s);
        Matcher potaIsoMatcher = POTA_ISO_RE.matcher(s);
        Matcher potaIsoSubMatcher = POTA_ISO_SUB_RE.matcher(s);
        if (potaIsoSubMatcher.matches()) {
            return new Pota(potaIsoSubMatcher.group(1), Integer.parseInt(potaIsoSubMatcher.group(2)), potaIsoSubMatcher.group(3) + "-" + potaIsoSubMatcher.group(4));
        }
        if (potaIsoMatcher.matches()) {
            return new Pota(potaIsoMatcher.group(1), Integer.parseInt(potaIsoMatcher.group(2)), potaIsoMatcher.group(3));
        }
        if (potaMatcher.matches()) {
            return new Pota(potaMatcher.group(1), Integer.parseInt(potaMatcher.group(2)), null);
        }
        throw new IllegalArgumentException(String.format("'%s' is not a POTA reference", s));
    }

    public String getNation() {
        return this.nation;
    }

    public Integer getReference() {
        return this.reference;
    }

    public String getIso31662code() {
        return this.iso31662code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pota)) {
            return false;
        }
        Pota other = (Pota)o;
        Integer this$reference = this.getReference();
        Integer other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$nation = this.getNation();
        String other$nation = other.getNation();
        if (this$nation == null ? other$nation != null : !this$nation.equals(other$nation)) {
            return false;
        }
        String this$iso31662code = this.getIso31662code();
        String other$iso31662code = other.getIso31662code();
        return !(this$iso31662code == null ? other$iso31662code != null : !this$iso31662code.equals(other$iso31662code));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
        String $nation = this.getNation();
        result = result * 59 + ($nation == null ? 43 : $nation.hashCode());
        String $iso31662code = this.getIso31662code();
        result = result * 59 + ($iso31662code == null ? 43 : $iso31662code.hashCode());
        return result;
    }

    public String toString() {
        return "Pota(nation=" + this.getNation() + ", reference=" + this.getReference() + ", iso31662code=" + this.getIso31662code() + ")";
    }

    public Pota(String nation, Integer reference, String iso31662code) {
        this.nation = nation;
        this.reference = reference;
        this.iso31662code = iso31662code;
    }
}

