/*
 * Decompiled with CFR 0.152.
 */
package org.marsik.ham.adif.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.types.AdifType;

public final class Wwff
implements AdifType {
    private final String nation;
    private final Integer reference;
    public static Pattern WWFF_RE = Pattern.compile("([\\dA-Z]+){1,4}FF-(\\d{4})", 2);

    @Override
    public String getValue() {
        Object value = "";
        if (this.nation != null && this.reference != null) {
            value = this.nation + "FF-" + String.format("%04d", this.reference);
        }
        return value;
    }

    public static Wwff valueOf(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        Matcher m = WWFF_RE.matcher(s);
        if (m.matches()) {
            return new Wwff(m.group(1), Integer.parseInt(m.group(2)));
        }
        throw new IllegalArgumentException(String.format("'%s' is not a WWFF reference", s));
    }

    public String getNation() {
        return this.nation;
    }

    public Integer getReference() {
        return this.reference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Wwff)) {
            return false;
        }
        Wwff other = (Wwff)o;
        Integer this$reference = this.getReference();
        Integer other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$nation = this.getNation();
        String other$nation = other.getNation();
        return !(this$nation == null ? other$nation != null : !this$nation.equals(other$nation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : ((Object)$reference).hashCode());
        String $nation = this.getNation();
        result = result * 59 + ($nation == null ? 43 : $nation.hashCode());
        return result;
    }

    public String toString() {
        return "Wwff(nation=" + this.getNation() + ", reference=" + this.getReference() + ")";
    }

    public Wwff(String nation, Integer reference) {
        this.nation = nation;
        this.reference = reference;
    }
}

