/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.text.ParseException;
import java.util.Objects;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marsik.ham.adif.Adif3;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.adif3.Adif3Transformer;
import uk.m0nom.adifproc.adif3.UnsupportedHeaderException;
import uk.m0nom.adifproc.adif3.args.CommandLineArgs;
import uk.m0nom.adifproc.adif3.contacts.Qsos;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.adif3.io.Adif3FileReader;
import uk.m0nom.adifproc.adif3.io.Adif3FileWriter;
import uk.m0nom.adifproc.adif3.print.Adif3PrintFormatter;
import uk.m0nom.adifproc.adif3.transform.TransformResults;
import uk.m0nom.adifproc.contest.ContestResultsCalculator;
import uk.m0nom.adifproc.dxcc.Countries;
import uk.m0nom.adifproc.dxcc.CountriesJsonReader;
import uk.m0nom.adifproc.dxcc.DxccEntities;
import uk.m0nom.adifproc.dxcc.DxccJsonReader;
import uk.m0nom.adifproc.dxcc.JsonDxccEntities;
import uk.m0nom.adifproc.kml.KmlWriter;
import uk.m0nom.adifproc.progress.ProgressFeedbackHandlerCallback;
import uk.m0nom.adifproc.qrz.CachingQrzXmlService;

@SpringBootApplication
public class FileProcessorApplication
implements CommandLineRunner,
ProgressFeedbackHandlerCallback {
    private static final String MARKDOWN_CONTROL_FILE = "adif-printer-132-md.yaml";
    private static final Logger logger = Logger.getLogger(FileProcessorApplication.class.getName());
    private final CommandLineArgs cli;
    private final Adif3Transformer transformer;
    private final Adif3FileReader reader;
    private final Adif3FileWriter writer;
    private final ActivityDatabaseService summits;
    private final Adif3PrintFormatter formatter;
    private final KmlWriter kmlWriter;
    private final CachingQrzXmlService qrzXmlService;
    private Qsos qsos;

    public FileProcessorApplication(Adif3Transformer transformer, Adif3FileReader reader, Adif3FileWriter writer, ActivityDatabaseService summits, Adif3PrintFormatter formatter, KmlWriter kmlWriter, CachingQrzXmlService qrzXmlService) {
        this.transformer = transformer;
        this.reader = reader;
        this.writer = writer;
        this.summits = summits;
        this.formatter = formatter;
        this.kmlWriter = kmlWriter;
        this.qrzXmlService = qrzXmlService;
        this.cli = new CommandLineArgs();
        this.qsos = new Qsos();
    }

    public static void main(String[] args) {
        logger.info("STARTING THE APPLICATION");
        SpringApplication.run(FileProcessorApplication.class, (String[])args);
        logger.info("APPLICATION FINISHED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String ... args) {
        block21: {
            logger.info("EXECUTING : command line runner");
            TransformResults results = new TransformResults();
            TransformControl control = this.cli.parseArgs(args);
            this.qrzXmlService.setCredentials(control.getQrzUsername(), control.getQrzPassword());
            String inPath = control.getPathname();
            Object outPath = control.getOutputPath();
            if (StringUtils.isNotEmpty((CharSequence)outPath)) {
                if (!StringUtils.endsWith((CharSequence)outPath, (CharSequence)File.separator) && !StringUtils.endsWith((CharSequence)outPath, (CharSequence)"/")) {
                    outPath = (String)outPath + File.separator;
                }
            } else {
                outPath = FilenameUtils.getPath((String)inPath);
            }
            String inBasename = FilenameUtils.getBaseName((String)inPath);
            String out = String.format("%s%s-%s.%s", outPath, inBasename, "fta", "adi");
            String kml = String.format("%s%s-%s.%s", outPath, inBasename, "fta", "kml");
            String markdown = String.format("%s%s-%s.%s", outPath, inBasename, "fta", "md");
            logger.info(String.format("Running from: %s", new File(".").getAbsolutePath()));
            try {
                this.summits.loadData();
                JsonDxccEntities jsonDxccEntities = new DxccJsonReader().read();
                DxccEntities dxccEntities = new DxccEntities();
                try {
                    dxccEntities.setup(jsonDxccEntities);
                }
                catch (ParseException p) {
                    logger.severe(p.getMessage());
                }
                control.setDxccEntities(dxccEntities);
                Countries countries = new CountriesJsonReader().read();
                countries.setup();
                control.setCountries(countries);
                if (control.hasQrzCredentials() && !this.qrzXmlService.refreshSessionKey()) {
                    logger.warning("Could not connect to QRZ.COM, disabling lookups and continuing...");
                }
                logger.info(String.format("Reading input file %s with encoding %s", inPath, control.getEncoding()));
                Adif3 log = this.reader.read(inPath, control.getEncoding(), false);
                this.qsos = this.transformer.transform(log, control, results, this, null);
                logger.info(String.format("Writing output file %s with encoding %s", out, control.getEncoding()));
                if (control.getGenerateKml().booleanValue()) {
                    this.kmlWriter.write(control, kml, inBasename, this.summits, this.qsos, results);
                    if (StringUtils.isNotEmpty((CharSequence)results.getError())) {
                        logger.severe(results.getError());
                    }
                }
                log.getHeader().setPreamble(new ContestResultsCalculator(this.summits).calculateResults(log));
                this.writer.write(out, control.getEncoding(), log);
                if (!control.isFormattedOutput()) break block21;
                try (BufferedWriter markdownWriter = null;){
                    File formattedQsoFile = new File(markdown);
                    if (formattedQsoFile.exists() && !formattedQsoFile.delete()) {
                        logger.severe(String.format("Error deleting Markdown file %s, check permissions?", markdown));
                    }
                    if (formattedQsoFile.createNewFile()) {
                        this.formatter.getPrintJobConfig().configure(MARKDOWN_CONTROL_FILE, FileProcessorApplication.class.getClassLoader().getResourceAsStream(MARKDOWN_CONTROL_FILE));
                        logger.info(String.format("Writing Markdown to: %s", markdown));
                        StringBuilder sb = this.formatter.format(this.qsos);
                        markdownWriter = Files.newBufferedWriter(formattedQsoFile.toPath(), Charset.forName(this.formatter.getPrintJobConfig().getOutEncoding()), StandardOpenOption.WRITE);
                        markdownWriter.write(sb.toString());
                    } else {
                        logger.severe(String.format("Error creating Markdown file %s, check permissions?", markdown));
                    }
                }
            }
            catch (NoSuchFileException nfe) {
                logger.severe(String.format("Could not open input file: %s", control.getPathname()));
            }
            catch (UnsupportedHeaderException ushe) {
                logger.severe(String.format("Unknown header for file: %s", inPath));
                logger.severe(ExceptionUtils.getStackTrace((Throwable)ushe));
            }
            catch (IOException e) {
                logger.severe(String.format("Caught exception %s processing file: %s", e.getMessage(), inPath));
                logger.severe(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    @Override
    public void sendProgressUpdate(String sessionId, String message) {
        System.out.println(message);
    }

    static {
        InputStream stream = FileProcessorApplication.class.getClassLoader().getResourceAsStream("logging.properties");
        try {
            LogManager.getLogManager().readConfiguration(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                Objects.requireNonNull(stream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

