/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationSource;

public abstract class ActivityReader {
    private static final Logger logger = Logger.getLogger(ActivityReader.class.getName());
    public ActivityType type;
    public String sourceFile;

    public ActivityReader(ActivityType type, String sourceFile) {
        this.type = type;
        this.sourceFile = sourceFile;
    }

    protected GlobalCoords3D readCoords(CSVRecord record, String latColName, String longColName) {
        GlobalCoords3D location = null;
        String longitudeStr = record.get(latColName);
        String latitudeStr = record.get(longColName);
        if (!StringUtils.isEmpty((CharSequence)longitudeStr) && !StringUtils.isEmpty((CharSequence)latitudeStr)) {
            Double longitude = null;
            try {
                longitude = Double.parseDouble(longitudeStr);
            }
            catch (NumberFormatException e) {
                logger.severe(String.format("Error parsing longitude '%s' from CSV file for activity %s", longitudeStr, this.type.getActivityName()));
            }
            Double latitude = null;
            try {
                latitude = Double.parseDouble(latitudeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (latitude != null && longitude != null && latitude != 0.0 && longitude != 0.0) {
                location = new GlobalCoords3D((double)longitude, (double)latitude, LocationSource.ACTIVITY, LocationAccuracy.LAT_LONG);
            }
        }
        return location;
    }

    public abstract ActivityDatabase read(InputStream var1) throws IOException;

    public ActivityType getType() {
        return this.type;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }
}

