/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.activity.iota;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.activity.iota.IotaSubGroup;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationSource;

public class IotaInfo
extends Activity {
    private int index;
    @JsonProperty(value="refno")
    private String refNo;
    @JsonProperty(value="name")
    private String iotaName;
    @JsonProperty(value="dxcc_num")
    private String dxccNum;
    @JsonProperty(value="latitude_max")
    private double latitudeMax;
    @JsonProperty(value="latitude_min")
    private double latitudeMin;
    @JsonProperty(value="longitude_max")
    private double longitudeMax;
    @JsonProperty(value="longitude_min")
    private double longitudeMin;
    @JsonProperty(value="grp_region")
    private String groupRegion;
    @JsonProperty(value="whitelist")
    private int whitelist;
    @JsonProperty(value="pc_credited")
    private double pcCredited;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="sub_groups")
    private Collection<IotaSubGroup> subGroups;

    public IotaInfo(ActivityType type) {
        super(type);
    }

    public GlobalCoords3D getCoordsFromLatLongMaxMin() {
        double latitudeCentre = this.latitudeMin + (this.latitudeMax - this.latitudeMin) / 2.0;
        double longitudeCentre = this.longitudeMin + (this.longitudeMax - this.longitudeMin) / 2.0;
        return new GlobalCoords3D(latitudeCentre, longitudeCentre, LocationSource.ACTIVITY, LocationAccuracy.LAT_LONG);
    }

    @Override
    public String getUrl() {
        return String.format("https://www.iota-world.org/iotamaps/?grpref=%s", this.refNo);
    }

    public int getIndex() {
        return this.index;
    }

    public String getRefNo() {
        return this.refNo;
    }

    public String getIotaName() {
        return this.iotaName;
    }

    public String getDxccNum() {
        return this.dxccNum;
    }

    public double getLatitudeMax() {
        return this.latitudeMax;
    }

    public double getLatitudeMin() {
        return this.latitudeMin;
    }

    public double getLongitudeMax() {
        return this.longitudeMax;
    }

    public double getLongitudeMin() {
        return this.longitudeMin;
    }

    public String getGroupRegion() {
        return this.groupRegion;
    }

    public int getWhitelist() {
        return this.whitelist;
    }

    public double getPcCredited() {
        return this.pcCredited;
    }

    public String getComment() {
        return this.comment;
    }

    public Collection<IotaSubGroup> getSubGroups() {
        return this.subGroups;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @JsonProperty(value="refno")
    public void setRefNo(String refNo) {
        this.refNo = refNo;
    }

    @JsonProperty(value="name")
    public void setIotaName(String iotaName) {
        this.iotaName = iotaName;
    }

    @JsonProperty(value="dxcc_num")
    public void setDxccNum(String dxccNum) {
        this.dxccNum = dxccNum;
    }

    @JsonProperty(value="latitude_max")
    public void setLatitudeMax(double latitudeMax) {
        this.latitudeMax = latitudeMax;
    }

    @JsonProperty(value="latitude_min")
    public void setLatitudeMin(double latitudeMin) {
        this.latitudeMin = latitudeMin;
    }

    @JsonProperty(value="longitude_max")
    public void setLongitudeMax(double longitudeMax) {
        this.longitudeMax = longitudeMax;
    }

    @JsonProperty(value="longitude_min")
    public void setLongitudeMin(double longitudeMin) {
        this.longitudeMin = longitudeMin;
    }

    @JsonProperty(value="grp_region")
    public void setGroupRegion(String groupRegion) {
        this.groupRegion = groupRegion;
    }

    @JsonProperty(value="whitelist")
    public void setWhitelist(int whitelist) {
        this.whitelist = whitelist;
    }

    @JsonProperty(value="pc_credited")
    public void setPcCredited(double pcCredited) {
        this.pcCredited = pcCredited;
    }

    @JsonProperty(value="comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonProperty(value="sub_groups")
    public void setSubGroups(Collection<IotaSubGroup> subGroups) {
        this.subGroups = subGroups;
    }

    public IotaInfo() {
    }
}

