/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.args;

import java.util.Set;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.commons.lang3.StringUtils;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.antenna.AntennaService;

public class CommandLineArgs {
    public TransformControl parseArgs(String[] args) {
        TransformControl control = new TransformControl();
        ArgumentParser parser = ArgumentParsers.newFor((String)"AdifProcessor").build().defaultHelp(true).description("Process an ADIF file by locating stations and enriching output ADIF file, also optionally produces markdown and Google Earth KML files");
        parser.addArgument(new String[]{"-qu", "--qrz-username"}).required(false).help("Username for the QRZ XML Service");
        parser.addArgument(new String[]{"-qp", "--qrz-password"}).required(false).help("Password for the QRZ XML Service");
        parser.addArgument(new String[]{"-ql", "--qsl-labels"}).required(false).setDefault((Object)Boolean.FALSE).help("Generate QSL Card Labels");
        parser.addArgument(new String[]{"-l", "--location"}).required(false).help("Specify override grid in 4/6/10 characters");
        parser.addArgument(new String[]{"-he", "--hema"}).required(false).help("Specify override HEMA Id for your location");
        parser.addArgument(new String[]{"-w", "--wota"}).required(false).help("Specify override WOTA Id for your location");
        parser.addArgument(new String[]{"-s", "--sota"}).required(false).help("Specify override SOTA Id for your location");
        parser.addArgument(new String[]{"-p", "--pota"}).required(false).help("Specify override POTA Id for your location");
        parser.addArgument(new String[]{"-o", "--output"}).required(false).help("Write output files to this directory");
        parser.addArgument(new String[]{"-e", "--encoding"}).required(false).setDefault((Object)"windows-1251").help("Specify encoding of input ADIF file");
        Set<String> antennaNames = new AntennaService().getAntennaNames();
        parser.addArgument(new String[]{"-a", "--antenna"}).required(false).setDefault((Object)"Vertical").choices(antennaNames).help(String.format("Antenna Type, one of: %s", String.join((CharSequence)", ", antennaNames)));
        parser.addArgument(new String[]{"-k", "--kml"}).required(false).action((ArgumentAction)Arguments.storeTrue()).help("Generate a KML output file for mapping direct to Google Earth");
        parser.addArgument(new String[]{"-kcw", "--kml-contact-width"}).required(false).setDefault((Object)3).help("Specify the width of contact lines");
        parser.addArgument(new String[]{"-kct", "--kml-contact-transparency"}).required(false).setDefault((Object)20).help("Specify the transparency of contact lines between 0% and 100%, 0% being solid");
        parser.addArgument(new String[]{"-kcband", "--kml-contact-colour-band"}).required(false).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)Boolean.FALSE).help("Colour QSOs based on the band used");
        parser.addArgument(new String[]{"-ks2s", "--kml-s2s"}).required(false).action((ArgumentAction)Arguments.storeTrue()).help("Highlight Summit to Summit Contacts in KML file");
        parser.addArgument(new String[]{"-kcs", "--kml-contact-shadow"}).required(false).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)Boolean.TRUE).help("Draw a shadow under the KML contact line");
        parser.addArgument(new String[]{"-ks2sls", "--kml-s2s-line-style"}).required(false).setDefault((Object)"brick_red:50:2").help("Set the colour of contact line for Summit to Summit contacts of the form html_color:transparency:width, default is: brick_red:50:2");
        parser.addArgument(new String[]{"-kstls", "--kml-satellite-track-line-style"}).required(false).setDefault((Object)"brick_red:50:2").help("Set the colour of contact line for Satellite tracks of the form html_color:transparency:width, default is: brick_red:50:2");
        parser.addArgument(new String[]{"-kcls", "--kml-contact-line-style"}).required(false).setDefault((Object)"baby_blue:50:2").help("Set the colour of contact line for contacts of the form html_color:transparency:width, default is: baby_blue:50:2");
        parser.addArgument(new String[]{"-kfi", "--kml-fixed-station"}).required(false).setDefault((Object)"https://maps.google.com/mapfiles/kml/shapes/ranger_station.png").help("URL of the icon to use for fixed/home station locations");
        parser.addArgument(new String[]{"-kpi", "--kml-portable-station"}).required(false).setDefault((Object)"https://maps.google.com/mapfiles/kml/shapes/hiker.png").help("URL of the icon to use for fixed/home station locations");
        parser.addArgument(new String[]{"-kmi", "--kml-mobile-station"}).required(false).setDefault((Object)"https://maps.google.com/mapfiles/kml/shapes/cabs.png").help("URL of the icon to use for fixed/home station locations");
        parser.addArgument(new String[]{"-kmmi", "--kml-maritime-station"}).required(false).setDefault((Object)"https://maps.google.com/mapfiles/kml/shapes/sailing.png").help("URL of the icon to use for maritime mobile station locations");
        parser.addArgument(new String[]{"-kmai", "--kml-aeronautical-station"}).required(false).setDefault((Object)"http://maps.google.com/mapfiles/kml/shapes/airports.png").help("URL of the icon to use for aeronautical mobile station locations");
        parser.addArgument(new String[]{"-kparki", "--kml-park-station"}).required(false).setDefault((Object)"https://maps.google.com/mapfiles/kml/shapes/picnic.png").help("URL of the icon to use for Parks on the Air station locations");
        parser.addArgument(new String[]{"-ksotai", "--kml-sota-station"}).required(false).setDefault((Object)"https://maps.google.com/mapfiles/kml/shapes/mountains.png").help("URL of the icon to use for SOTA station locations");
        parser.addArgument(new String[]{"-khemai", "--kml-hema-station"}).required(false).setDefault((Object)"https://maps.google.com/mapfiles/kml/shapes/hospitals.png").help("URL of the icon to use for SOTA station locations");
        parser.addArgument(new String[]{"-kwotai", "--kml-wota-station"}).required(false).setDefault((Object)"https://maps.google.com/mapfiles/kml/shapes/trail.png").help("URL of the icon to use for SOTA station locations");
        parser.addArgument(new String[]{"-md", "--markdown"}).required(false).action((ArgumentAction)Arguments.storeTrue()).help("Generate Markdown file containing the contacts");
        parser.addArgument(new String[]{"path"}).nargs("*").help("Input ADIF files");
        try {
            Namespace ns = parser.parseArgs(args);
            control.setGenerateKml(ns.getBoolean("kml"));
            control.setLocation(ns.getString("location"));
            control.setPathname(ns.getString("input"));
            control.setEncoding(ns.getString("encoding"));
            control.setQrzUsername(ns.getString("qrz_username"));
            control.setQrzPassword(ns.getString("qrz_password"));
            control.setKmlS2s(ns.getBoolean("kml_s2s"));
            control.setKmlS2sContactLineStyle(ns.getString("kml_s2s_line_style"));
            control.setKmlInternetContactLineStyle(ns.getString("kml_internet_line_style"));
            control.setKmlSatelliteTrackLineStyle(ns.getString("kml_satellite_track_line_style"));
            control.setKmlContactLineStyle(ns.getString("kml_contact_line_style"));
            control.setKmlContactShadow(ns.getBoolean("kml_contact_shadow"));
            control.setIcon("fixed", ns.getString("kml_fixed_station"));
            control.setIcon("mobile", ns.getString("kml_mobile_station"));
            control.setIcon("portable", ns.getString("kml_portable_station"));
            control.setIcon("maritime", ns.getString("kml_maritime_station"));
            control.setIcon("aeroplane", ns.getString("kml_aeronautical_station"));
            for (ActivityType activity : ActivityType.values()) {
                control.setIcon(activity.getActivityName(), String.format("kml_%s_station", activity.getActivityName().toLowerCase()));
                if (ns.getString(activity.getActivityName()) == null) continue;
                control.setActivityRef(activity, ns.getString(activity.getActivityName()).toLowerCase());
            }
            control.setKmlContactTransparency(100 - ns.getInt("kml_contact_transparency"));
            control.setKmlContactWidth(ns.getInt("kml_contact_width"));
            control.setKmlContactColourByBand(ns.getBoolean("kml_contact_colour_band"));
            control.setFormattedOutput(ns.getBoolean("markdown"));
            control.setQslLabels(ns.getBoolean("qsl_labels"));
            control.setQslLabelsInitialPosition(ns.getInt("qsl_labels_initial_position"));
            control.setOutputPath(ns.getString("output"));
            control.setPathname(ns.getString("path").substring(1, ns.getString("path").length() - 1));
            if (StringUtils.isNotEmpty((CharSequence)ns.getString("antenna"))) {
                control.setAntenna(new AntennaService().getAntenna(ns.getString("antenna")));
            }
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        return control;
    }
}

