/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.contacts;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.marsik.ham.adif.Adif3;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.contacts.Station;

public class Qsos {
    private static final Logger logger = Logger.getLogger(Qsos.class.getName());
    private List<Qso> qsos = new ArrayList<Qso>();
    private Adif3 log;

    public Qsos() {
    }

    public Qsos(Adif3 log) {
        this();
        this.log = log;
    }

    public void addQso(Qso qso) {
        this.qsos.add(qso);
        String fromCallsign = qso.getRecord().getStationCallsign();
        if (fromCallsign == null) {
            if (qso.getRecord().getOperator() != null) {
                fromCallsign = qso.getRecord().getOperator();
                qso.getRecord().setStationCallsign(fromCallsign);
            } else {
                logger.severe(String.format("Could not determine station callsign for ADIF record at %s with %s", qso.getRecord().getTimeOn(), qso.getRecord().getCall()));
            }
        }
        Station fromStation = new Station(fromCallsign, qso);
        qso.setFrom(fromStation);
        String toCallsign = qso.getRecord().getCall();
        Station toStation = new Station(toCallsign, qso);
        qso.setTo(toStation);
    }

    public List<Qso> getQsos() {
        return this.qsos;
    }

    public Adif3 getLog() {
        return this.log;
    }

    public void setQsos(List<Qso> qsos) {
        this.qsos = qsos;
    }

    public void setLog(Adif3 log) {
        this.log = log;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Qsos)) {
            return false;
        }
        Qsos other = (Qsos)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Qso> this$qsos = this.getQsos();
        List<Qso> other$qsos = other.getQsos();
        if (this$qsos == null ? other$qsos != null : !((Object)this$qsos).equals(other$qsos)) {
            return false;
        }
        Adif3 this$log = this.getLog();
        Adif3 other$log = other.getLog();
        return !(this$log == null ? other$log != null : !((Object)this$log).equals(other$log));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Qsos;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Qso> $qsos = this.getQsos();
        result = result * 59 + ($qsos == null ? 43 : ((Object)$qsos).hashCode());
        Adif3 $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : ((Object)$log).hashCode());
        return result;
    }

    public String toString() {
        return "Qsos(qsos=" + String.valueOf(this.getQsos()) + ", log=" + String.valueOf(this.getLog()) + ")";
    }
}

