/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.antenna.Antenna;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.dxcc.DxccEntity;
import uk.m0nom.adifproc.qrz.QrzCallsign;

public class Station {
    private String callsign;
    private QrzCallsign qrzInfo;
    private DxccEntity dxccEntity;
    private List<Qso> qsos;
    private Set<ActivityType> doingActivity = new HashSet<ActivityType>();
    private Collection<Activity> activities = new ArrayList<Activity>();
    private String grid;
    private GlobalCoords3D coordinates;
    private Antenna antenna;

    public Station() {
        this.qsos = new ArrayList<Qso>();
    }

    public Station(String callsign, Qso initialQso) {
        this();
        this.callsign = StringUtils.trim((String)callsign).toUpperCase();
        this.addQso(initialQso);
    }

    public void addQso(Qso qso) {
        this.qsos.add(qso);
    }

    public void addActivity(Activity activity) {
        if (activity != null) {
            this.activities.add(activity);
            this.doingActivity.add(activity.getType());
        }
    }

    public boolean isDoing(ActivityType type) {
        return this.doingActivity.contains((Object)type);
    }

    public Collection<Activity> getActivity(ActivityType type) {
        return this.activities.stream().filter(activity -> activity.getType() == type).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean hasActivity() {
        return this.activities.size() > 0;
    }

    public boolean doingSameActivityAs(Station other) {
        return this.activities.stream().anyMatch(a -> other.isDoing(a.getType()));
    }

    public boolean equals(Object other) {
        if (other instanceof Station) {
            return ((Station)other).getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String getKey() {
        return String.format("%s %s %s", new Object[]{this.getCallsign(), this.getCoordinates(), this.getGrid()});
    }

    public String getCallsign() {
        return this.callsign;
    }

    public QrzCallsign getQrzInfo() {
        return this.qrzInfo;
    }

    public DxccEntity getDxccEntity() {
        return this.dxccEntity;
    }

    public List<Qso> getQsos() {
        return this.qsos;
    }

    public Set<ActivityType> getDoingActivity() {
        return this.doingActivity;
    }

    public Collection<Activity> getActivities() {
        return this.activities;
    }

    public String getGrid() {
        return this.grid;
    }

    public GlobalCoords3D getCoordinates() {
        return this.coordinates;
    }

    public Antenna getAntenna() {
        return this.antenna;
    }

    public void setCallsign(String callsign) {
        this.callsign = callsign;
    }

    public void setQrzInfo(QrzCallsign qrzInfo) {
        this.qrzInfo = qrzInfo;
    }

    public void setDxccEntity(DxccEntity dxccEntity) {
        this.dxccEntity = dxccEntity;
    }

    public void setQsos(List<Qso> qsos) {
        this.qsos = qsos;
    }

    public void setDoingActivity(Set<ActivityType> doingActivity) {
        this.doingActivity = doingActivity;
    }

    public void setActivities(Collection<Activity> activities) {
        this.activities = activities;
    }

    public void setGrid(String grid) {
        this.grid = grid;
    }

    public void setCoordinates(GlobalCoords3D coordinates) {
        this.coordinates = coordinates;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    public String toString() {
        return "Station(callsign=" + this.getCallsign() + ", qrzInfo=" + String.valueOf(this.getQrzInfo()) + ", dxccEntity=" + String.valueOf(this.getDxccEntity()) + ", qsos=" + String.valueOf(this.getQsos()) + ", doingActivity=" + String.valueOf(this.getDoingActivity()) + ", activities=" + String.valueOf(this.getActivities()) + ", grid=" + this.getGrid() + ", coordinates=" + String.valueOf((Object)this.getCoordinates()) + ", antenna=" + String.valueOf(this.getAntenna()) + ")";
    }
}

