/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.label;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.apache.maven.shared.utils.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.QslSent;
import org.marsik.ham.adif.enums.QslVia;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.adif3.contacts.AlphabeticQsoComparator;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.contacts.Qsos;
import uk.m0nom.adifproc.adif3.label.Adif3LabelFormatterResult;
import uk.m0nom.adifproc.adif3.label.Page;

@Service
public class Adif3LabelFormatter {
    private static final int PAGE_WIDTH = 97;
    private static final int PAGE_LENGTH = 75;
    private static final int LABEL_WIDTH = 27;
    private static final int[] Y_POS = new int[]{2, 11, 21, 30, 39, 49, 58, 67};
    private static final int[] X_POS = new int[]{0, 34, 69};

    public Adif3LabelFormatterResult format(Qsos qsos, String dontQslCallsigns, Integer qslLabelStartPosition) {
        Adif3LabelFormatterResult result = new Adif3LabelFormatterResult();
        StringBuilder sb = new StringBuilder();
        Collection<String> excludeCallsigns = this.processDontQslCallsignString(dontQslCallsigns);
        ArrayList<Qso> qsosToQsl = new ArrayList<Qso>(qsos.getQsos().size());
        for (Qso qso2 : qsos.getQsos()) {
            String callsign = qso2.getTo().getCallsign().toUpperCase();
            if (!qso2.isQslViaBureau() || excludeCallsigns.contains(callsign)) continue;
            qsosToQsl.add(qso2);
        }
        qsosToQsl.sort(new AlphabeticQsoComparator());
        List<Page> pages = this.formatQsos(qsosToQsl, qslLabelStartPosition);
        for (Page page : pages) {
            Collection<String> contents = page.dumpPage();
            for (String content : contents) {
                sb.append(content).append("\n");
            }
        }
        result.setCallsigns(qsosToQsl.stream().map(qso -> qso.getTo().getCallsign()).distinct().sorted().collect(Collectors.toList()));
        result.setLabels(sb.toString());
        return result;
    }

    private Collection<String> processDontQslCallsignString(String dontQslCallsigns) {
        List<String> dontQslCallsignList = new ArrayList<String>();
        String strippedList = dontQslCallsigns.replaceAll(",", " ").replaceAll("\\s+", " ").toUpperCase();
        if (!strippedList.isEmpty()) {
            String[] splitList = strippedList.split(" ");
            dontQslCallsignList = Arrays.asList(splitList);
        }
        return dontQslCallsignList;
    }

    public List<Page> formatQsos(List<Qso> qsos, Integer startPosition) {
        ArrayList<Page> pages = new ArrayList<Page>(1);
        int qsoIndex = 0;
        int qsoCount = qsos.size();
        int pageIndex = 1;
        int initialX = 0;
        int initialY = 0;
        if (startPosition != null) {
            initialX = (startPosition - 1) % 3;
            initialY = (startPosition - 1) / 3;
        }
        while (qsoIndex < qsoCount) {
            Page page = new Page(pageIndex, 97, 75);
            pages.add(page);
            for (int y = initialY; y < Y_POS.length; ++y) {
                for (int x = initialX; x < X_POS.length; ++x) {
                    Qso qso = qsos.get(qsoIndex++);
                    this.impressQso(page, qso, X_POS[x], Y_POS[y]);
                    qso.getRecord().setQslSentVia(QslVia.BUREAU);
                    qso.getRecord().setQslSent(QslSent.SENT);
                    qso.getRecord().setQslSDate(LocalDate.now());
                    if (qsoIndex != qsoCount) continue;
                    return pages;
                }
                initialY = 0;
                initialX = 0;
            }
            ++pageIndex;
        }
        return pages;
    }

    private void impressQso(Page page, Qso qso, int offsetX, int offsetY) {
        Adif3Record rec = qso.getRecord();
        page.writeString(String.format(rec.getCall(), new Object[0]), offsetX, offsetY);
        if (Strings.isNotBlank((String)rec.getQslVia())) {
            page.writeString(String.format("via %s", StringUtils.abbreviate((String)qso.getRecord().getQslVia(), (int)22)), offsetX, offsetY + 1);
        }
        page.writeString("Date     Time Band RST Mode", offsetX, offsetY + 2);
        DateTimeFormatter dateS = DateTimeFormatter.ofPattern("yyyyMMdd");
        String date = dateS.format(qso.getRecord().getQsoDate());
        DateTimeFormatter timeS = DateTimeFormatter.ofPattern("hhmm");
        String time = timeS.format(qso.getRecord().getTimeOn());
        String band = rec.getBand() == null ? "    " : StringUtils.rightPad((String)rec.getBand().adifCode(), (int)4);
        String rst = StringUtils.isEmpty((String)rec.getRstSent()) ? "   " : StringUtils.leftPad((String)rec.getRstSent(), (int)3);
        String mode = rec.getMode() == null ? "    " : StringUtils.rightPad((String)rec.getMode().adifCode(), (int)4);
        page.writeString(String.format("%s %s %s %s %s", date, time, band, rst, mode), offsetX, offsetY + 3);
        String activity = this.getMaybeMyActivityRef(qso);
        page.writeString(activity, offsetX, offsetY + 4);
        if (qso.getRecord().getQslMsg() != null) {
            String qslMsg = StringUtils.left((String)qso.getRecord().getQslMsg(), (int)27);
            page.writeString(qslMsg, offsetX, offsetY + 5);
        }
        if (qso.getRecord().getQslRDate() != null) {
            page.writeString("THX QSL", offsetX + 21, offsetY + 6);
        } else {
            page.writeString("PSE QSL", offsetX + 21, offsetY + 6);
        }
    }

    private String getMaybeMyActivityRef(Qso qso) {
        String activity = "";
        if (qso.getRecord().getMySotaRef() != null) {
            activity = String.format("From SOTA: %s", qso.getRecord().getMySotaRef().getValue());
        } else if (qso.getRecord().getMyWwffRef() != null) {
            activity = String.format("From WWFF: %s", qso.getRecord().getMyWwffRef().getValue());
        } else if (qso.getFrom().hasActivity()) {
            Activity act = qso.getFrom().getActivities().iterator().next();
            activity = String.format("From %s: %s", act.getType().getActivityName(), act.getRef());
        }
        return StringUtils.abbreviate((String)activity, (int)27);
    }
}

