/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.label;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class Page {
    private int number;
    private char[][] content;
    private int width;
    private int height;

    public Page(int number, int width, int height) {
        this.setNumber(number);
        this.setWidth(width);
        this.setHeight(height);
        this.content = new char[height][width];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.content[y][x] = 32;
            }
        }
    }

    public void writeChar(char c, int x, int y) {
        this.content[y][x] = c;
    }

    public void writeString(String str, int x, int y) {
        for (int i = 0; i < str.length() && x + i < this.width; ++i) {
            this.writeChar(str.charAt(i), x + i, y);
        }
    }

    public Collection<String> dumpPage() {
        ArrayList<String> out = new ArrayList<String>(this.height);
        for (int y = 0; y < this.height; ++y) {
            StringBuilder sb = new StringBuilder();
            for (int x = 0; x < this.width; ++x) {
                sb.append(this.content[y][x]);
            }
            out.add(sb.toString());
        }
        return out;
    }

    public static void dump(Collection<Page> pages) {
        List strs = pages.stream().map(Page::dumpPage).collect(Collectors.toList());
        for (Collection stringCollection : strs) {
            Iterator i2 = stringCollection.iterator();
            while (i2.hasNext()) {
                System.out.println((String)i2.next());
            }
        }
    }

    public int getNumber() {
        return this.number;
    }

    public char[][] getContent() {
        return this.content;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setContent(char[][] content) {
        this.content = content;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumber() != other.getNumber()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getContent(), (Object[])other.getContent());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumber();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + Arrays.deepHashCode((Object[])this.getContent());
        return result;
    }

    public String toString() {
        return "Page(number=" + this.getNumber() + ", content=" + Arrays.deepToString((Object[])this.getContent()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }
}

