/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform;

import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.transform.CallsignUtils;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.maidenheadlocator.MaidenheadLocatorConversion;
import uk.m0nom.adifproc.qrz.QrzCallsign;
import uk.m0nom.adifproc.qrz.QrzService;

public class AdifQrzEnricher {
    private static final Logger logger = Logger.getLogger(AdifQrzEnricher.class.getName());
    private final QrzService qrzService;

    public AdifQrzEnricher(QrzService qrzService) {
        this.qrzService = qrzService;
    }

    public void enrichAdifForMe(Adif3Record rec, QrzCallsign qrzData) {
        if (qrzData == null) {
            return;
        }
        if (rec.getMyName() == null) {
            rec.setMyName(this.getNameFromQrzData(qrzData));
        }
    }

    public void enrichAdifForThem(Adif3Record rec, QrzCallsign qrzData) {
        if (qrzData == null) {
            return;
        }
        if (rec.getName() == null) {
            rec.setName(this.getNameFromQrzData(qrzData));
        }
        if (rec.getQth() == null) {
            StringBuilder addr = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)qrzData.getAddr1())) {
                addr.append(qrzData.getAddr1());
                addr.append(", ");
            }
            if (StringUtils.isNotEmpty((CharSequence)qrzData.getAddr2())) {
                addr.append(qrzData.getAddr2());
            }
            rec.setQth(addr.toString());
        }
    }

    private String getNameFromQrzData(QrzCallsign qrzData) {
        Object name = "";
        if (StringUtils.isNotEmpty((CharSequence)qrzData.getFname())) {
            name = qrzData.getFname();
        }
        if (StringUtils.isNotEmpty((CharSequence)qrzData.getName())) {
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                name = (String)name + " ";
            }
            name = (String)name + qrzData.getName();
        }
        return name;
    }

    public void lookupLocationFromQrz(Qso qso) {
        String fixedCallsign;
        QrzCallsign callsignData = qso.getTo().getQrzInfo();
        Adif3Record rec = qso.getRecord();
        String callsign = rec.getCall();
        if (callsignData == null) {
            callsignData = this.qrzService.getCallsignData(callsign);
            qso.getTo().setQrzInfo(callsignData);
        }
        if (callsignData != null) {
            this.updateQsoFromQrzLocation(qso, callsignData);
            logger.info(String.format("Retrieved %s from QRZ.COM", callsign));
        } else if (CallsignUtils.isPortable(callsign) && (callsignData = this.qrzService.getCallsignData(fixedCallsign = callsign.substring(0, StringUtils.lastIndexOf((CharSequence)callsign, (CharSequence)"/")))) != null) {
            logger.info(String.format("Retrieved %s from QRZ.COM using FIXED station callsign %s", callsign, fixedCallsign));
            qso.getTo().setQrzInfo(callsignData);
            this.updateQsoFromQrzLocation(qso, callsignData);
        }
    }

    private void updateQsoFromQrzLocation(Qso qso, QrzCallsign callsignData) {
        Adif3Record rec;
        if (callsignData != null && (rec = qso.getRecord()).getCoordinates() == null) {
            boolean geocodeBasedGeoLocation = StringUtils.equalsIgnoreCase((CharSequence)"geocode", (CharSequence)callsignData.getGeoloc());
            boolean gridBasedGeoLocation = StringUtils.equalsIgnoreCase((CharSequence)"grid", (CharSequence)callsignData.getGeoloc());
            boolean userGeoLocation = StringUtils.equalsIgnoreCase((CharSequence)"user", (CharSequence)callsignData.getGeoloc());
            String qrzGridSquare = callsignData.getGrid();
            boolean isAValidGridBasedLocation = (gridBasedGeoLocation || userGeoLocation) && MaidenheadLocatorConversion.isValid(qrzGridSquare);
            GlobalCoords3D coord = null;
            if (callsignData.getLat() != null && callsignData.getLon() != null && isAValidGridBasedLocation) {
                coord = new GlobalCoords3D((double)callsignData.getLat(), (double)callsignData.getLon(), LocationSource.QRZ, LocationAccuracy.LAT_LONG);
                if (geocodeBasedGeoLocation) {
                    coord.setLocationInfo(LocationSource.QRZ, LocationAccuracy.GEOLOCATION_GOOD);
                } else if (gridBasedGeoLocation) {
                    coord.setLocationInfo(LocationSource.QRZ, LocationAccuracy.MHL6);
                }
            } else if (rec.getGridsquare() == null && isAValidGridBasedLocation) {
                coord = MaidenheadLocatorConversion.locatorToCoords(LocationSource.QRZ, qrzGridSquare);
            }
            if (coord != null) {
                rec.setCoordinates(coord);
                qso.getTo().setCoordinates(coord);
            }
        }
    }
}

