/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import uk.m0nom.adifproc.satellite.SatelliteActivity;

public class TransformResults {
    private String adiFile;
    private String kmlFile;
    private String formattedQsoFile;
    private String qslLabelsFile;
    private String error = "";
    private Collection<String> contactsWithoutLocation;
    private Collection<String> contactsWithDubiousLocation;
    private Collection<String> qslContacts;
    private Set<String> unknownSatellites;
    private Set<String> unknownSatellitePasses;
    private SatelliteActivity satelliteActivity;
    private Collection<String> warnings;

    public TransformResults() {
        this.contactsWithoutLocation = new ArrayList<String>();
        this.contactsWithDubiousLocation = new ArrayList<String>();
        this.unknownSatellites = new HashSet<String>();
        this.unknownSatellitePasses = new HashSet<String>();
        this.satelliteActivity = new SatelliteActivity();
        this.warnings = new ArrayList<String>();
    }

    public TransformResults(String errorMessage) {
        this.error = errorMessage;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean hasErrors() {
        return StringUtils.isNotBlank((CharSequence)this.error);
    }

    public void addContactWithoutLocation(String callsign) {
        this.contactsWithoutLocation.add(callsign);
    }

    public void addContactWithDubiousLocation(String callsign) {
        this.contactsWithDubiousLocation.add(callsign);
    }

    public void addUnknownSatellite(String satellite) {
        this.unknownSatellites.add(satellite);
    }

    public void addUnknownSatellitePass(String satellitePass) {
        this.unknownSatellitePasses.add(satellitePass);
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public String getAdiFile() {
        return this.adiFile;
    }

    public String getKmlFile() {
        return this.kmlFile;
    }

    public String getFormattedQsoFile() {
        return this.formattedQsoFile;
    }

    public String getQslLabelsFile() {
        return this.qslLabelsFile;
    }

    public String getError() {
        return this.error;
    }

    public Collection<String> getContactsWithoutLocation() {
        return this.contactsWithoutLocation;
    }

    public Collection<String> getContactsWithDubiousLocation() {
        return this.contactsWithDubiousLocation;
    }

    public Collection<String> getQslContacts() {
        return this.qslContacts;
    }

    public Set<String> getUnknownSatellites() {
        return this.unknownSatellites;
    }

    public Set<String> getUnknownSatellitePasses() {
        return this.unknownSatellitePasses;
    }

    public SatelliteActivity getSatelliteActivity() {
        return this.satelliteActivity;
    }

    public Collection<String> getWarnings() {
        return this.warnings;
    }

    public void setAdiFile(String adiFile) {
        this.adiFile = adiFile;
    }

    public void setKmlFile(String kmlFile) {
        this.kmlFile = kmlFile;
    }

    public void setFormattedQsoFile(String formattedQsoFile) {
        this.formattedQsoFile = formattedQsoFile;
    }

    public void setQslLabelsFile(String qslLabelsFile) {
        this.qslLabelsFile = qslLabelsFile;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setContactsWithoutLocation(Collection<String> contactsWithoutLocation) {
        this.contactsWithoutLocation = contactsWithoutLocation;
    }

    public void setContactsWithDubiousLocation(Collection<String> contactsWithDubiousLocation) {
        this.contactsWithDubiousLocation = contactsWithDubiousLocation;
    }

    public void setQslContacts(Collection<String> qslContacts) {
        this.qslContacts = qslContacts;
    }

    public void setUnknownSatellites(Set<String> unknownSatellites) {
        this.unknownSatellites = unknownSatellites;
    }

    public void setUnknownSatellitePasses(Set<String> unknownSatellitePasses) {
        this.unknownSatellitePasses = unknownSatellitePasses;
    }

    public void setSatelliteActivity(SatelliteActivity satelliteActivity) {
        this.satelliteActivity = satelliteActivity;
    }

    public void setWarnings(Collection<String> warnings) {
        this.warnings = warnings;
    }
}

