/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform.comment;

import com.amihaiemil.eoyaml.Scalar;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import java.time.LocalDate;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.AntPath;
import org.marsik.ham.adif.enums.Band;
import org.marsik.ham.adif.enums.Propagation;
import org.marsik.ham.adif.enums.QslSent;
import org.marsik.ham.adif.enums.QslVia;
import org.marsik.ham.adif.types.Iota;
import org.marsik.ham.adif.types.Sota;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.activity.ActivityType;
import uk.m0nom.adifproc.adif3.config.TransformerConfig;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.transform.CallsignUtils;
import uk.m0nom.adifproc.adif3.transform.TransformResults;
import uk.m0nom.adifproc.adif3.transform.comment.CommentTransformer;
import uk.m0nom.adifproc.adif3.transform.comment.parsers.FieldParseUtils;
import uk.m0nom.adifproc.adif3.transform.tokenizer.ColonTokenizer;
import uk.m0nom.adifproc.adif3.transform.tokenizer.CommentTokenizer;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationParserResult;
import uk.m0nom.adifproc.coords.LocationParsingService;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.location.ToLocationDeterminer;
import uk.m0nom.adifproc.maidenheadlocator.MaidenheadLocatorConversion;
import uk.m0nom.adifproc.satellite.ApSatelliteService;

@Service
public class ClassicCommentTransformer
implements CommentTransformer {
    private static final Logger logger = Logger.getLogger(ClassicCommentTransformer.class.getName());
    private final CommentTokenizer tokenizer = new ColonTokenizer();
    private final YamlMapping fieldMap;
    private final ActivityDatabaseService activities;
    private final ToLocationDeterminer toLocationDeterminer;
    private final LocationParsingService locationParsingService;
    private final ApSatelliteService apSatelliteService;

    public ClassicCommentTransformer(TransformerConfig config, ActivityDatabaseService activities, ToLocationDeterminer toLocationDeterminer, ApSatelliteService apSatelliteService) {
        this.fieldMap = config.getConfig().asMapping();
        this.activities = activities;
        this.toLocationDeterminer = toLocationDeterminer;
        this.locationParsingService = new LocationParsingService();
        this.apSatelliteService = apSatelliteService;
    }

    @Override
    public void transformComment(Qso qso, String comment, Map<String, String> unmapped, TransformResults results) {
        if (StringUtils.isBlank((CharSequence)comment)) {
            return;
        }
        Adif3Record rec = qso.getRecord();
        Map<String, String> tokens = this.tokenizer.tokenize(comment);
        if (StringUtils.isNotEmpty((CharSequence)comment) && tokens.size() == 0) {
            unmapped.put(comment, "");
            return;
        }
        Double latitude = null;
        Double longitude = null;
        GlobalCoords3D coords = null;
        String callsignWithInvalidActivity = null;
        for (String key : tokens.keySet()) {
            String value = tokens.get(key).trim();
            YamlNode keyNode = this.fieldMap.value(key);
            if (keyNode != null) {
                String adifField;
                Scalar adifFieldYn = keyNode.asScalar();
                block46 : switch (adifField = adifFieldYn.asScalar().value()) {
                    case "Name": {
                        rec.setName(value);
                        break;
                    }
                    case "Qth": {
                        rec.setQth(value);
                        break;
                    }
                    case "Rig": {
                        rec.setRig(value);
                        break;
                    }
                    case "Age": {
                        rec.setAge(Integer.parseInt(value));
                        break;
                    }
                    case "Iota": {
                        try {
                            Iota iota = Iota.findByCode(value);
                            rec.setIota(iota);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            logger.severe(String.format("Couldn't parse IOTA field %s for call %s at %s, please check, leaving it unmapped", value, rec.getCall(), rec.getTimeOn()));
                            unmapped.put(key, value);
                        }
                        break;
                    }
                    case "GridSquare": {
                        if (!MaidenheadLocatorConversion.isADubiousGridSquare(value)) {
                            switch (value.length()) {
                                case 4: 
                                case 6: 
                                case 8: 
                                case 10: {
                                    if (value.length() > 6) {
                                        rec.setGridsquare(value.substring(0, 6));
                                    } else {
                                        rec.setGridsquare(value);
                                    }
                                    GlobalCoords3D coordinates = MaidenheadLocatorConversion.locatorToCoords(LocationSource.OVERRIDE, value);
                                    rec.setCoordinates(coordinates);
                                    qso.getTo().setCoordinates(coordinates);
                                    break block46;
                                }
                            }
                            logger.severe(String.format("Gridsquare %s isn't valid", value));
                            break;
                        }
                        logger.severe(String.format("Gridsquare %s isn't valid", value));
                        break;
                    }
                    case "RxPwr": {
                        try {
                            rec.setRxPwr(FieldParseUtils.parsePwr(value));
                        }
                        catch (NumberFormatException nfe) {
                            logger.warning(String.format("Couldn't parse RxPwr field: %s, leaving it unmapped", value));
                            unmapped.put(key, value);
                        }
                        break;
                    }
                    case "BandRx": {
                        try {
                            Band band = Band.findByCode(value);
                            rec.setBandRx(band);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            logger.severe(String.format("Couldn't parse BandRx field %s for call %s at %s, please check, leaving it unmapped", value, rec.getCall(), rec.getTimeOn()));
                            unmapped.put(key, value);
                        }
                        break;
                    }
                    case "FrequencyRx": {
                        try {
                            rec.setFreqRx(Double.parseDouble(value));
                        }
                        catch (NumberFormatException nfe) {
                            logger.severe(String.format("Couldn't parse FrequencyRx field %s for call %s at %s, please check, leaving it unmapped", value, rec.getCall(), rec.getTimeOn()));
                            unmapped.put(key, value);
                        }
                        break;
                    }
                    case "TxPwr": {
                        try {
                            rec.setTxPwr(FieldParseUtils.parsePwr(value));
                        }
                        catch (NumberFormatException nfe) {
                            logger.warning(String.format("Couldn't parse TxPwr field: %s, leaving it unmapped", value));
                            unmapped.put(key, value);
                        }
                        break;
                    }
                    case "SotaRef": {
                        String sotaRef = StringUtils.split((String)value, (char)' ')[0];
                        try {
                            Sota sota = Sota.valueOf(sotaRef.toUpperCase());
                            rec.setSotaRef(sota);
                            callsignWithInvalidActivity = this.toLocationDeterminer.setTheirLocationFromSotaId(qso, sotaRef);
                            qso.getTo().addActivity(this.activities.getDatabase(ActivityType.SOTA).get(sotaRef));
                        }
                        catch (IllegalArgumentException iae) {
                            logger.severe(String.format("Couldn't identify %s as a SOTA reference in field %s, leaving it unmapped", sotaRef, value));
                            unmapped.put(key, value);
                        }
                        unmapped.put(key, value);
                        break;
                    }
                    case "WotaRef": {
                        String wotaId = StringUtils.split((String)value, (char)' ')[0];
                        callsignWithInvalidActivity = this.toLocationDeterminer.setTheirLocationFromWotaId(qso, wotaId.toUpperCase());
                        qso.getTo().addActivity(this.activities.getDatabase(ActivityType.WOTA).get(wotaId));
                        break;
                    }
                    case "GmaRef": {
                        String gmaId = StringUtils.split((String)value, (char)' ')[0];
                        callsignWithInvalidActivity = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.GMA, gmaId.toUpperCase());
                        qso.getTo().addActivity(this.activities.getDatabase(ActivityType.GMA).get(gmaId));
                        break;
                    }
                    case "HemaRef": {
                        String hemaId = StringUtils.split((String)value, (char)' ')[0];
                        callsignWithInvalidActivity = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.HEMA, hemaId.toUpperCase());
                        qso.getTo().addActivity(this.activities.getDatabase(ActivityType.HEMA).get(hemaId));
                        break;
                    }
                    case "PotaRef": {
                        String potaId = StringUtils.split((String)value, (char)' ')[0];
                        callsignWithInvalidActivity = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.POTA, potaId.toUpperCase());
                        qso.getTo().addActivity(this.activities.getDatabase(ActivityType.POTA).get(potaId));
                        break;
                    }
                    case "CotaRef": {
                        String cotaId = StringUtils.split((String)value, (char)' ')[0];
                        callsignWithInvalidActivity = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.COTA, cotaId.toUpperCase());
                        qso.getTo().addActivity(this.activities.getDatabase(ActivityType.COTA).get(cotaId));
                        break;
                    }
                    case "WwffRef": {
                        String wwffId = StringUtils.split((String)value, (char)' ')[0];
                        callsignWithInvalidActivity = this.toLocationDeterminer.setTheirLocationFromActivity(qso, ActivityType.WWFF, wwffId.toUpperCase());
                        qso.getTo().addActivity(this.activities.getDatabase(ActivityType.WWFF).get(wwffId));
                        break;
                    }
                    case "SerialTx": {
                        try {
                            rec.setStx(Integer.parseInt(value));
                        }
                        catch (NumberFormatException nfe) {
                            rec.setStxString(value);
                        }
                        break;
                    }
                    case "SerialRx": {
                        try {
                            rec.setSrx(Integer.parseInt(value));
                        }
                        catch (NumberFormatException nfe) {
                            rec.setSrxString(value);
                        }
                        break;
                    }
                    case "Fists": {
                        rec.setFists(value);
                        break;
                    }
                    case "Skcc": {
                        rec.setSkcc(value);
                        break;
                    }
                    case "Qsl": {
                        rec.setQslSDate(LocalDate.now());
                        rec.setQslSent(QslSent.SENT);
                        switch (value) {
                            case "D": {
                                rec.setQslSentVia(QslVia.DIRECT);
                                break block46;
                            }
                            case "B": {
                                rec.setQslSentVia(QslVia.BUREAU);
                            }
                        }
                        break;
                    }
                    case "Coordinates": {
                        LocationParserResult parserResult = this.locationParsingService.parseStringForCoordinates(LocationSource.OVERRIDE, value);
                        if (parserResult == null) break;
                        coords = parserResult.getCoords();
                        break;
                    }
                    case "Latitude": {
                        try {
                            latitude = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            logger.severe(String.format("Callsign: %s at %s has invalid latitude: %s", rec.getCall(), rec.getTimeOn().toString(), value));
                        }
                        break;
                    }
                    case "Longitude": {
                        try {
                            longitude = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            logger.severe(String.format("Callsign: %s at %s has invalid longitude: %s", rec.getCall(), rec.getTimeOn().toString(), value));
                        }
                        break;
                    }
                    case "AntPath": {
                        AntPath path = AntPath.SHORT;
                        try {
                            path = AntPath.findByCode(value.toUpperCase());
                        }
                        catch (Exception e) {
                            logger.severe(String.format("AntPath: %s isn't one of 'G': GRAYLINE, 'S': SHORT, 'L': LONG, 'O': OTHER", value));
                        }
                        rec.setAntPath(path);
                        break;
                    }
                    case "Propagation": {
                        Propagation mode = Propagation.IONOSCATTER;
                        try {
                            mode = Propagation.findByCode(value.toUpperCase());
                        }
                        catch (Exception e) {
                            logger.severe(String.format("Propagation: %s isn't one of the supported values for ADIF field PROP_MODE", value));
                        }
                        rec.setPropMode(mode);
                        break;
                    }
                    case "SatelliteName": {
                        if (this.apSatelliteService.getSatellite(value, rec.getQsoDate()) != null) {
                            rec.setSatName(value.toUpperCase());
                            break;
                        }
                        logger.warning(String.format("Satellite: %s isn't currently supported", value));
                        break;
                    }
                    case "SatelliteMode": {
                        rec.setSatMode(value);
                        break;
                    }
                    case "Notes": {
                        rec.setNotes(value);
                        break;
                    }
                    case "Alt": {
                        try {
                            rec.setAltitude(FieldParseUtils.parseAlt(value));
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            logger.warning(String.format("Couldn't parse their altitude field: %s, leaving it unmapped", value));
                            unmapped.put(key, value);
                        }
                    }
                }
            } else {
                unmapped.put(key, value);
            }
            if (callsignWithInvalidActivity != null) {
                results.addContactWithDubiousLocation(callsignWithInvalidActivity);
            }
            this.issueWarnings(rec);
        }
        if (coords != null || latitude != null && longitude != null) {
            if (coords == null) {
                coords = new GlobalCoords3D((double)latitude, (double)longitude, LocationSource.OVERRIDE, LocationAccuracy.LAT_LONG);
            }
            qso.getTo().setCoordinates(coords);
            rec.setCoordinates(coords);
            rec.setGridsquare(MaidenheadLocatorConversion.coordsToLocator(coords));
            logger.info(String.format("Override location of %s: %s", rec.getCall(), rec.getCoordinates().toString()));
        }
    }

    private void issueWarnings(Adif3Record rec) {
        String callsign = rec.getCall().trim().toUpperCase();
        boolean portable = CallsignUtils.isPortable(callsign);
        if (portable && rec.getMyCoordinates() == null && rec.getGridsquare() == null) {
            logger.warning(String.format("Contact with non-fixed station %s at %s does not have a location defined", callsign, rec.getTimeOn()));
        }
    }
}

