/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform.comment;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.adif3.transform.TransformResults;
import uk.m0nom.adifproc.adif3.transform.comment.CommentTransformer;
import uk.m0nom.adifproc.adif3.transform.tokenizer.ColonTokenizer;
import uk.m0nom.adifproc.adif3.transform.tokenizer.CommentTokenizer;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3Field;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3FieldValidationResult;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3RecordPopulator;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3Schema;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3SchemaLoader;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3TypeValidationResult;

@Service
public class SchemaBasedCommentTransformer
implements CommentTransformer {
    private static final Logger logger = Logger.getLogger(SchemaBasedCommentTransformer.class.getName());
    private final Adif3Schema schema;
    private final CommentTokenizer tokenizer;

    public SchemaBasedCommentTransformer(ColonTokenizer tokenizer) {
        this.tokenizer = tokenizer;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("adif/adx314.xsd");
        this.schema = Adif3SchemaLoader.loadAdif3Schema(inputStream);
    }

    @Override
    public void transformComment(Qso qso, String comment, Map<String, String> unmapped, TransformResults results) {
        if (Strings.isNullOrEmpty((String)comment)) {
            return;
        }
        Adif3Record rec = qso.getRecord();
        Map<String, String> tokens = this.tokenizer.tokenize(comment);
        if (tokens.size() == 0) {
            unmapped.put(comment, "");
            return;
        }
        for (String fieldName : tokens.keySet()) {
            String fieldValue = tokens.get(fieldName).trim();
            Adif3Field field = this.schema.getField(fieldName);
            if (field != null) {
                Adif3FieldValidationResult validationResult = field.isValid(fieldValue);
                if (validationResult.isValid()) {
                    Adif3RecordPopulator.addFieldToRecord(rec, field, fieldValue);
                } else {
                    this.addWarningAboutValidationError(results, fieldName, fieldValue, validationResult);
                    unmapped.put(fieldName, fieldValue);
                }
            } else {
                unmapped.put(fieldName, fieldValue);
            }
            logger.info(String.format("Transforming comment: %s with value: %s", fieldName, fieldValue));
        }
    }

    private void addWarningAboutValidationError(TransformResults results, String fieldName, String fieldValue, Adif3FieldValidationResult validationResult) {
        String warning;
        Adif3TypeValidationResult typeValidationResult;
        StringBuilder sb = new StringBuilder(String.format("Validation of comment field '%s:%s' failed because", fieldName, fieldValue));
        if (!validationResult.isDefinedWhenRequired()) {
            sb.append(" a value is required, ");
        }
        if (!(typeValidationResult = validationResult.getTypeValidationResult()).isWithinMin()) {
            sb.append(" value is too low, ");
        }
        if (!typeValidationResult.isWithinMax()) {
            sb.append(" value is too high, ");
        }
        if (!typeValidationResult.isMatchingPattern()) {
            sb.append(" value is invalid, ");
        }
        if ((warning = sb.toString()).endsWith(", ")) {
            results.addWarning(StringUtils.left((String)sb.toString(), (int)(warning.length() - 2)));
        }
        results.addWarning(warning);
    }
}

