/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.transform.comment.parsers;

import org.apache.commons.lang3.StringUtils;

public class FieldParseUtils {
    public static double parsePwr(String value) throws NumberFormatException {
        String pwr = value.toLowerCase().trim();
        if (pwr.endsWith("w")) {
            pwr = StringUtils.replace((String)pwr, (String)"w", (String)"");
        } else if (pwr.endsWith(" w")) {
            pwr = StringUtils.replace((String)pwr, (String)" w", (String)"");
        } else if (pwr.endsWith(" watt")) {
            pwr = StringUtils.replace((String)pwr, (String)" watt", (String)"");
        } else if (pwr.endsWith(" watts")) {
            pwr = StringUtils.replace((String)pwr, (String)" watts", (String)"");
        }
        if (pwr.endsWith("k")) {
            pwr = StringUtils.replace((String)pwr, (String)"k", (String)"000");
        }
        return Double.parseDouble(pwr);
    }

    public static double parseAlt(String value) throws NumberFormatException {
        if (value == null) {
            return 0.0;
        }
        String alt = value.toLowerCase().trim();
        double multiplier = 1.0;
        if (alt.endsWith("ft")) {
            multiplier = 0.3047999902464003;
            alt = StringUtils.replace((String)alt, (String)"ft", (String)"").trim();
        } else if (alt.endsWith("m")) {
            alt = StringUtils.replace((String)alt, (String)"m", (String)"").trim();
        }
        return Double.parseDouble(alt) * multiplier;
    }
}

