/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.adif3.xsdquery;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import uk.m0nom.adifproc.adif3.xsdquery.Adif3TypeValidationResult;

public class Adif3Type
implements Comparable<Adif3Type> {
    private String name;
    private String baseType;
    private Pattern regex;
    private boolean preserveWhiteSpace;
    private Integer minInclusive;
    private Integer maxInclusive;
    private List<String> POSITIVE_BASE_TYPES = Arrays.asList("PositiveInteger", "IntegerGE0", "UnsignedInt", "NumberGE0");

    public Adif3TypeValidationResult isValid(String value) {
        Adif3TypeValidationResult result = new Adif3TypeValidationResult();
        result.setBaseType(this.checkBaseType(value));
        if (this.regex != null) {
            result.setMatchingPattern(this.regex.matcher(value).matches());
        }
        if (this.minInclusive != null || this.maxInclusive != null) {
            Integer intVal = Integer.parseInt(value);
            if (this.minInclusive != null) {
                result.setWithinMin(intVal >= this.minInclusive);
            }
            if (this.maxInclusive != null) {
                result.setWithinMax(intVal <= this.maxInclusive);
            }
        }
        return result;
    }

    private boolean checkBaseType(String value) {
        boolean valid = true;
        switch (this.baseType) {
            case "xs:decimal": 
            case "PositiveInteger": 
            case "UnsignedInt": 
            case "IntegerGE0": {
                int iVal = 0;
                try {
                    iVal = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
                if (!this.POSITIVE_BASE_TYPES.contains(this.baseType) || iVal >= 0) break;
                valid = false;
                break;
            }
            case "NumberGE0": 
            case "Number": {
                double dVal = 0.0;
                try {
                    dVal = Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
                if (!this.POSITIVE_BASE_TYPES.contains(this.baseType) || !(dVal < 0.0)) break;
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public int compareTo(@NotNull Adif3Type o) {
        return this.getName().compareTo(o.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public boolean isPreserveWhiteSpace() {
        return this.preserveWhiteSpace;
    }

    public Integer getMinInclusive() {
        return this.minInclusive;
    }

    public Integer getMaxInclusive() {
        return this.maxInclusive;
    }

    public List<String> getPOSITIVE_BASE_TYPES() {
        return this.POSITIVE_BASE_TYPES;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public void setPreserveWhiteSpace(boolean preserveWhiteSpace) {
        this.preserveWhiteSpace = preserveWhiteSpace;
    }

    public void setMinInclusive(Integer minInclusive) {
        this.minInclusive = minInclusive;
    }

    public void setMaxInclusive(Integer maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public void setPOSITIVE_BASE_TYPES(List<String> POSITIVE_BASE_TYPES) {
        this.POSITIVE_BASE_TYPES = POSITIVE_BASE_TYPES;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Adif3Type)) {
            return false;
        }
        Adif3Type other = (Adif3Type)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreserveWhiteSpace() != other.isPreserveWhiteSpace()) {
            return false;
        }
        Integer this$minInclusive = this.getMinInclusive();
        Integer other$minInclusive = other.getMinInclusive();
        if (this$minInclusive == null ? other$minInclusive != null : !((Object)this$minInclusive).equals(other$minInclusive)) {
            return false;
        }
        Integer this$maxInclusive = this.getMaxInclusive();
        Integer other$maxInclusive = other.getMaxInclusive();
        if (this$maxInclusive == null ? other$maxInclusive != null : !((Object)this$maxInclusive).equals(other$maxInclusive)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$baseType = this.getBaseType();
        String other$baseType = other.getBaseType();
        if (this$baseType == null ? other$baseType != null : !this$baseType.equals(other$baseType)) {
            return false;
        }
        Pattern this$regex = this.getRegex();
        Pattern other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        List<String> this$POSITIVE_BASE_TYPES = this.getPOSITIVE_BASE_TYPES();
        List<String> other$POSITIVE_BASE_TYPES = other.getPOSITIVE_BASE_TYPES();
        return !(this$POSITIVE_BASE_TYPES == null ? other$POSITIVE_BASE_TYPES != null : !((Object)this$POSITIVE_BASE_TYPES).equals(other$POSITIVE_BASE_TYPES));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Adif3Type;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreserveWhiteSpace() ? 79 : 97);
        Integer $minInclusive = this.getMinInclusive();
        result = result * 59 + ($minInclusive == null ? 43 : ((Object)$minInclusive).hashCode());
        Integer $maxInclusive = this.getMaxInclusive();
        result = result * 59 + ($maxInclusive == null ? 43 : ((Object)$maxInclusive).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $baseType = this.getBaseType();
        result = result * 59 + ($baseType == null ? 43 : $baseType.hashCode());
        Pattern $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        List<String> $POSITIVE_BASE_TYPES = this.getPOSITIVE_BASE_TYPES();
        result = result * 59 + ($POSITIVE_BASE_TYPES == null ? 43 : ((Object)$POSITIVE_BASE_TYPES).hashCode());
        return result;
    }

    public String toString() {
        return "Adif3Type(name=" + this.getName() + ", baseType=" + this.getBaseType() + ", regex=" + String.valueOf(this.getRegex()) + ", preserveWhiteSpace=" + this.isPreserveWhiteSpace() + ", minInclusive=" + this.getMinInclusive() + ", maxInclusive=" + this.getMaxInclusive() + ", POSITIVE_BASE_TYPES=" + String.valueOf(this.getPOSITIVE_BASE_TYPES()) + ")";
    }
}

