/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.comms;

import java.util.List;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.Propagation;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.comms.CommsLinkGenerator;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.comms.PropagationApex;
import uk.m0nom.adifproc.comms.PropagationUtils;
import uk.m0nom.adifproc.comms.Troposphere;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.geodesic.GeodesicUtils;

public class TroposphericDuctingPropagation
implements CommsLinkGenerator {
    @Override
    public CommsLinkResult getCommunicationsLink(TransformControl control, GlobalCoords3D start, GlobalCoords3D end, Adif3Record rec) {
        CommsLinkResult result = PropagationUtils.calculateGeodeticCurve(start, end);
        double avgAltitude = 0.0;
        double avgAngle = 0.0;
        double avgBase = 0.0;
        Propagation mode = null;
        List<PropagationApex> bounces = new Troposphere().getBounces(result.getDistanceInKm());
        double skyDistance = GeodesicUtils.calculatePath(result.getPath(), bounces, start, end, result.getAzimuth());
        result.setSkyDistance(skyDistance);
        for (PropagationApex bounce : bounces) {
            avgAltitude += bounce.getApexHeight();
            avgAngle += bounce.getRadiationAngle();
            avgBase += bounce.getBaseHeight();
            mode = bounce.getMode();
        }
        result.setPropagation(mode);
        result.setAltitude(avgAltitude / (double)bounces.size());
        result.setBase(avgBase / (double)bounces.size());
        result.setFromAngle(avgAngle / (double)bounces.size());
        result.setBounces(bounces.size());
        return result;
    }
}

