/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.comms.ionosphere;

import java.time.LocalTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.marsik.ham.adif.enums.Propagation;
import uk.m0nom.adifproc.comms.PropagationApex;
import uk.m0nom.adifproc.comms.PropagationModePredictor;
import uk.m0nom.adifproc.comms.ionosphere.IonosphericApexCalculator;
import uk.m0nom.adifproc.comms.ionosphere.IonosphericLayer;

public class Ionosphere {
    public static final double HF_ANTENNA_DEFAULT_TAKEOFF_ANGLE = 6.0;
    private final Map<String, IonosphericLayer> dayTimeLayers = new HashMap<String, IonosphericLayer>();
    private final Map<String, IonosphericLayer> nightTimeLayers;
    private static final double GROUNDWAVE_BOUNCE_ALT = 12.0;
    public static final double MAXIMUM_GROUND_WAVE_DISTANCE_HIGH_BANDS_KM = 500.0;
    public static final double MAXIMUM_GROUND_WAVE_DISTANCE_LOW_BANDS_KM = 50.0;
    public static final double MAX_FREQUENCY = 22000.0;

    public Ionosphere() {
        this.dayTimeLayers.put("D", new IonosphericLayer("D", this.metersFromKm(48.0), this.metersFromKm(90.0)));
        this.dayTimeLayers.put("E", new IonosphericLayer("E", this.metersFromKm(90.0), this.metersFromKm(150.0)));
        this.dayTimeLayers.put("F1", new IonosphericLayer("F1", this.metersFromKm(150.0), this.metersFromKm(250.0)));
        this.dayTimeLayers.put("F2", new IonosphericLayer("F2", this.metersFromKm(250.0), this.metersFromKm(500.0)));
        this.nightTimeLayers = new HashMap<String, IonosphericLayer>();
        this.nightTimeLayers.put("D", new IonosphericLayer("D", this.metersFromKm(48.0), this.metersFromKm(90.0)));
        this.nightTimeLayers.put("E", new IonosphericLayer("E", this.metersFromKm(90.0), this.metersFromKm(150.0)));
        this.dayTimeLayers.put("F1", new IonosphericLayer("F1", this.metersFromKm(150.0), this.metersFromKm(250.0)));
        this.dayTimeLayers.put("F2", new IonosphericLayer("F2", this.metersFromKm(250.0), this.metersFromKm(500.0)));
    }

    private double metersFromKm(double kms) {
        return kms * 1000.0;
    }

    public List<PropagationApex> getBounces(Propagation mode, double frequencyInKhz, double distanceInKm, LocalTime timeOfDay, double myAltitude, double theirAltitude, double hfAntennaTakeoffAngle) {
        LinkedList<PropagationApex> bounces = new LinkedList<PropagationApex>();
        if (mode == null) {
            mode = PropagationModePredictor.predictPropagationMode(frequencyInKhz, distanceInKm);
        }
        if (mode != null) {
            switch (mode) {
                case F2_REFLECTION: {
                    Map<String, IonosphericLayer> layers = this.getLayerForTimeOfDay(timeOfDay);
                    IonosphericLayer bounceLayer = layers.get("F2");
                    double altInMetres = this.calculateBounceHeight(frequencyInKhz, bounceLayer);
                    double altInKm = altInMetres / 1000.0;
                    PropagationApex apexResult = IonosphericApexCalculator.calculateDistanceOfApex(altInKm, hfAntennaTakeoffAngle);
                    int hops = this.calculateNumberOfHops(distanceInKm, apexResult);
                    apexResult = this.adjustApexBasedOnHops(distanceInKm, apexResult, hops);
                    for (int i = 0; i < hops; ++i) {
                        double hopDistance = apexResult.getDistanceAcrossEarth() * 2.0;
                        PropagationApex bounce = new PropagationApex(mode, hopDistance, apexResult.getDistanceToApex() * 1000.0, altInKm * 1000.0, 0.0, apexResult.getRadiationAngle());
                        bounces.add(bounce);
                    }
                    if (myAltitude > 0.0) {
                        ((PropagationApex)bounces.get(0)).setBaseHeight(myAltitude);
                    }
                    if (!(theirAltitude > 0.0)) break;
                    ((PropagationApex)bounces.get(hops - 1)).setBaseHeight(theirAltitude);
                    break;
                }
                case SPORADIC_E: {
                    Map<String, IonosphericLayer> layers = this.getLayerForTimeOfDay(timeOfDay);
                    IonosphericLayer bounceLayer = layers.get("E");
                    double altInKm = bounceLayer.getAverageHeight() / 1000.0;
                    bounces.add(new PropagationApex(mode, distanceInKm, altInKm * 1000.0, altInKm * 1000.0, 0.0, 0.0));
                }
            }
        }
        if (mode == null || bounces.size() == 0) {
            double adjustAlt = Math.max(myAltitude, theirAltitude);
            double apexHeight = Math.max(12.0 * distanceInKm, adjustAlt);
            PropagationApex bounce = new PropagationApex(null, distanceInKm, apexHeight, apexHeight, 0.0, 0.0);
            bounces.add(bounce);
        }
        return bounces;
    }

    private PropagationApex adjustApexBasedOnHops(double distanceAcrossEarthInKm, PropagationApex apexResult, int hopCount) {
        double apexDistance = distanceAcrossEarthInKm / 2.0;
        double takeOffAngle = IonosphericApexCalculator.calculateTakeoffAngleFromDistanceAcrossEarth(apexDistance / (double)hopCount, apexResult.getApexHeight());
        return IonosphericApexCalculator.calculateDistanceOfApex(apexResult.getApexHeight(), takeOffAngle);
    }

    private double calculateBounceHeight(double frequencyInKhz, IonosphericLayer bounceLayer) {
        double bounceHeight = bounceLayer.getLower();
        if (frequencyInKhz < 22000.0 && frequencyInKhz > 1800.0) {
            double delta = (frequencyInKhz - 1800.0) / 20200.0;
            double layerWidth = bounceLayer.getUpper() - bounceLayer.getLower();
            bounceHeight = bounceLayer.getLower() + delta * layerWidth;
        } else if (frequencyInKhz < 1800.0) {
            bounceHeight = bounceLayer.getUpper();
        }
        return bounceHeight;
    }

    private int calculateNumberOfHops(double distanceInKm, PropagationApex apexResult) {
        double singleHopDistance = apexResult.getDistanceAcrossEarth() * 2.0;
        return (int)Math.floor(distanceInKm / singleHopDistance) + 1;
    }

    private Map<String, IonosphericLayer> getLayerForTimeOfDay(LocalTime timeOfDay) {
        if (timeOfDay.isAfter(LocalTime.of(18, 0)) && timeOfDay.isBefore(LocalTime.of(8, 0))) {
            return this.nightTimeLayers;
        }
        return this.dayTimeLayers;
    }
}

