/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.coords;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LatLongUtils;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationFormatter;
import uk.m0nom.adifproc.coords.LocationParser;
import uk.m0nom.adifproc.coords.LocationSource;

public class DegreesMinutesSecondsLatLongParser
implements LocationParser,
LocationFormatter {
    private static final String DMS_PATTERN = "\\s*([-+]*)\\s*(\\d+)\\s*\u00b0*\\s*(\\d+)\\s*'*\\s*(\\d+)\\s*\"*\\s*";
    private static final Pattern PATTERN = Pattern.compile("^\\s*([-+]*)\\s*(\\d+)\\s*\u00b0*\\s*(\\d+)\\s*'*\\s*(\\d+)\\s*\"*\\s*,*\\s*([-+]*)\\s*(\\d+)\\s*\u00b0*\\s*(\\d+)\\s*'*\\s*(\\d+)\\s*\"*\\s*$");

    @Override
    public Pattern getPattern() {
        return PATTERN;
    }

    @Override
    public GlobalCoords3D parse(LocationSource source, String location) {
        Matcher matcher = this.getPattern().matcher(location);
        if (matcher.find()) {
            String latNegative = matcher.group(1);
            String latDegrees = matcher.group(2);
            String latMinutes = matcher.group(3);
            String latSeconds = matcher.group(4);
            String longNegative = matcher.group(5);
            String longDegrees = matcher.group(6);
            String longMinutes = matcher.group(7);
            String longSeconds = matcher.group(8);
            Double latitude = LatLongUtils.parseDegreesMinutesSeconds(latDegrees, latMinutes, latSeconds, "-".equalsIgnoreCase(latNegative));
            Double longitude = LatLongUtils.parseDegreesMinutesSeconds(longDegrees, longMinutes, longSeconds, "-".equalsIgnoreCase(longNegative));
            if (latitude != null && longitude != null) {
                return new GlobalCoords3D((double)latitude, (double)longitude, source, LocationAccuracy.LAT_LONG);
            }
        }
        return null;
    }

    @Override
    public String format(GlobalCoordinates coords) {
        return String.format("%.0f\u00b0 %.0f' %d\", %.0f\u00b0 %.0f' %d\"", LatLongUtils.getDegreesLat(coords), Math.abs(LatLongUtils.getWholeMinutesLat(coords)), Math.abs(Math.round(LatLongUtils.getSecondsLat(coords))), LatLongUtils.getDegreesLong(coords), Math.abs(LatLongUtils.getWholeMinutesLong(coords)), Math.abs(Math.round(LatLongUtils.getSecondsLong(coords))));
    }

    @Override
    public String getName() {
        return "Degrees Minutes Seconds Lat/Long";
    }
}

