/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.coords;

import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationInfo;
import uk.m0nom.adifproc.coords.LocationSource;

public class GlobalCoords3D
extends GlobalCoordinates {
    private LocationInfo locationInfo;
    private Double altitude = 0.0;

    public GlobalCoords3D(double latitude, double longitude) {
        super(latitude, longitude);
        this.setLocationInfo(new LocationInfo(LocationAccuracy.LAT_LONG));
    }

    public GlobalCoords3D(GlobalCoordinates coordinates, LocationSource source, LocationAccuracy accuracy) {
        super(coordinates.getLatitude(), coordinates.getLongitude());
        this.setLocationInfo(source, accuracy);
    }

    public GlobalCoords3D(GlobalCoordinates coordinates, Double altitude) {
        super(coordinates.getLatitude(), coordinates.getLongitude());
        this.setAltitude(altitude);
        this.setLocationInfo(LocationSource.UNDEFINED, LocationAccuracy.LAT_LONG);
    }

    public GlobalCoords3D(double latitude, double longitude, Double altitude) {
        super(latitude, longitude);
        this.setAltitude(altitude);
        this.setLocationInfo(new LocationInfo(LocationAccuracy.LAT_LONG));
    }

    public GlobalCoords3D(double latitude, double longitude, Double altitude, LocationInfo locationInfo) {
        super(latitude, longitude);
        this.setAltitude(altitude);
        this.setLocationInfo(locationInfo);
    }

    public GlobalCoords3D(double latitude, double longitude, LocationSource source, LocationAccuracy accuracy) {
        super(latitude, longitude);
        this.setLocationInfo(source, accuracy);
    }

    public GlobalCoords3D(double latitude, double longitude, Double altitude, LocationSource source, LocationAccuracy accuracy) {
        super(latitude, longitude);
        this.setAltitude(altitude);
        this.setLocationInfo(source, accuracy);
    }

    public GlobalCoords3D(GlobalCoordinates coordinates, Double altitude, LocationInfo locationInfo) {
        super(coordinates.getLatitude(), coordinates.getLongitude());
        this.setAltitude(altitude);
        this.setLocationInfo(locationInfo);
    }

    public void setLocationInfo(LocationSource source, LocationAccuracy accuracy) {
        this.setLocationInfo(new LocationInfo(accuracy, source));
    }

    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public void setLocationInfo(LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
    }

    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }
}

