/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.coords;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gavaghan.geodesy.GlobalCoordinates;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationFormatter;
import uk.m0nom.adifproc.coords.LocationParser;
import uk.m0nom.adifproc.coords.LocationSource;
import uk.m0nom.adifproc.irishgrid.IrishGridConverter;
import uk.m0nom.adifproc.irishgrid.IrishGridConverterResult;

public class IrishGridParser5Digit
implements LocationParser,
LocationFormatter {
    private static final Pattern PATTERN = Pattern.compile("^([A-Z]{1})\\s*(\\d{5})\\s*(\\d{5})$");

    @Override
    public Pattern getPattern() {
        return PATTERN;
    }

    @Override
    public GlobalCoords3D parse(LocationSource source, String locationString) {
        Matcher matcher = this.getPattern().matcher(locationString);
        if (matcher.find()) {
            String gridRef = matcher.group(1);
            String easting = matcher.group(2);
            String northing = matcher.group(3);
            IrishGridConverter converter = new IrishGridConverter();
            String irishGridRef = String.format("%s %s %s", gridRef, easting, northing);
            IrishGridConverterResult result = converter.convertIrishGridRefToWsg84(irishGridRef);
            if (result.isSuccess()) {
                return result.getCoords();
            }
        }
        return null;
    }

    @Override
    public String format(GlobalCoordinates coords) {
        IrishGridConverter converter = new IrishGridConverter();
        IrishGridConverterResult result = converter.convertCoordsToIrishGridRef(coords);
        if (result.isSuccess()) {
            return result.getIrishGridRef();
        }
        return "Irish Grid Ref: undefined";
    }

    @Override
    public String getName() {
        return "Irish Grid Ref";
    }
}

