/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.coords;

import java.util.regex.Pattern;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.marsik.ham.adif.types.Wwff;
import uk.m0nom.adifproc.activity.ActivityDatabase;
import uk.m0nom.adifproc.activity.wwff.WwffInfo;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.coords.LocationAccuracy;
import uk.m0nom.adifproc.coords.LocationParser;
import uk.m0nom.adifproc.coords.LocationSource;

public class WwffLocationParser
implements LocationParser {
    private ActivityDatabase wwffDatabase;
    private static final Pattern PATTERN = Wwff.WWFF_RE;

    public WwffLocationParser(ActivityDatabase wwffDatabase) {
        this.setWwffDatabase(wwffDatabase);
    }

    @Override
    public Pattern getPattern() {
        return PATTERN;
    }

    @Override
    public GlobalCoords3D parse(LocationSource source, String location) {
        WwffInfo wwff = (WwffInfo)this.wwffDatabase.get(location);
        if (wwff != null && wwff.hasCoords()) {
            return new GlobalCoords3D((GlobalCoordinates)wwff.getCoords(), LocationSource.ACTIVITY, LocationAccuracy.LAT_LONG);
        }
        return null;
    }

    @Override
    public String getName() {
        return "WWFF Location";
    }

    public ActivityDatabase getWwffDatabase() {
        return this.wwffDatabase;
    }

    public void setWwffDatabase(ActivityDatabase wwffDatabase) {
        this.wwffDatabase = wwffDatabase;
    }
}

