/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.dxcc;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import uk.m0nom.adifproc.dxcc.JsonDxccEntity;

public class DxccEntity {
    private final DateTimeFormatter dxccDateFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    private JsonDxccEntity jsonEntity;
    private Collection<String> prefixes;
    private LocalDate validStartDate;
    private LocalDate validEndDate;

    public DxccEntity(JsonDxccEntity jsonEntity) throws ParseException {
        this.jsonEntity = jsonEntity;
        this.setValidStartDate(this.parseDxccDateString(jsonEntity.getValidStart()));
        this.setValidEndDate(this.parseDxccDateString(jsonEntity.getValidEnd()));
    }

    private LocalDate parseDxccDateString(String dateString) throws ParseException {
        LocalDate date = null;
        if (!"".equals(dateString)) {
            date = LocalDate.parse(dateString, this.dxccDateFormatter);
        }
        return date;
    }

    public int getEntityCode() {
        return this.jsonEntity.getEntityCode();
    }

    public String getPrefixRegex() {
        return this.jsonEntity.getPrefixRegex();
    }

    public String getPrefix() {
        return this.jsonEntity.getPrefix();
    }

    public String getName() {
        return this.jsonEntity.getName();
    }

    public String getCountryCode() {
        return this.jsonEntity.getCountryCode();
    }

    public String getFlag() {
        return this.jsonEntity.getFlag();
    }

    public Collection<Integer> getItu() {
        return this.jsonEntity.getItu();
    }

    public Collection<Integer> getCq() {
        return this.jsonEntity.getCq();
    }

    public boolean hasValidStart() {
        return this.validStartDate != null;
    }

    public boolean hasValidEnd() {
        return this.validEndDate != null;
    }

    public boolean isValidForDate(LocalDate date) {
        boolean valid = false;
        valid = !this.hasValidStart() || date.isAfter(this.getValidStartDate());
        return valid &= !this.hasValidEnd() || date.isBefore(this.getValidEndDate());
    }

    public DateTimeFormatter getDxccDateFormatter() {
        return this.dxccDateFormatter;
    }

    public JsonDxccEntity getJsonEntity() {
        return this.jsonEntity;
    }

    public Collection<String> getPrefixes() {
        return this.prefixes;
    }

    public LocalDate getValidStartDate() {
        return this.validStartDate;
    }

    public LocalDate getValidEndDate() {
        return this.validEndDate;
    }

    public void setJsonEntity(JsonDxccEntity jsonEntity) {
        this.jsonEntity = jsonEntity;
    }

    public void setPrefixes(Collection<String> prefixes) {
        this.prefixes = prefixes;
    }

    public void setValidStartDate(LocalDate validStartDate) {
        this.validStartDate = validStartDate;
    }

    public void setValidEndDate(LocalDate validEndDate) {
        this.validEndDate = validEndDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DxccEntity)) {
            return false;
        }
        DxccEntity other = (DxccEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DateTimeFormatter this$dxccDateFormatter = this.getDxccDateFormatter();
        DateTimeFormatter other$dxccDateFormatter = other.getDxccDateFormatter();
        if (this$dxccDateFormatter == null ? other$dxccDateFormatter != null : !this$dxccDateFormatter.equals(other$dxccDateFormatter)) {
            return false;
        }
        JsonDxccEntity this$jsonEntity = this.getJsonEntity();
        JsonDxccEntity other$jsonEntity = other.getJsonEntity();
        if (this$jsonEntity == null ? other$jsonEntity != null : !this$jsonEntity.equals(other$jsonEntity)) {
            return false;
        }
        Collection<String> this$prefixes = this.getPrefixes();
        Collection<String> other$prefixes = other.getPrefixes();
        if (this$prefixes == null ? other$prefixes != null : !((Object)this$prefixes).equals(other$prefixes)) {
            return false;
        }
        LocalDate this$validStartDate = this.getValidStartDate();
        LocalDate other$validStartDate = other.getValidStartDate();
        if (this$validStartDate == null ? other$validStartDate != null : !((Object)this$validStartDate).equals(other$validStartDate)) {
            return false;
        }
        LocalDate this$validEndDate = this.getValidEndDate();
        LocalDate other$validEndDate = other.getValidEndDate();
        return !(this$validEndDate == null ? other$validEndDate != null : !((Object)this$validEndDate).equals(other$validEndDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DxccEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTimeFormatter $dxccDateFormatter = this.getDxccDateFormatter();
        result = result * 59 + ($dxccDateFormatter == null ? 43 : $dxccDateFormatter.hashCode());
        JsonDxccEntity $jsonEntity = this.getJsonEntity();
        result = result * 59 + ($jsonEntity == null ? 43 : $jsonEntity.hashCode());
        Collection<String> $prefixes = this.getPrefixes();
        result = result * 59 + ($prefixes == null ? 43 : ((Object)$prefixes).hashCode());
        LocalDate $validStartDate = this.getValidStartDate();
        result = result * 59 + ($validStartDate == null ? 43 : ((Object)$validStartDate).hashCode());
        LocalDate $validEndDate = this.getValidEndDate();
        result = result * 59 + ($validEndDate == null ? 43 : ((Object)$validEndDate).hashCode());
        return result;
    }

    public String toString() {
        return "DxccEntity(dxccDateFormatter=" + String.valueOf(this.getDxccDateFormatter()) + ", jsonEntity=" + String.valueOf(this.getJsonEntity()) + ", prefixes=" + String.valueOf(this.getPrefixes()) + ", validStartDate=" + String.valueOf(this.getValidStartDate()) + ", validEndDate=" + String.valueOf(this.getValidEndDate()) + ")";
    }
}

