/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.file.InternalFileService;

@Profile(value={"dev"})
@Service
public class LocalInternalFileService
implements InternalFileService {
    private final String rootPath;

    public LocalInternalFileService() {
        Path resourceDirectory = Paths.get("src", "main", "resources");
        this.rootPath = resourceDirectory.toFile().getAbsolutePath();
    }

    @Override
    public Set<String> getFiles(String dir) {
        Path filePath = Paths.get(this.rootPath, dir);
        HashSet<String> fileList = new HashSet<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(filePath);){
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                fileList.add(path.getFileName().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileList;
    }

    @Override
    public String readFile(String folder, String file) {
        Path filePath = Paths.get(this.rootPath, folder, file);
        try {
            return Files.readString(filePath);
        }
        catch (IOException e) {
            return null;
        }
    }
}

