/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.activity;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Style;
import java.time.LocalDate;
import java.util.Locale;
import uk.m0nom.adifproc.activity.Activity;
import uk.m0nom.adifproc.activity.ActivityDatabaseService;
import uk.m0nom.adifproc.adif3.contacts.Station;
import uk.m0nom.adifproc.adif3.control.TransformControl;
import uk.m0nom.adifproc.coords.GlobalCoords3D;
import uk.m0nom.adifproc.kml.KmlUtils;
import uk.m0nom.adifproc.kml.info.KmlActivityInfoPanel;

public class KmlLocalActivities {
    public static final String DEFAULT_RADIUS_IN_KM = "5";

    public void addLocalActivities(TransformControl control, Document doc, Folder folder, Station to, ActivityDatabaseService activities) {
        LocalDate onDate = to.getQsos().get(0).getRecord().getQsoDate();
        to.getActivities().forEach(activity -> activities.getDatabase(activity.getType()).findActivitiesInRadius((Activity)activity, control.getKmlLocalActivationSitesRadius(), onDate).forEach(localActivity -> this.addActivityMarker(control, doc, folder, (Activity)localActivity)));
    }

    public void addActivityMarker(TransformControl control, Document document, Folder folder, Activity activity) {
        String id = activity.getRef();
        GlobalCoords3D coords = activity.getCoords();
        if (coords != null) {
            double longitude = coords.getLongitude();
            double latitude = coords.getLatitude();
            double altitude = 0.0;
            if (activity.hasAltitude()) {
                altitude = activity.getAltitude() + 100.0;
            }
            Icon icon = new Icon().withHref(String.format("http://maps.google.com/mapfiles/kml/paddle/%c.png", Character.valueOf(activity.getType().name().toUpperCase(Locale.ROOT).charAt(0))));
            Style style = document.createAndAddStyle().withId(KmlUtils.getStyleId(id));
            style.createAndSetIconStyle().withScale(1.0).withIcon(icon);
            style.createAndSetLabelStyle().withColor("ffffffff").withScale(0.75);
            style.createAndSetLineStyle().withColor("000000ff").withWidth(3.0);
            String htmlPanelContent = new KmlActivityInfoPanel().getPanelContentForActivity(control, activity);
            Placemark placemark = folder.createAndAddPlacemark();
            placemark.withName(id).withId(id).withDescription(htmlPanelContent).withStyleUrl(KmlUtils.getStyleUrl(id)).createAndSetLookAt().withLongitude(longitude).withLatitude(latitude).withAltitude(altitude).withRange(500.0);
            placemark.createAndSetPoint().addToCoordinates(longitude, latitude);
        }
    }
}

