/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.kml.info;

import org.apache.commons.lang3.StringUtils;
import org.marsik.ham.adif.Adif3Record;
import org.marsik.ham.adif.enums.AntPath;
import org.marsik.ham.adif.enums.Propagation;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import uk.m0nom.adifproc.adif3.contacts.Qso;
import uk.m0nom.adifproc.comms.CommsLinkResult;
import uk.m0nom.adifproc.util.FrequencyFormatter;

public class KmlContactInfoPanel {
    private static final double ONE_HZ = 1.0E-6;

    public String getPanelContentForCommsLink(Qso qso, CommsLinkResult result, TemplateEngine templateEngine) {
        Adif3Record rec = qso.getRecord();
        Context context = new Context();
        context.setVariable("qsoDate", (Object)rec.getQsoDate().toString());
        context.setVariable("qsoTime", (Object)rec.getTimeOn().toString());
        context.setVariable("call", (Object)rec.getCall());
        context.setVariable("stationCallsign", (Object)rec.getStationCallsign());
        if (qso.getTo().getQrzInfo() != null) {
            context.setVariable("callForQrz", (Object)qso.getTo().getQrzInfo().getCall());
        } else {
            context.setVariable("callForQrz", (Object)rec.getCall());
        }
        if (qso.getFrom().getQrzInfo() != null) {
            context.setVariable("stationCallsignForQrz", (Object)qso.getFrom().getQrzInfo().getCall());
        } else {
            context.setVariable("stationCallsignForQrz", (Object)rec.getStationCallsign());
        }
        if (rec.getBand() != null) {
            if (rec.getBandRx() != null) {
                context.setVariable("uplinkBand", (Object)StringUtils.replace((String)rec.getBand().name(), (String)"BAND_", (String)"").toLowerCase());
                context.setVariable("downlinkBand", (Object)StringUtils.replace((String)rec.getBandRx().name(), (String)"BAND_", (String)"").toLowerCase());
            } else {
                context.setVariable("band", (Object)StringUtils.replace((String)rec.getBand().name(), (String)"BAND_", (String)"").toLowerCase());
            }
        }
        if (rec.getMode() != null) {
            context.setVariable("mode", (Object)rec.getMode().toString());
        }
        if (rec.getFreq() != null) {
            context.setVariable("freq", (Object)FrequencyFormatter.formatFrequency(rec.getFreq()));
            if (rec.getFreqRx() != null && Math.abs(rec.getFreq() - rec.getFreqRx()) >= 1.0E-6) {
                context.setVariable("downlinkFreq", (Object)FrequencyFormatter.formatFrequency(rec.getFreqRx()));
            }
        }
        if (rec.getTxPwr() != null) {
            context.setVariable("txPwr", (Object)String.format("%,.1f", rec.getTxPwr()));
        }
        context.setVariable("gndDist", (Object)String.format("%,.0f", result.getDistanceInKm()));
        context.setVariable("azimuth", (Object)String.format("%03.03f", result.getAzimuth()));
        if (result.getPropagation() != null) {
            switch (result.getPropagation()) {
                case F2_REFLECTION: {
                    context.setVariable("skyDist", (Object)String.format("%,.0f", result.getSkyDistance()));
                    context.setVariable("bounces", (Object)String.format("%d", result.getBounces()));
                    context.setVariable("antPath", (Object)(rec.getAntPath() == null ? AntPath.SHORT : rec.getAntPath()));
                    break;
                }
                case SATELLITE: {
                    context.setVariable("satName", (Object)qso.getRecord().getSatName());
                    context.setVariable("satAlt", (Object)String.format("%,.0f km", result.getAltitude() / 1000.0));
                    break;
                }
                case TROPOSPHERIC_DUCTING: {
                    context.setVariable("bounces", (Object)String.format("%d", result.getBounces()));
                    context.setVariable("ductTop", (Object)String.format("%,.0f", result.getAltitude()));
                    context.setVariable("ductBase", (Object)String.format("%,.0f", result.getBase()));
                }
            }
        }
        if (result.getAltitude() > 9999.99) {
            context.setVariable("avgAlt", (Object)String.format("%,.0f km", result.getAltitude() / 1000.0));
        } else if (result.getPropagation() != Propagation.INTERNET) {
            context.setVariable("avgAlt", (Object)String.format("%,.0f metres", result.getAltitude()));
        }
        if (result.getPropagation() != Propagation.INTERNET) {
            context.setVariable("fromAntenna", (Object)qso.getFrom().getAntenna().getName());
        }
        context.setVariable("angle", (Object)String.format("%,.0f\u00b0", result.getFromAngle()));
        String mode = result.getPropagation() != null ? result.getPropagation().adifCode() : "GND";
        context.setVariable("propagationMode", (Object)mode);
        String html = templateEngine.process(new TemplateSpec("KmlContactInfo", TemplateMode.XML), (IContext)context);
        return html.replace("\n", "");
    }
}

